/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import java.io.File;

public class AbsoluteFromRelativeURI {
    public static String getAbsoluteURIFromRelative(String localPath) {
        if (localPath == null || localPath.length() == 0) {
            return "";
        }
        String absolutePath = localPath;
        if (!AbsoluteFromRelativeURI.isAbsolutePath(localPath)) {
            try {
                absolutePath = AbsoluteFromRelativeURI.getAbsolutePathFromRelativePath(localPath);
            }
            catch (SecurityException se) {
                return "file:" + localPath;
            }
        }
        String urlString = null != absolutePath ? (absolutePath.startsWith(File.separator) ? "file://" + absolutePath : "file:///" + absolutePath) : "file:" + localPath;
        return AbsoluteFromRelativeURI.replaceChars(urlString);
    }

    private static String getAbsolutePathFromRelativePath(String relativePath) {
        return new File(relativePath).getAbsolutePath();
    }

    public static boolean isAbsolutePath(String systemId) {
        if (systemId == null) {
            return false;
        }
        File file = new File(systemId);
        return file.isAbsolute();
    }

    private static String replaceChars(String str) {
        StringBuilder buf = new StringBuilder(str);
        int length = buf.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = buf.charAt(i);
            if (currentChar == ' ') {
                buf.setCharAt(i, '%');
                buf.insert(i + 1, "20");
                length += 2;
                i += 2;
                continue;
            }
            if (currentChar != '\\') continue;
            buf.setCharAt(i, '/');
        }
        return buf.toString();
    }
}

