/*
 * Decompiled with CFR 0.152.
 */
package de.mediathekview.mlib.tool;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.tool.Log;
import java.io.IOException;
import java.io.InputStream;

public class MSInputStream
extends InputStream {
    private final InputStream iStream;
    private long maxBytePerSec = 0L;
    private final long startZeit = System.currentTimeMillis();
    private long bytesGelesen = 0L;
    private long gesamtVerpennt = 0L;
    private static final long warten_ms = 50L;

    public MSInputStream(InputStream in) {
        this.iStream = in;
        this.maxBytePerSec = Config.bandbreite;
        if (this.maxBytePerSec < 0L) {
            this.maxBytePerSec = 0L;
        }
    }

    @Override
    public int read() throws IOException {
        this.pause();
        int einByte = this.iStream.read();
        if (einByte != -1) {
            ++this.bytesGelesen;
        }
        return einByte;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.pause();
        int anzByte = this.iStream.read(b);
        if (anzByte != -1) {
            this.bytesGelesen += (long)anzByte;
        }
        return anzByte;
    }

    private synchronized void pause() throws IOException {
        if (this.maxBytePerSec == 0L) {
            return;
        }
        if (this.getBandbreite() > this.maxBytePerSec) {
            try {
                this.wait(50L);
                this.gesamtVerpennt += 50L;
            }
            catch (InterruptedException ex) {
                Log.errorLog(591237096, ex);
            }
        }
    }

    public long getBandbreite() {
        long dauer = (System.currentTimeMillis() - this.startZeit) / 1000L;
        if (dauer == 0L) {
            return this.bytesGelesen;
        }
        return this.bytesGelesen / dauer;
    }

    public long getTotalSleepTime() {
        return this.gesamtVerpennt;
    }

    public String toString() {
        return "Download: gelesen: " + (this.bytesGelesen > 0L ? this.bytesGelesen / 1000L : 0L) + " kB, Bandbreite: " + (this.getBandbreite() > 0L ? this.getBandbreite() / 1000L : 0L) + " kB/s , Wartezeit: " + (this.gesamtVerpennt > 0L ? this.gesamtVerpennt / 1000L : 0L) + " s";
    }
}

