/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.gui;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLaden;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLadenEvent;
import de.mediathekview.mlib.tool.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.animation.RotateTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.GridPane;
import javafx.util.Duration;
import mServer.crawler.CrawlerConfig;
import mServer.crawler.GetUrl;
import mServer.crawler.gui.Data;
import mServer.crawler.gui.MSearchGuiLoad;

public class PanelSearchController
implements Initializable {
    @FXML
    private Label lblSum;
    @FXML
    private Label lblProgress;
    @FXML
    private Label lblPercent;
    @FXML
    private Button btnStop;
    @FXML
    private Button btnAllSender;
    @FXML
    private Button btnLog;
    @FXML
    private ProgressBar pBar;
    @FXML
    private GridPane pSender;
    @FXML
    private RadioButton rbShort;
    @FXML
    private RadioButton rbLong;
    @FXML
    private RadioButton rbMax;
    @FXML
    private CheckBox cbLoadTime;
    @FXML
    private CheckBox cbDebug;
    @FXML
    private CheckBox cbUpdate;
    private int i = 0;
    private Button[] buttonSender;
    private String[] senderArray;
    private MSearchGuiLoad mlibGuiLoad;

    public void initialize(URL url, ResourceBundle rb) {
        this.btnStop.setOnAction(e -> System.out.println("Test"));
        this.initPanelSearch();
    }

    private void initPanelSearch() {
        this.lblSum.setText("");
        this.btnStop.setOnAction(e -> {
            RotateTransition tr = new RotateTransition();
            tr.setNode((Node)this.btnStop);
            tr.setDuration(Duration.millis((double)750.0));
            tr.setFromAngle(0.0);
            tr.setToAngle(220.0);
            tr.setAutoReverse(true);
            tr.setCycleCount(2);
            tr.play();
            Config.setStop(true);
        });
        this.mlibGuiLoad = new MSearchGuiLoad();
        this.rbShort.setSelected(true);
        CrawlerConfig.senderLoadHow = 0;
        this.rbShort.setOnAction(e -> {
            CrawlerConfig.senderLoadHow = 0;
        });
        this.rbLong.setOnAction(e -> {
            CrawlerConfig.senderLoadHow = 1;
        });
        this.rbMax.setOnAction(e -> {
            CrawlerConfig.senderLoadHow = 2;
        });
        GetUrl.showLoadTime = this.cbLoadTime.isSelected();
        this.cbLoadTime.setOnAction(e -> {
            GetUrl.showLoadTime = this.cbLoadTime.isSelected();
        });
        Config.debug = this.cbDebug.isSelected();
        this.cbDebug.setOnAction(e -> {
            Config.debug = this.cbDebug.isSelected();
        });
        this.cbUpdate.setOnAction(e -> {
            CrawlerConfig.updateFilmliste = this.cbUpdate.isSelected();
        });
        this.btnAllSender.setOnAction(e -> new Thread(() -> {
            this.disableButton(true);
            this.mlibGuiLoad.filmeBeimSenderSuchen(true);
        }).start());
        this.btnLog.setOnAction(e -> this.writeLog());
        this.senderArray = MSearchGuiLoad.getSenderNamen();
        this.buttonSender = new Button[this.senderArray.length];
        for (int i = 0; i < MSearchGuiLoad.getSenderNamen().length; ++i) {
            this.buttonSender[i] = new Button(this.senderArray[i]);
            this.buttonSender[i].setOnAction((EventHandler)new ActionLoadSender(this.senderArray[i]));
        }
        this.addSender();
        this.mlibGuiLoad.addAdListener(new ListenerFilmeLaden(){

            @Override
            public void progress(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> {
                    if (event.max == 0) {
                        PanelSearchController.this.pBar.setProgress(0.0);
                        PanelSearchController.this.lblPercent.setText("");
                    } else if (event.progress == 0) {
                        PanelSearchController.this.pBar.setProgress(0.0);
                        PanelSearchController.this.lblPercent.setText("0%");
                    } else {
                        double prog = 1.0 * (double)event.progress / (double)event.max;
                        if (prog < 0.0) {
                            prog = 0.0;
                        } else if (prog > 1.0) {
                            prog = 0.99;
                        }
                        PanelSearchController.this.pBar.setProgress(prog);
                        int i = (int)(100.0 * prog);
                        PanelSearchController.this.lblPercent.setText(i + "%");
                    }
                    PanelSearchController.this.lblProgress.setText(PanelSearchController.textLaenge(80, event.text, true, false));
                    PanelSearchController.this.lblSum.setText(event.count + "");
                });
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> {
                    PanelSearchController.this.pBar.setProgress(0.0);
                    PanelSearchController.this.lblPercent.setText("");
                    PanelSearchController.this.lblSum.setText(Data.listeFilme.size() + "");
                    Data.mlibGuiController.lblSum.setText(Data.listeFilme.size() + "");
                    PanelSearchController.this.disableButton(false);
                });
            }
        });
    }

    private void writeLog() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String datei = "/tmp/testfile";
        Date aktTime = new Date(System.currentTimeMillis());
        String aktTimeStr = sdf.format(aktTime);
        Log.sysLog("");
        Log.sysLog("Log schreiben: " + datei);
        Log.sysLog("--> " + aktTimeStr);
        File file = new File(datei);
        File dir = new File(file.getParent());
        if (!dir.exists() && !dir.mkdirs()) {
            Log.errorLog(632012165, "Kann den Pfad nicht anlegen: " + dir.toString());
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);
            out.write("===============================================================");
            out.write("===============================================================");
            out.write("\n");
            out.write("--> " + aktTimeStr);
            out.write("\n");
            ArrayList<String> ret = this.mlibGuiLoad.msFilmeSuchen.endeMeldung();
            for (String s : ret) {
                out.write(s);
                out.write("\n");
            }
            ret = Log.printErrorMsg();
            for (String s : ret) {
                out.write(s);
                out.write("\n");
            }
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.write("\n");
            out.close();
            Log.sysLog("--> geschrieben!");
        }
        catch (Exception ex) {
            Log.errorLog(846930145, ex, "nach: " + datei);
        }
    }

    private void addSender() {
        this.pSender.setHgap(10.0);
        this.pSender.setVgap(10.0);
        this.pSender.setPadding(new Insets(10.0));
        int zeile = 0;
        int spalte = 0;
        int count = 0;
        for (String aSender : this.senderArray) {
            Button btn = this.buttonSender[count];
            btn.setText(aSender);
            btn.setMaxWidth(Double.MAX_VALUE);
            this.pSender.add((Node)btn, spalte, zeile);
            if (++spalte >= 5) {
                ++zeile;
                spalte = 0;
            }
            ++count;
        }
    }

    private static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (text.length() > max) {
            text = mitte ? text.substring(0, 25) + " .... " + text.substring(text.length() - (max - 31)) : text.substring(0, max - 1);
        }
        while (text.length() < max) {
            if (addVorne) {
                text = " " + text;
                continue;
            }
            text = text + " ";
        }
        return text;
    }

    private void disableButton(boolean disable) {
        for (Button aButtonSender : this.buttonSender) {
            aButtonSender.setDisable(disable);
        }
        this.btnAllSender.setDisable(disable);
    }

    private class ActionLoadSender
    implements EventHandler<ActionEvent> {
        private final String sender;

        public ActionLoadSender(String ssender) {
            this.sender = ssender;
        }

        public void handle(ActionEvent t) {
            PanelSearchController.this.lblProgress.setText("");
            PanelSearchController.this.lblSum.setText("");
            PanelSearchController.this.disableButton(true);
            PanelSearchController.this.mlibGuiLoad.updateSender(new String[]{this.sender});
        }
    }
}

