/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.util.ArrayList;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.dw.DwVideoDTO;
import mServer.crawler.sender.dw.DwVideoDeserializer;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.tool.MserverDaten;

public class MediathekDw
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "DW";
    private static final String ADDURL = "http://tv-download.dw.de/dwtv_video/flv/";
    private static final String HTTP = "http";
    private static final String URL_VIDEO_JSON = "http://www.dw.com/playersources/v-";

    public MediathekDw(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 4, 200, startPrio);
    }

    @Override
    protected void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        this.sendungenLaden();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            MediathekDw.listeSort(this.listeThemen, 1);
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void sendungenLaden() {
        String ADRESSE = "http://www.dw.com/de/media-center/alle-inhalte/s-100814";
        String MUSTER_URL = "value=\"";
        String MUSTER_START = "<div class=\"label\">Sendungen</div>";
        MSStringBuilder seite = new MSStringBuilder(65536);
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri_Utf(SENDERNAME, "http://www.dw.com/de/media-center/alle-inhalte/s-100814", seite, "");
        String url = "";
        String thema = "";
        int pos1 = seite.indexOf("<div class=\"label\">Sendungen</div>");
        if (pos1 == -1) {
            Log.errorLog(915230456, "Nichts gefunden");
            return;
        }
        int stop = seite.indexOf("</div>", pos1 += "<div class=\"label\">Sendungen</div>".length());
        while ((pos1 = seite.indexOf("value=\"", pos1)) != -1 && pos1 <= stop) {
            try {
                int pos2 = seite.indexOf("\"", pos1 += "value=\"".length());
                if (pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                if (url.isEmpty()) continue;
                url = CrawlerTool.loadLongMax() ? "http://www.dw.com/de/media-center/alle-inhalte/s-100814?filter=&programs=" + url + "&sort=date&results=100" : "http://www.dw.com/de/media-center/alle-inhalte/s-100814?filter=&programs=" + url + "&sort=date&results=20";
                pos1 = seite.indexOf(">", pos1);
                if (pos1 != -1 && (pos2 = seite.indexOf("<", ++pos1)) != -1) {
                    thema = seite.substring(pos1, pos2);
                }
                String[] add = new String[]{url, thema};
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                Log.errorLog(731245970, ex);
            }
        }
    }

    private class ThemaLaden
    extends Thread {
        private MSStringBuilder seite1 = new MSStringBuilder(65536);
        private MSStringBuilder seite2 = new MSStringBuilder(65536);
        private final ArrayList<String> listUrl = new ArrayList();

        private ThemaLaden() {
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekDw.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekDw.this.listeThemen.getListeThemen()) != null) {
                    MediathekDw.this.meldungProgress(link[0]);
                    this.laden(link[0], link[1]);
                }
            }
            catch (Exception ex) {
                Log.errorLog(915423640, ex);
            }
            MediathekDw.this.meldungThreadUndFertig();
        }

        private void laden(String urlThema, String thema) {
            String MUSTER_START = "<div class=\"news searchres hov\">";
            MediathekDw.this.meldung(urlThema);
            GetUrl getUrlIo = new GetUrl(MediathekDw.this.getWartenSeiteLaden());
            this.seite1 = getUrlIo.getUri_Utf(MediathekDw.SENDERNAME, urlThema, this.seite1, "");
            int pos1 = 0;
            while (!Config.getStop() && (pos1 = this.seite1.indexOf("<div class=\"news searchres hov\">", pos1)) != -1) {
                String urlSendung = this.seite1.extract("<a href=\"", "\"", pos1 += "<div class=\"news searchres hov\">".length());
                String titel = this.seite1.extract("<h2>", "<", pos1).trim();
                if (urlSendung.isEmpty()) continue;
                this.laden2(urlThema, thema, titel, "http://www.dw.com" + urlSendung);
            }
        }

        private void laden2(String urlThema, String thema, String titel, String urlSendung) {
            String url = "";
            String urlLow = "";
            String urlHd = "";
            MediathekDw.this.meldung(urlThema);
            GetUrl getUrlIo = new GetUrl(MediathekDw.this.getWartenSeiteLaden());
            this.seite2 = getUrlIo.getUri_Utf(MediathekDw.SENDERNAME, urlSendung, this.seite2, "");
            this.seite2.extractList("%22file%22%3A%22", "%22%7D", this.listUrl);
            if (this.listUrl.isEmpty()) {
                this.seite2.extractList("name=\"file_name\" value=\"", "\"", this.listUrl);
            }
            for (String u : this.listUrl) {
                u = u.replace("%2F", "/");
                if (urlLow.isEmpty() && u.endsWith("vp6.flv")) {
                    urlLow = this.addUrlPrefixIfNecessary(u);
                }
                if (url.isEmpty() && u.endsWith("sor.mp4")) {
                    url = this.addUrlPrefixIfNecessary(u);
                }
                if (!urlHd.isEmpty() || !u.endsWith("avc.mp4")) continue;
                urlHd = this.addUrlPrefixIfNecessary(u);
            }
            this.listUrl.clear();
            if (url.isEmpty()) {
                String id = this.seite2.extract("<input type=\"hidden\" name=\"media_id\" value=\"", "\"");
                GetUrl getUrlVideo = new GetUrl(MediathekDw.this.getWartenSeiteLaden());
                MSStringBuilder seiteVideo = new MSStringBuilder();
                seiteVideo = getUrlVideo.getUri_Utf(MediathekDw.SENDERNAME, MediathekDw.URL_VIDEO_JSON + id, seiteVideo, "");
                if (seiteVideo.length() > 0) {
                    Gson gson = new GsonBuilder().registerTypeAdapter(DwVideoDTO.class, (Object)new DwVideoDeserializer()).create();
                    DwVideoDTO dto = (DwVideoDTO)gson.fromJson(seiteVideo.substring(0), DwVideoDTO.class);
                    url = dto.getUrl(Qualities.NORMAL);
                    urlHd = dto.getUrl(Qualities.HD);
                }
            }
            String description = this.seite2.extract("<meta name=\"description\" content=\"", "\"");
            String datum = this.seite2.extract("<strong>Datum</strong>", "</li>").trim();
            String dur = this.seite2.extract("<strong>Dauer</strong>", "Min.").trim();
            dur = dur.replace("\n", "");
            dur = dur.replace("\r", "");
            long duration = 0L;
            try {
                if (!dur.isEmpty()) {
                    String[] parts = dur.split(":");
                    long power = 1L;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        duration += Long.parseLong(parts[i]) * power;
                        power *= 60L;
                    }
                }
            }
            catch (NumberFormatException ex) {
                if (MserverDaten.debug) {
                    Log.errorLog(912034567, "duration: " + dur);
                }
            }
            catch (Exception ex) {
                Log.errorLog(912034567, "duration: " + dur);
            }
            if (url.isEmpty() && !urlLow.isEmpty()) {
                url = urlLow;
                urlLow = "";
            }
            if (url.isEmpty() && !urlHd.isEmpty()) {
                url = urlHd;
                urlHd = "";
            }
            if (url.isEmpty()) {
                if (MserverDaten.debug) {
                    Log.errorLog(643230120, "empty URL: " + urlSendung);
                }
            } else {
                DatenFilm film = new DatenFilm(MediathekDw.SENDERNAME, thema, urlSendung, titel, url, "", datum, "", duration, description);
                if (!urlLow.isEmpty()) {
                    CrawlerTool.addUrlKlein(film, urlLow, "");
                }
                if (!urlHd.isEmpty()) {
                    CrawlerTool.addUrlHd(film, urlHd, "");
                }
                MediathekDw.this.addFilm(film);
            }
        }

        private String addUrlPrefixIfNecessary(String url) {
            if (!url.startsWith(MediathekDw.HTTP)) {
                return MediathekDw.ADDURL + url;
            }
            return url;
        }
    }
}

