/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmPoint;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Phaser;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.TimeUnit;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.RunSender;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.newsearch.DownloadDTO;
import mServer.crawler.sender.newsearch.GeoLocations;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.crawler.sender.newsearch.VideoDTO;
import mServer.crawler.sender.newsearch.ZDFSearchTask;
import mServer.crawler.sender.newsearch.ZdfDatenFilm;

public class MediathekZdf
extends MediathekReader {
    public static final String SENDERNAME = "ZDF";
    private ForkJoinPool forkJoinPool;
    private final Phaser phaser = new Phaser();

    public MediathekZdf(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 0, 150, startPrio);
        this.setName("MediathekZdf");
    }

    @Override
    public void addToList() {
        this.meldungStart();
        this.meldungAddThread();
        int days = CrawlerTool.loadLongMax() ? 300 : 20;
        ZDFSearchTask newTask = new ZDFSearchTask(days);
        this.forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() * 4);
        this.forkJoinPool.execute(newTask);
        Collection filmList = (Collection)newTask.join();
        this.convertToDto(filmList);
        this.shutdownAndAwaitTermination(this.forkJoinPool, 60L, TimeUnit.SECONDS);
        this.meldungThreadUndFertig();
    }

    void convertToDto(Collection<VideoDTO> filmList) {
        EtmPoint perfPoint = EtmManager.getEtmMonitor().createPoint("MediathekZdf.convertVideoDTO");
        if (!filmList.isEmpty()) {
            Log.sysLog("convert VideoDTO to DatenFilm started...");
            filmList.parallelStream().forEach(video -> {
                VideoDtoDatenFilmConverterAction action = new VideoDtoDatenFilmConverterAction((VideoDTO)video);
                this.forkJoinPool.execute(action);
            });
            filmList.clear();
            boolean wasInterrupted = false;
            while (!this.phaser.isTerminated()) {
                try {
                    if (Config.getStop()) {
                        wasInterrupted = true;
                        this.phaser.forceTermination();
                        this.shutdownAndAwaitTermination(this.forkJoinPool, 5L, TimeUnit.SECONDS);
                        continue;
                    }
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (wasInterrupted) {
                Log.sysLog("VideoDTO conversion interrupted.");
            } else {
                Log.sysLog("convert VideoDTO to DatenFilm finished.");
            }
        }
        perfPoint.collect();
    }

    void shutdownAndAwaitTermination(ExecutorService pool, long delay, TimeUnit delayUnit) {
        Log.sysLog("ZDF shutdown pool...");
        pool.shutdown();
        try {
            if (!pool.awaitTermination(delay, delayUnit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(delay, delayUnit)) {
                    Log.sysLog("ZDF: Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static void updateHdStatus(DatenFilm film, String urlSeite) {
        MediathekZdf.updateHd("1456k_p13v12.mp4", "3328k_p36v12.mp4", film, urlSeite);
        MediathekZdf.updateHd("2256k_p14v12.mp4", "3328k_p36v12.mp4", film, urlSeite);
        MediathekZdf.updateHd("2328k_p35v12.mp4", "3328k_p36v12.mp4", film, urlSeite);
        MediathekZdf.updateHd("1456k_p13v12.mp4", "3256k_p15v12.mp4", film, urlSeite);
        MediathekZdf.updateHd("2256k_p14v12.mp4", "3256k_p15v12.mp4", film, urlSeite);
        MediathekZdf.updateHd("2328k_p35v12.mp4", "3256k_p15v12.mp4", film, urlSeite);
        MediathekZdf.updateHd("1496k_p13v13.mp4", "3296k_p15v13.mp4", film, urlSeite);
        MediathekZdf.updateHd("2296k_p14v13.mp4", "3296k_p15v13.mp4", film, urlSeite);
        MediathekZdf.updateHd("2328k_p35v13.mp4", "3296k_p15v13.mp4", film, urlSeite);
        MediathekZdf.updateHd("1496k_p13v13.mp4", "3328k_p36v13.mp4", film, urlSeite);
        MediathekZdf.updateHd("2296k_p14v13.mp4", "3328k_p36v13.mp4", film, urlSeite);
        MediathekZdf.updateHd("2328k_p35v13.mp4", "3328k_p36v13.mp4", film, urlSeite);
        MediathekZdf.updateHd("1496k_p13v14.mp4", "3328k_p36v14.mp4", film, urlSeite);
        MediathekZdf.updateHd("2296k_p14v14.mp4", "3328k_p36v14.mp4", film, urlSeite);
        MediathekZdf.updateHd("2328k_p35v14.mp4", "3328k_p36v14.mp4", film, urlSeite);
        MediathekZdf.updateHd("1496k_p13v14.mp4", "3328k_p35v14.mp4", film, urlSeite);
        MediathekZdf.updateHd("2296k_p14v14.mp4", "3328k_p35v14.mp4", film, urlSeite);
        MediathekZdf.updateHd("2328k_p35v14.mp4", "3328k_p35v14.mp4", film, urlSeite);
    }

    private static void modifyUrl(DatenFilm film, String urlSeite, FilmeSuchen mSFilmeSuchen) {
        MediathekZdf.changeUrl("2256k_p14v11.mp4", "2328k_p35v11.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("2256k_p14v12.mp4", "2328k_p35v12.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("2296k_p14v13.mp4", "2328k_p35v13.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("1456k_p13v11.mp4", "2328k_p35v11.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("1456k_p13v11.mp4", "2256k_p14v11.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("1456k_p13v12.mp4", "2328k_p35v12.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("1456k_p13v12.mp4", "2256k_p14v12.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("1496k_p13v13.mp4", "2328k_p35v13.mp4", film, urlSeite, mSFilmeSuchen);
        MediathekZdf.changeUrl("1496k_p13v13.mp4", "2296k_p14v13.mp4", film, urlSeite, mSFilmeSuchen);
    }

    public static void urlTauschen(DatenFilm film, String urlSeite, FilmeSuchen mSFilmeSuchen) {
        MediathekZdf.modifyUrl(film, urlSeite, mSFilmeSuchen);
        MediathekZdf.updateHdStatus(film, urlSeite);
    }

    private static void changeUrl(String from, String to, DatenFilm film, String urlSeite, FilmeSuchen mSFilmeSuchen) {
        if (film.arr[14].endsWith(from)) {
            String url = film.arr[14].substring(0, film.arr[14].lastIndexOf(from)) + to;
            String l = mSFilmeSuchen.listeFilmeAlt.getFileSizeUrl(url);
            if (!l.isEmpty()) {
                film.arr[9] = l;
                film.arr[14] = url;
            } else if (MediathekZdf.urlExists(url)) {
                film.arr[14] = url;
            } else {
                Log.errorLog(945120369, "urlTauschen: " + urlSeite);
            }
        }
    }

    private static void updateHd(String from, String to, DatenFilm film, String urlSeite) {
        if (film.arr[22].isEmpty() && film.arr[14].endsWith(from)) {
            String url = film.arr[14].substring(0, film.arr[14].lastIndexOf(from)) + to;
            if (MediathekZdf.urlExists(url)) {
                CrawlerTool.addUrlHd(film, url, "");
            } else {
                Log.errorLog(945120147, "urlTauschen: " + urlSeite);
            }
        }
    }

    private class VideoDtoDatenFilmConverterAction
    extends RecursiveAction {
        private final VideoDTO video;

        public VideoDtoDatenFilmConverterAction(VideoDTO aVideoDTO) {
            this.video = aVideoDTO;
            MediathekZdf.this.phaser.register();
        }

        @Override
        protected void compute() {
            if (this.video != null) {
                try {
                    DownloadDTO download = this.video.getDownloadDto();
                    for (String language : download.getLanguages()) {
                        this.addFilm(download, language);
                    }
                }
                catch (Exception ex) {
                    Log.errorLog(496583211, ex, "add film failed: " + this.video.getWebsiteUrl());
                }
            }
            MediathekZdf.this.phaser.arriveAndDeregister();
        }

        private void addFilm(DownloadDTO download, String language) {
            String title = this.determineTitle(this.video.getTitle(), language);
            ZdfDatenFilm film = new ZdfDatenFilm(MediathekZdf.SENDERNAME, this.video.getTopic(), this.video.getWebsiteUrl(), title, download.getUrl(language, Qualities.NORMAL), "", this.video.getDate(), this.video.getTime(), this.video.getDuration(), this.video.getDescription());
            MediathekZdf.urlTauschen(film, this.video.getWebsiteUrl(), MediathekZdf.this.mlibFilmeSuchen);
            if (MediathekZdf.this.mlibFilmeSuchen.listeFilmeNeu.addFilmVomSender(film)) {
                FilmeSuchen.listeSenderLaufen.inc(film.arr[1], RunSender.Count.FILME);
            }
            if (!download.getUrl(language, Qualities.HD).isEmpty()) {
                CrawlerTool.addUrlHd(film, download.getUrl(language, Qualities.HD), "");
            }
            if (!download.getUrl(language, Qualities.SMALL).isEmpty()) {
                CrawlerTool.addUrlKlein(film, download.getUrl(language, Qualities.SMALL), "");
            }
            if (!download.getSubTitleUrl().isEmpty()) {
                CrawlerTool.addUrlSubtitle(film, download.getSubTitleUrl());
            }
            if (download.getGeoLocation() != GeoLocations.GEO_NONE) {
                film.arr[13] = download.getGeoLocation().getDescription();
            }
        }

        private String determineTitle(String title, String language) {
            switch (language) {
                case "eng": {
                    return title + " (Englisch)";
                }
                case "deu": {
                    return title;
                }
            }
            return title + "(" + language + ")";
        }
    }
}

