/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.hr;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Log;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import mServer.crawler.CrawlerTool;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.hr.HrSendungDeserializer;
import mServer.crawler.sender.hr.HrSendungOverviewDeserializer;
import mServer.crawler.sender.hr.HrSendungenDto;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class HrSendungOverviewCallable
implements Callable<ListeFilme> {
    private final HrSendungenDto dto;
    private final HrSendungOverviewDeserializer overviewDeserializer = new HrSendungOverviewDeserializer();
    private final HrSendungDeserializer sendungDeserializer = new HrSendungDeserializer();

    public HrSendungOverviewCallable(HrSendungenDto aDto) {
        this.dto = aDto;
    }

    @Override
    public ListeFilme call() throws Exception {
        ListeFilme list = new ListeFilme();
        try {
            if (!Config.getStop()) {
                Document overviewDocument = Jsoup.connect((String)this.dto.getUrl()).get();
                List<String> detailUrls = this.overviewDeserializer.deserialize(overviewDocument);
                detailUrls.forEach(detailUrl -> {
                    DatenFilm film;
                    if (!Config.getStop() && (film = this.handleFilmDetails((String)detailUrl)) != null) {
                        list.add(film);
                    }
                });
            }
        }
        catch (IOException ex1) {
            Log.errorLog(894651554, ex1);
        }
        return list;
    }

    private DatenFilm handleFilmDetails(String url) {
        try {
            Document detailDocument = Jsoup.connect((String)url).get();
            DatenFilm film = this.sendungDeserializer.deserialize(this.dto.getTheme(), url, detailDocument);
            if (film != null) {
                String subtitle = film.getUrl().replace(".mp4", ".xml");
                if (MediathekReader.urlExists(subtitle)) {
                    CrawlerTool.addUrlSubtitle(film, subtitle);
                }
                return film;
            }
        }
        catch (IOException ex1) {
            Log.errorLog(894651554, ex1);
        }
        return null;
    }
}

