/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.newsearch;

import com.google.gson.JsonObject;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.tool.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RecursiveTask;
import mServer.crawler.sender.newsearch.VideoDTO;
import mServer.crawler.sender.newsearch.ZDFClient;
import mServer.crawler.sender.newsearch.ZDFSearchPageTask;
import mServer.tool.MserverDaten;

public class ZDFSearchTask
extends RecursiveTask<Collection<VideoDTO>> {
    private static final String JSON_ELEMENT_NEXT = "next";
    private static final long serialVersionUID = 1L;
    private final Collection<VideoDTO> filmList = new ArrayList<VideoDTO>();
    private final ZDFClient client = new ZDFClient();
    private int page = 1;
    private final int days;

    public ZDFSearchTask(int aDays) {
        this.days = aDays;
    }

    @Override
    protected Collection<VideoDTO> compute() {
        if (!Config.getStop()) {
            try {
                JsonObject baseObject;
                ConcurrentHashMap.KeySetView subTasks = ConcurrentHashMap.newKeySet();
                do {
                    if ((baseObject = this.client.executeSearch(this.page, this.days, 1)) != null) {
                        ZDFSearchPageTask task = new ZDFSearchPageTask(baseObject);
                        task.fork();
                        subTasks.add(task);
                        if (MserverDaten.debug) {
                            Log.sysLog("SearchTask " + task.hashCode() + " added.");
                        }
                    }
                    ++this.page;
                } while (!Config.getStop() && baseObject != null && baseObject.has(JSON_ELEMENT_NEXT));
                subTasks.forEach(t -> this.filmList.addAll((Collection)t.join()));
                if (MserverDaten.debug) {
                    Log.sysLog("All SearchTasks finished.");
                }
            }
            catch (Exception ex) {
                Log.errorLog(496583201, ex);
            }
        }
        return this.filmList;
    }
}

