/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.wdr;

import java.util.ArrayList;
import java.util.List;
import mServer.crawler.sender.wdr.WdrDeserializerBase;
import mServer.crawler.sender.wdr.WdrSendungDto;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WdrDayPageDeserializer
extends WdrDeserializerBase {
    private static final String QUERY_URL = "div.hideTeasertext > a";
    private static final String QUERY_THEME = "h3.ressort > a";

    public List<WdrSendungDto> deserialize(Document document) {
        ArrayList<WdrSendungDto> list = new ArrayList<WdrSendungDto>();
        Elements themeElements = document.select(QUERY_THEME);
        Elements urlElements = document.select(QUERY_URL);
        if (themeElements.size() == urlElements.size()) {
            for (int i = 0; i < themeElements.size(); ++i) {
                String theme = this.getTheme((Element)themeElements.get(i), (Element)urlElements.get(i));
                String url = this.addDomainIfNecessary(((Element)urlElements.get(i)).attr("href"));
                if (url.contains("/hilfe/")) continue;
                WdrSendungDto dto = new WdrSendungDto();
                dto.setTheme(theme);
                dto.addVideoUrl(url);
                list.add(dto);
            }
        } else {
            list.clear();
        }
        return list;
    }

    private String getTheme(Element themeElement, Element urlElement) {
        String[] titleParts;
        String theme = themeElement.text();
        if (theme.compareToIgnoreCase("Film") == 0) {
            theme = "Fernsehfilm";
        } else if (theme.compareToIgnoreCase("Video") == 0 && (titleParts = urlElement.attr("title").split("-")).length >= 1) {
            theme = titleParts[0].replace(", WDR", "").trim();
        }
        return theme;
    }
}

