/*
 * Decompiled with CFR 0.152.
 */
package mServer.tool;

import de.mediathekview.mlib.tool.Functions;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import mServer.tool.MserverDaten;
import mServer.tool.MserverDatumZeit;
import org.apache.commons.lang3.time.FastDateFormat;

public class MserverLog {
    private static final LinkedList<Integer[]> fehlerListe = new LinkedList();
    private static final Date startZeit = new Date(System.currentTimeMillis());
    private static final String logfile = MserverDaten.getLogDatei("MvServer");

    public static synchronized void versionsMeldungen(String classname) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemmeldung(new String[]{".___  ___.  _______  _______   __       ___   .___________. __    __   _______  __  ___"}, false);
        MserverLog.systemmeldung(new String[]{"|   \\/   | |   ____||       \\ |  |     /   \\  |           ||  |  |  | |   ____||  |/  /"}, false);
        MserverLog.systemmeldung(new String[]{"|  \\  /  | |  |__   |  .--.  ||  |    /  ^  \\ `---|  |----`|  |__|  | |  |__   |  '  /"}, false);
        MserverLog.systemmeldung(new String[]{"|  |\\/|  | |   __|  |  |  |  ||  |   /  /_\\  \\    |  |     |   __   | |   __|  |    <"}, false);
        MserverLog.systemmeldung(new String[]{"|  |  |  | |  |____ |  '--'  ||  |  /  _____  \\   |  |     |  |  |  | |  |____ |  .  \\"}, false);
        MserverLog.systemmeldung(new String[]{"|__|  |__| |_______||_______/ |__| /__/     \\__\\  |__|     |__|  |__| |_______||__|\\__\\"}, false);
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("###########################################################");
        MserverLog.systemMeldung("###########################################################");
        MserverLog.systemMeldung("Programmstart: " + sdf.format(startZeit));
        MserverLog.systemMeldung("###########################################################");
        long totalMem = Runtime.getRuntime().totalMemory();
        MserverLog.systemMeldung("totalMemory: " + totalMem / 0x100000L + " MB");
        long maxMem = Runtime.getRuntime().maxMemory();
        MserverLog.systemMeldung("maxMemory: " + maxMem / 0x100000L + " MB");
        long freeMem = Runtime.getRuntime().freeMemory();
        MserverLog.systemMeldung("freeMemory: " + freeMem / 0x100000L + " MB");
        MserverLog.systemMeldung("###########################################################");
        MserverLog.systemMeldung("MServer" + Functions.getProgVersionString());
        MserverLog.systemMeldung("Compiled: " + Functions.getCompileDate());
        MserverLog.systemMeldung("Klassenname: " + classname);
        MserverLog.systemMeldung("###########################################################");
    }

    public static synchronized void startMeldungen(String classname) {
        MserverLog.versionsMeldungen(classname);
        MserverLog.systemMeldung("Programmpfad: " + Functions.getPathJar());
        MserverLog.systemMeldung("Verzeichnis Einstellungen: " + MserverDaten.getBasisVerzeichnis());
        MserverLog.systemMeldung("Useragent: " + MserverDaten.getUserAgent());
        MserverLog.systemMeldung("###########################################################");
        if (MserverDaten.debug) {
            MserverLog.systemMeldung("");
            MserverLog.systemMeldung("== Debug on ======");
            MserverLog.systemMeldung("");
        }
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
    }

    public static synchronized void debugMeldung(String text) {
        if (MserverDaten.debug) {
            MserverLog.debugmeldung(text);
        }
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String klasse, String text) {
        MserverLog.fehlermeldung_(fehlerNummer, klasse, new String[]{text});
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String klasse, String text, Exception ex) {
        String[] f = new String[]{text, ex.getMessage()};
        MserverLog.fehlermeldung_(fehlerNummer, klasse, f);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String klasse, String[] text) {
        MserverLog.fehlermeldung_(fehlerNummer, klasse, text);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String klasse, String[] text, Exception ex) {
        String[] f = new String[text.length + 1];
        System.arraycopy(text, 0, f, 0, text.length);
        f[text.length] = ex.getMessage();
        MserverLog.fehlermeldung_(fehlerNummer, klasse, f);
    }

    public static synchronized void systemMeldung(String text) {
        MserverLog.systemmeldung(new String[]{text});
    }

    public static synchronized void systemMeldung(String[] text) {
        MserverLog.systemmeldung(text);
    }

    public static void printEndeMeldung() {
        if (fehlerListe.isEmpty()) {
            MserverLog.systemMeldung("###########################################################");
            MserverLog.systemMeldung(" Keine Fehler :)");
            MserverLog.systemMeldung("###########################################################");
        } else {
            for (int i = 1; i < fehlerListe.size(); ++i) {
                int i_2;
                int i_1;
                for (int k = i; k > 0 && (i_1 = fehlerListe.get(k - 1)[1].intValue()) < (i_2 = fehlerListe.get(k)[1].intValue()); --k) {
                    fehlerListe.add(k - 1, fehlerListe.remove(k));
                }
            }
            MserverLog.systemMeldung("###########################################################");
            for (Integer[] integers : fehlerListe) {
                if (integers[0] < 0) {
                    MserverLog.systemMeldung(" Fehlernummer: " + integers[0] + " Anzahl: " + integers[1]);
                    continue;
                }
                MserverLog.systemMeldung(" Fehlernummer:  " + integers[0] + " Anzahl: " + integers[1]);
            }
            MserverLog.systemMeldung("###########################################################");
        }
        Date stopZeit = new Date(System.currentTimeMillis());
        FastDateFormat sdf = FastDateFormat.getInstance((String)"dd.MM.yyyy HH:mm:ss");
        int minuten = Math.round((stopZeit.getTime() - startZeit.getTime()) / 60000L);
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("###########################################################");
        MserverLog.systemMeldung("   --> Beginn: " + sdf.format(startZeit));
        MserverLog.systemMeldung("   --> Fertig: " + sdf.format(stopZeit));
        MserverLog.systemMeldung("   --> Dauer[Min]: " + (minuten == 0 ? "<1" : Integer.valueOf(minuten)));
        MserverLog.systemMeldung("###########################################################");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("   und Tschuess");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("###########################################################");
    }

    private static void addFehlerNummer(int nr) {
        for (Integer[] i : fehlerListe) {
            if (i[0] != nr) continue;
            Integer[] integerArray = i;
            Integer n = integerArray[1];
            Integer n2 = integerArray[1] = Integer.valueOf(integerArray[1] + 1);
            return;
        }
        fehlerListe.add(new Integer[]{nr, 1});
    }

    private static void fehlermeldung_(int fehlerNummer, String klasse, String[] texte) {
        MserverLog.addFehlerNummer(fehlerNummer);
        String FEHLER = "Fehler(MServer): ";
        String z = "*";
        System.out.println("****************************");
        System.out.println("* Fehlernr: " + fehlerNummer);
        System.out.println("* Fehler(MServer): " + klasse);
        for (String aTexte : texte) {
            System.out.println("*           " + aTexte);
        }
        System.out.println("****************************");
    }

    private static void debugmeldung(String texte) {
        System.out.println("|||| " + texte);
    }

    private static void systemmeldung(String[] texte) {
        MserverLog.systemmeldung(texte, true);
    }

    private static void systemmeldung(String[] texte, boolean datum) {
        String z = "o ";
        if (texte.length <= 1) {
            System.out.println("o  " + texte[0]);
        } else {
            String zeile = "---------------------------------------";
            System.out.println("o " + zeile);
            for (String aTexte : texte) {
                String txt = "| " + aTexte;
                System.out.println("o " + txt);
            }
            System.out.println("o " + zeile);
        }
        if (!logfile.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(logfile, true);
                 OutputStreamWriter writer = new OutputStreamWriter(fos);){
                for (String s : texte) {
                    if (s.isEmpty()) {
                        writer.write("\n");
                        continue;
                    }
                    if (datum) {
                        writer.write(MserverDatumZeit.getJetzt() + "     " + s);
                    } else {
                        writer.write(s);
                    }
                    writer.write("\n");
                }
                writer.close();
            }
            catch (Exception ex) {
                System.out.println("Fehler beim Logfile schreiben: " + ex.getMessage());
            }
        }
    }

    public void resetFehlerListe() {
        fehlerListe.clear();
    }
}

