/* BSD 2-Clause License:
 * Copyright (c) 2009 - 2017
 * Software Technology Group
 * Department of Computer Science
 * Technische Universität Darmstadt
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package org.opalj
package da

import scala.xml.Node

/**
 * The attribute class defines the common elements of all attributes; i.e., basically
 * the first two attribute_info elements.
 * <pre>
 * attribute_info {
 *  u2 attribute_name_index;
 *  u4 attribute_length;
 *  u1 info[attribute_length];
 *  ...
 * }
 * </pre>
 *
 * @author Michael Eichberg
 * @author Wael Alkhatib
 * @author Isbel Isbel
 * @author Noorulla Sharief
 * @author Andre Pacak
 */
trait Attribute {

    /**
     * The number of bytes required to store this attribute; including the index into the constant
     * pool for the name (2 bytes) and the length of the attribute (4 bytes).
     */
    def size: Int = 2 /* attribute_name_index */ + 4 /* attribute_length */ + attribute_length

    /**
     * The number of bytes to store the attribute; excluding the index into the constant
     * pool for the name (2 bytes) and the length of the attribute (4 bytes).
     */
    def attribute_length: Int

    def attribute_name_index: Constant_Pool_Index

    def attribute_name(implicit cp: Constant_Pool) = cp(attribute_name_index).asString

    def toXHTML(implicit cp: Constant_Pool): Node = {
        <span class="attribute_name">{ attribute_name }</span>
    }

    // TODO we need to add a method to create "inline representations" for some attributes.
}
