/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.analyses;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.opalj.br.ClassFile;
import org.opalj.br.Code;
import org.opalj.br.Method;
import org.opalj.br.ObjectType;
import org.opalj.br.ObjectType$;
import org.opalj.br.analyses.InstantiableClasses;
import org.opalj.br.analyses.InstantiableClassesAnalysis$;
import org.opalj.br.analyses.Project;
import org.opalj.br.instructions.Instruction;
import org.opalj.br.instructions.NEW;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.TraversableOnce;

public final class InstantiableClassesAnalysis$ {
    public static final InstantiableClassesAnalysis$ MODULE$;

    static {
        new InstantiableClassesAnalysis$();
    }

    public InstantiableClasses doAnalyze(Project<?> project, Function0<Object> isInterrupted) {
        ConcurrentLinkedQueue notInstantiable = new ConcurrentLinkedQueue();
        project.parForeachProjectClassFile(isInterrupted, new Serializable(project, notInstantiable){
            public static final long serialVersionUID = 0L;
            private final Project project$1;
            private final ConcurrentLinkedQueue notInstantiable$1;

            public final void apply(ClassFile cf) {
                InstantiableClassesAnalysis$.MODULE$.org$opalj$br$analyses$InstantiableClassesAnalysis$$analyzeClassFile$1(cf, this.project$1, this.notInstantiable$1);
            }
            {
                this.project$1 = project$1;
                this.notInstantiable$1 = notInstantiable$1;
            }
        });
        return new InstantiableClasses(project, (Set<ObjectType>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(notInstantiable).asScala()).toSet());
    }

    public final void org$opalj$br$analyses$InstantiableClassesAnalysis$$analyzeClassFile$1(ClassFile cf, Project project$1, ConcurrentLinkedQueue notInstantiable$1) {
        if (cf.isAbstract()) {
            return;
        }
        if (cf.constructors().forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method c2) {
                return c2.isPrivate();
            }
        })) {
            ObjectType thisClassType = cf.thisType();
            if (project$1.classHierarchy().isSubtypeOf(thisClassType, ObjectType$.MODULE$.Serializable()).isYesOrUnknown()) {
                return;
            }
            boolean hasFactoryMethod = cf.methods().exists((Function1)new Serializable(thisClassType){
                public static final long serialVersionUID = 0L;
                public final ObjectType thisClassType$1;

                public final boolean apply(Method method) {
                    return method.isStatic() && !method.isStaticInitializer() && (method.isNative() || method.body().isEmpty() || ((Code)method.body().get()).exists((Function2<Object, Instruction, Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.1 $outer;

                        public final boolean apply(int pc, Instruction instruction) {
                            return instruction.opcode() == 187 && ((NEW)instruction).objectType() == this.$outer.thisClassType$1;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                {
                    this.thisClassType$1 = thisClassType$1;
                }
            });
            if (!hasFactoryMethod) {
                notInstantiable$1.add(thisClassType);
            }
            return;
        }
    }

    private InstantiableClassesAnalysis$() {
        MODULE$ = this;
    }
}

