/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.reader;

import net.ceedubs.ficus.Ficus$;
import org.opalj.bi.reader.ClassFileReaderConfiguration;
import org.opalj.br.Attribute;
import org.opalj.br.Code;
import org.opalj.br.ComputationalTypeCategory;
import org.opalj.br.ExceptionHandler;
import org.opalj.br.Method;
import org.opalj.br.cp.Constant_Pool_Entry;
import org.opalj.br.instructions.CompoundConditionalBranchInstruction;
import org.opalj.br.instructions.GOTO;
import org.opalj.br.instructions.GOTO_W;
import org.opalj.br.instructions.GotoInstruction;
import org.opalj.br.instructions.GotoInstruction$;
import org.opalj.br.instructions.Instruction;
import org.opalj.br.instructions.JSRInstruction;
import org.opalj.br.instructions.JSRInstruction$;
import org.opalj.br.instructions.NOP$;
import org.opalj.br.instructions.POP$;
import org.opalj.br.instructions.POP2$;
import org.opalj.br.instructions.SimpleConditionalBranchInstruction;
import org.opalj.br.reader.BytecodeOptimizer;
import org.opalj.log.OPALLogger$;
import org.opalj.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public abstract class BytecodeOptimizer$class {
    public static Method Method_Info(BytecodeOptimizer $this, Constant_Pool_Entry[] cp, int accessFlags, int name_index, int descriptor_index, Seq attributes) {
        attributes.collectFirst((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Code) {
                    Code code = (Code)A1;
                    object = code;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Attribute x1) {
                Attribute attribute = x1;
                boolean bl = attribute instanceof Code;
                return bl;
            }
        }).foreach((Function1)new Serializable($this, cp, name_index, descriptor_index){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BytecodeOptimizer $outer;
            private final Constant_Pool_Entry[] cp$1;
            private final int name_index$1;
            private final int descriptor_index$1;

            public final void apply(Code code) {
                boolean isSimplified = this.$outer.optimizeInstructions(code.exceptionHandlers(), code.instructions());
                if (isSimplified && this.$outer.LogControlFlowSimplifications()) {
                    OPALLogger$.MODULE$.info("class file reader", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"simplified control flow of ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cp$1[this.name_index$1].asString(), this.cp$1[this.descriptor_index$1].asString()})), ((ClassFileReaderConfiguration)this.$outer).logContext());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cp$1 = cp$1;
                this.name_index$1 = name_index$1;
                this.descriptor_index$1 = descriptor_index$1;
            }
        });
        return $this.org$opalj$br$reader$BytecodeOptimizer$$super$Method_Info(cp, accessFlags, name_index, descriptor_index, attributes);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean optimizeInstructions(BytecodeOptimizer $this, IndexedSeq exceptionsHandlers, Instruction[] instructions) {
        void var3_3;
        BooleanRef simplified = BooleanRef.create((boolean)false);
        if ($this.PerformControlFlowSimplifications()) {
            ObjectRef jumpTargetInstructions = ObjectRef.create((Object)((Set)exceptionsHandlers.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Set<Object> apply(Set<Object> c2, ExceptionHandler eh) {
                    return (Set)c2.$plus((Object)BoxesRunTime.boxToInteger((int)eh.handlerPC()));
                }
            })));
            Set confusedIfs = Predef$.MODULE$.Set().empty();
            Set totallyConfusedIfs = Predef$.MODULE$.Set().empty();
            int max = instructions.length;
            IntRef pc = IntRef.create((int)0);
            while (pc.elem < max) {
                boolean modifiedByWide = false;
                Instruction instruction = instructions[pc.elem];
                if (instruction.opcode() == 196) {
                    modifiedByWide = true;
                    ++pc.elem;
                    instruction = instructions[pc.elem];
                }
                int nextPC = instruction.indexOfNextInstruction(pc.elem, modifiedByWide);
                int n = instruction.opcode();
                switch (n) {
                    case 168: 
                    case 201: {
                        JSRInstruction jSRInstruction;
                        Some<Object> some;
                        Instruction instruction2 = instruction;
                        if (instruction2 instanceof JSRInstruction && !(some = JSRInstruction$.MODULE$.unapply(jSRInstruction = (JSRInstruction)instruction2)).isEmpty()) {
                            int branchoffset;
                            int n2;
                            int branchoffset2 = n2 = (branchoffset = BoxesRunTime.unboxToInt((Object)some.get()));
                            jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)(pc.elem + branchoffset2)));
                            jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)nextPC));
                            break;
                        }
                        throw new MatchError((Object)instruction2);
                    }
                    case 170: 
                    case 171: {
                        CompoundConditionalBranchInstruction switchInstruction = instruction.asCompoundConditionalBranchInstruction();
                        int defaultOffset = switchInstruction.defaultOffset();
                        if (switchInstruction.jumpOffsets().forall((Function1)new Serializable($this, defaultOffset){
                            public static final long serialVersionUID = 0L;
                            private final int defaultOffset$1;

                            public final boolean apply(int x$1) {
                                return this.apply$mcZI$sp(x$1);
                            }

                            public boolean apply$mcZI$sp(int x$1) {
                                return x$1 == this.defaultOffset$1;
                            }
                            {
                                this.defaultOffset$1 = defaultOffset$1;
                            }
                        })) {
                            int i = pc.elem + 1;
                            instructions[pc.elem] = POP$.MODULE$;
                            int newNextPC = -1;
                            int jumpTargetPC = pc.elem + defaultOffset;
                            Instruction jumpTargetInstruction = instructions[jumpTargetPC];
                            if (jumpTargetPC == nextPC) {
                                newNextPC = nextPC;
                            } else {
                                jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)(pc.elem + defaultOffset)));
                                instructions[pc.elem] = POP$.MODULE$;
                                i = pc.elem + 1;
                                if (jumpTargetInstruction.isGotoInstruction()) {
                                    GotoInstruction nextGoto = jumpTargetInstruction.asGotoInstruction();
                                    int newBranchoffset = nextGoto.branchoffset() + defaultOffset - (nextPC - 3 - pc.elem);
                                    if (newBranchoffset >= Short.MIN_VALUE && newBranchoffset <= Short.MAX_VALUE) {
                                        newNextPC = nextPC - 3;
                                        instructions[newNextPC] = new GOTO(newBranchoffset);
                                        instructions[nextPC - 2] = null;
                                        instructions[nextPC - 1] = null;
                                    } else {
                                        newNextPC = nextPC - 5;
                                        instructions[newNextPC] = new GOTO_W(newBranchoffset + 2);
                                        instructions[nextPC - 4] = null;
                                        instructions[nextPC - 3] = null;
                                        instructions[nextPC - 2] = null;
                                        instructions[nextPC - 1] = null;
                                    }
                                } else {
                                    newNextPC = nextPC - 3;
                                    instructions[nextPC - 3] = new GOTO(defaultOffset - (newNextPC - pc.elem));
                                    instructions[nextPC - 2] = null;
                                    instructions[nextPC - 1] = null;
                                }
                            }
                            while (i < newNextPC) {
                                instructions[i] = NOP$.MODULE$;
                                ++i;
                            }
                            simplified.elem = true;
                            break;
                        }
                        jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)(pc.elem + defaultOffset)));
                        switchInstruction.jumpOffsets().foreach((Function1)new Serializable($this, jumpTargetInstructions, pc){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef jumpTargetInstructions$1;
                            private final IntRef pc$1;

                            public final void apply(int branchoffset) {
                                this.apply$mcVI$sp(branchoffset);
                            }

                            public void apply$mcVI$sp(int branchoffset) {
                                this.jumpTargetInstructions$1.elem = (Set)((Set)this.jumpTargetInstructions$1.elem).$plus((Object)BoxesRunTime.boxToInteger((int)(this.pc$1.elem + branchoffset)));
                            }
                            {
                                this.jumpTargetInstructions$1 = jumpTargetInstructions$1;
                                this.pc$1 = pc$1;
                            }
                        });
                        break;
                    }
                    case 200: {
                        Instruction instruction3 = instruction;
                        if (instruction3 instanceof GOTO_W) {
                            GOTO_W gOTO_W = (GOTO_W)instruction3;
                            int branchoffset = gOTO_W.branchoffset();
                            int n3 = branchoffset;
                            int branchoffset3 = n3;
                            int jumpTargetPC = pc.elem + branchoffset3;
                            if (jumpTargetPC == nextPC) {
                                instructions[pc.elem] = NOP$.MODULE$;
                                instructions[pc.elem + 1] = NOP$.MODULE$;
                                instructions[pc.elem + 2] = NOP$.MODULE$;
                                instructions[pc.elem + 3] = NOP$.MODULE$;
                                instructions[pc.elem + 4] = NOP$.MODULE$;
                                simplified.elem = true;
                                break;
                            }
                            int newBranchoffset = BytecodeOptimizer$class.finalJumpTarget$1($this, pc.elem, jumpTargetPC, branchoffset3, instructions);
                            if (newBranchoffset == branchoffset3) break;
                            jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)(pc.elem + newBranchoffset)));
                            if (newBranchoffset >= Short.MIN_VALUE && newBranchoffset <= Short.MAX_VALUE) {
                                instructions[pc.elem + 0] = NOP$.MODULE$;
                                instructions[pc.elem + 1] = NOP$.MODULE$;
                                instructions[pc.elem + 2] = new GOTO(newBranchoffset);
                                simplified.elem = true;
                                break;
                            }
                            instructions[pc.elem] = new GOTO_W(newBranchoffset);
                            simplified.elem = true;
                            break;
                        }
                        throw new MatchError((Object)instruction3);
                    }
                    case 167: {
                        Instruction instruction4 = instruction;
                        if (instruction4 instanceof GOTO) {
                            GOTO gOTO = (GOTO)instruction4;
                            int branchoffset = gOTO.branchoffset();
                            int n4 = branchoffset;
                            int branchoffset4 = n4;
                            int jumpTargetPC = pc.elem + branchoffset4;
                            if (jumpTargetPC == nextPC) {
                                instructions[pc.elem] = NOP$.MODULE$;
                                instructions[pc.elem + 1] = NOP$.MODULE$;
                                instructions[pc.elem + 2] = NOP$.MODULE$;
                                simplified.elem = true;
                                break;
                            }
                            int newBranchoffset = BytecodeOptimizer$class.finalJumpTarget$1($this, pc.elem, jumpTargetPC, branchoffset4, instructions);
                            if (newBranchoffset != branchoffset4 && newBranchoffset >= Short.MIN_VALUE && newBranchoffset <= Short.MAX_VALUE) {
                                jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)(pc.elem + newBranchoffset)));
                                instructions[pc.elem] = new GOTO(newBranchoffset);
                                simplified.elem = true;
                                break;
                            }
                            jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)jumpTargetPC));
                            break;
                        }
                        throw new MatchError((Object)instruction4);
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 198: 
                    case 199: {
                        GotoInstruction nextGoto;
                        int newBranchoffset;
                        SimpleConditionalBranchInstruction<?> ifInstruction = instruction.asSimpleConditionalBranchInstruction();
                        int branchoffset = ifInstruction.branchoffset();
                        int jumpTargetPC = pc.elem + branchoffset;
                        if (jumpTargetPC == nextPC) {
                            instructions[pc.elem] = ifInstruction.numberOfPoppedOperands((Function1<Object, ComputationalTypeCategory>)package$.MODULE$.NotRequired()) == 1 ? POP$.MODULE$ : POP2$.MODULE$;
                            instructions[pc.elem + 1] = NOP$.MODULE$;
                            instructions[pc.elem + 2] = NOP$.MODULE$;
                            simplified.elem = true;
                            break;
                        }
                        Instruction jumpTargetInstruction = instructions[jumpTargetPC];
                        Instruction nextInstruction = instructions[nextPC];
                        if (nextInstruction.isGotoInstruction() && branchoffset == 6) {
                            int nextGotoInstructionBranchoffset = nextInstruction.asGotoInstruction().branchoffset();
                            if (nextGotoInstructionBranchoffset == 3) {
                                instructions[pc.elem + 0] = ifInstruction.numberOfPoppedOperands((Function1<Object, ComputationalTypeCategory>)package$.MODULE$.NotRequired()) == 1 ? POP$.MODULE$ : POP2$.MODULE$;
                                instructions[pc.elem + 1] = NOP$.MODULE$;
                                instructions[pc.elem + 2] = NOP$.MODULE$;
                                instructions[pc.elem + 3] = NOP$.MODULE$;
                                instructions[pc.elem + 4] = NOP$.MODULE$;
                                instructions[pc.elem + 5] = NOP$.MODULE$;
                                simplified.elem = true;
                                break;
                            }
                            if (jumpTargetInstruction.isGotoInstruction()) {
                                totallyConfusedIfs = (Set)totallyConfusedIfs.$plus((Object)BoxesRunTime.boxToInteger((int)pc.elem));
                                break;
                            }
                            confusedIfs = (Set)confusedIfs.$plus((Object)BoxesRunTime.boxToInteger((int)pc.elem));
                            break;
                        }
                        if (!jumpTargetInstruction.isGotoInstruction() || (newBranchoffset = (nextGoto = jumpTargetInstruction.asGotoInstruction()).branchoffset() + branchoffset) < Short.MIN_VALUE || newBranchoffset > Short.MAX_VALUE) break;
                        jumpTargetInstructions.elem = (Set)((Set)jumpTargetInstructions.elem).$plus((Object)BoxesRunTime.boxToInteger((int)(pc.elem + newBranchoffset)));
                        instructions[pc.elem] = ifInstruction.copy(newBranchoffset);
                        simplified.elem = true;
                    }
                }
                pc.elem = nextPC;
                modifiedByWide = false;
            }
            ((IterableLike)confusedIfs.filter((Function1)new Serializable($this, jumpTargetInstructions){
                public static final long serialVersionUID = 0L;
                private final ObjectRef jumpTargetInstructions$1;

                public final boolean apply(int cIfPC) {
                    return this.apply$mcZI$sp(cIfPC);
                }

                public boolean apply$mcZI$sp(int cIfPC) {
                    return !((Set)this.jumpTargetInstructions$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)(cIfPC + 3)));
                }
                {
                    this.jumpTargetInstructions$1 = jumpTargetInstructions$1;
                }
            })).foreach((Function1)new Serializable($this, simplified, instructions){
                public static final long serialVersionUID = 0L;
                private final BooleanRef simplified$1;
                private final Instruction[] instructions$1;

                public final void apply(int cIfPC) {
                    this.apply$mcVI$sp(cIfPC);
                }

                public void apply$mcVI$sp(int cIfPC) {
                    int newBranchoffset = this.instructions$1[cIfPC + 3].asGotoInstruction().branchoffset() + 3;
                    if (newBranchoffset >= Short.MIN_VALUE && newBranchoffset <= Short.MAX_VALUE) {
                        SimpleConditionalBranchInstruction<?> newIf;
                        SimpleConditionalBranchInstruction<?> oldIf = this.instructions$1[cIfPC].asSimpleConditionalBranchInstruction();
                        this.instructions$1[cIfPC] = newIf = oldIf.negate(newBranchoffset);
                        this.instructions$1[cIfPC + 3] = NOP$.MODULE$;
                        this.instructions$1[cIfPC + 4] = NOP$.MODULE$;
                        this.instructions$1[cIfPC + 5] = NOP$.MODULE$;
                        this.simplified$1.elem = true;
                    }
                }
                {
                    this.simplified$1 = simplified$1;
                    this.instructions$1 = instructions$1;
                }
            });
            ((IterableLike)totallyConfusedIfs.filter((Function1)new Serializable($this, jumpTargetInstructions){
                public static final long serialVersionUID = 0L;
                private final ObjectRef jumpTargetInstructions$1;

                public final boolean apply(int cIfPC) {
                    return this.apply$mcZI$sp(cIfPC);
                }

                public boolean apply$mcZI$sp(int cIfPC) {
                    return !((Set)this.jumpTargetInstructions$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)(cIfPC + 3))) && !((Set)this.jumpTargetInstructions$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)(cIfPC + 6)));
                }
                {
                    this.jumpTargetInstructions$1 = jumpTargetInstructions$1;
                }
            })).foreach((Function1)new Serializable($this, simplified, instructions){
                public static final long serialVersionUID = 0L;
                private final BooleanRef simplified$1;
                private final Instruction[] instructions$1;

                public final void apply(int cIfPC) {
                    this.apply$mcVI$sp(cIfPC);
                }

                public void apply$mcVI$sp(int cIfPC) {
                    SimpleConditionalBranchInstruction<?> ifInstruction = this.instructions$1[cIfPC].asSimpleConditionalBranchInstruction();
                    GotoInstruction firstGotoInstruction = this.instructions$1[cIfPC + 3].asGotoInstruction();
                    GotoInstruction secondGotoInstruction = this.instructions$1[cIfPC + 6].asGotoInstruction();
                    if (firstGotoInstruction.branchoffset() == 6) {
                        int newBranchoffset = secondGotoInstruction.branchoffset() + 6;
                        if (newBranchoffset >= Short.MIN_VALUE && newBranchoffset <= Short.MAX_VALUE) {
                            this.instructions$1[cIfPC] = ifInstruction.copy(newBranchoffset);
                            this.instructions$1[cIfPC + 3] = NOP$.MODULE$;
                            this.instructions$1[cIfPC + 4] = NOP$.MODULE$;
                            this.instructions$1[cIfPC + 5] = NOP$.MODULE$;
                            this.instructions$1[cIfPC + 6] = NOP$.MODULE$;
                            this.instructions$1[cIfPC + 7] = NOP$.MODULE$;
                            this.instructions$1[cIfPC + 8] = NOP$.MODULE$;
                            this.simplified$1.elem = true;
                        }
                    } else {
                        int secondAdjustedBranchoffset;
                        int firstAdjustedBranchoffset = firstGotoInstruction.branchoffset() + 3;
                        if (firstAdjustedBranchoffset < (secondAdjustedBranchoffset = secondGotoInstruction.branchoffset() + 6)) {
                            int newBranchoffset = firstAdjustedBranchoffset;
                            if (newBranchoffset >= Short.MIN_VALUE && newBranchoffset <= Short.MAX_VALUE) {
                                this.instructions$1[cIfPC] = ifInstruction.negate(firstAdjustedBranchoffset);
                                this.instructions$1[cIfPC + 3] = NOP$.MODULE$;
                                this.instructions$1[cIfPC + 4] = NOP$.MODULE$;
                                this.instructions$1[cIfPC + 5] = NOP$.MODULE$;
                                this.simplified$1.elem = true;
                            }
                        } else {
                            int newIfBranchoffset = secondAdjustedBranchoffset;
                            int newGotoBranchoffset = firstAdjustedBranchoffset - 6;
                            if (newIfBranchoffset >= Short.MIN_VALUE && newIfBranchoffset <= Short.MAX_VALUE && newGotoBranchoffset >= Short.MIN_VALUE && newGotoBranchoffset <= Short.MAX_VALUE) {
                                this.instructions$1[cIfPC] = ifInstruction.negate(firstAdjustedBranchoffset);
                                this.instructions$1[cIfPC + 3] = NOP$.MODULE$;
                                this.instructions$1[cIfPC + 4] = NOP$.MODULE$;
                                this.instructions$1[cIfPC + 5] = NOP$.MODULE$;
                                this.instructions$1[cIfPC + 6] = new GOTO(newGotoBranchoffset);
                                this.simplified$1.elem = true;
                            }
                        }
                    }
                }
                {
                    this.simplified$1 = simplified$1;
                    this.instructions$1 = instructions$1;
                }
            });
            return simplified.elem;
        }
        return var3_3.elem;
    }

    private static final int finalJumpTarget$1(BytecodeOptimizer $this, int startPC, int currentPC, int effectiveBranchoffset, Instruction[] instructions$1) {
        int n;
        block2: {
            while (true) {
                Instruction instruction;
                Option<Object> option;
                if ((option = GotoInstruction$.MODULE$.unapply(instruction = instructions$1[currentPC])).isEmpty()) {
                    n = effectiveBranchoffset;
                    break block2;
                }
                int branchoffset = BoxesRunTime.unboxToInt((Object)option.get());
                int nextPC = currentPC + branchoffset;
                if (nextPC == startPC) break;
                effectiveBranchoffset += branchoffset;
                currentPC = nextPC;
            }
            n = effectiveBranchoffset;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static void $init$(BytecodeOptimizer $this) {
        void var2_2;
        String key = "org.opalj.br.reader.ClassFileReader.BytecodeOptimizer.simplifyControlFlow";
        boolean simplifyControlFlow = BoxesRunTime.unboxToBoolean((Object)((Option)Ficus$.MODULE$.toFicusConfig(((ClassFileReaderConfiguration)$this).config()).as(key, Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.booleanValueReader()))).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
        if (simplifyControlFlow) {
            OPALLogger$.MODULE$.info("class file reader", "the control-flow is simplified", ((ClassFileReaderConfiguration)$this).logContext());
        } else {
            OPALLogger$.MODULE$.info("class file reader", "the control-flow is not simplified", ((ClassFileReaderConfiguration)$this).logContext());
        }
        $this.org$opalj$br$reader$BytecodeOptimizer$_setter_$PerformControlFlowSimplifications_$eq((boolean)var2_2);
        String key2 = "org.opalj.br.reader.ClassFileReader.BytecodeOptimizer.logControlFlowSimplification";
        boolean logControlFlowSimplification = BoxesRunTime.unboxToBoolean((Object)((Option)Ficus$.MODULE$.toFicusConfig(((ClassFileReaderConfiguration)$this).config()).as(key2, Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.booleanValueReader()))).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        if (logControlFlowSimplification) {
            OPALLogger$.MODULE$.info("class file reader", "control flow simplifications are logged", ((ClassFileReaderConfiguration)$this).logContext());
        } else {
            OPALLogger$.MODULE$.info("class file reader", "control flow simplifications are not logged", ((ClassFileReaderConfiguration)$this).logContext());
        }
        $this.org$opalj$br$reader$BytecodeOptimizer$_setter_$LogControlFlowSimplifications_$eq(logControlFlowSimplification);
    }
}

