/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Map;
import java.util.Set;
import net.ceedubs.ficus.Ficus$;
import net.ceedubs.ficus.readers.NameMapper$;
import net.ceedubs.ficus.readers.ValueReader;
import org.opalj.fpcf.FPCFAnalysesRegistry;
import org.opalj.fpcf.FPCFAnalysisRunner;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaReflectionException;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.runtime.package$;

public final class FPCFAnalysesRegistry$ {
    public static final FPCFAnalysesRegistry$ MODULE$;
    private Map<String, FPCFAnalysisRunner> idToFactory;
    private Map<String, String> idToDescription;

    static {
        new FPCFAnalysesRegistry$();
    }

    public synchronized void register(String analysisID, String analysisDescription, String analysisFactory) {
        Option<FPCFAnalysisRunner> analysisRunner = this.resolveAnalysisRunner(analysisFactory);
        if (analysisRunner.nonEmpty()) {
            this.idToFactory = this.idToFactory.$plus(new Tuple2((Object)analysisID, analysisRunner.get()));
            this.idToDescription = this.idToDescription.$plus(new Tuple2((Object)analysisID, (Object)analysisDescription));
        } else {
            OPALLogger$.MODULE$.error("setup", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown fix-point analysis. Analysis runner could not be instantiated: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analysisFactory})), (LogContext)GlobalLogContext$.MODULE$);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Option<FPCFAnalysisRunner> resolveAnalysisRunner(String fqn) {
        void var3_3;
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Option result = Option$.MODULE$.empty();
        try {
            Symbols.ModuleSymbolApi module2 = ((Mirror)mirror).staticModule(fqn);
            result = new Some((Object)((FPCFAnalysisRunner)mirror.reflectModule(module2).instance()));
        }
        catch (ClassCastException classCastException) {
        }
        catch (ScalaReflectionException scalaReflectionException) {
            // empty catch block
        }
        return var3_3;
    }

    public void registerFromConfig() {
        Config config = (Config)Ficus$.MODULE$.toFicusConfig(ConfigFactory.load()).as("org.opalj.fpcf.registry.analyses", Ficus$.MODULE$.configValueReader());
        try {
            Set entries = config.entrySet();
            for (Map.Entry confMap : entries) {
                List configuredAnalyses = (List)Ficus$.MODULE$.toFicusConfig(config).as((String)confMap.getKey(), Ficus$.MODULE$.traversableReader((ValueReader)new ValueReader<FPCFAnalysesRegistry.AnalysisFactory>(){

                    public <B> ValueReader<B> map(Function1<FPCFAnalysesRegistry.AnalysisFactory, B> f) {
                        return ValueReader.class.map((ValueReader)this, f);
                    }

                    public FPCFAnalysesRegistry.AnalysisFactory read(Config config, String path) {
                        return new FPCFAnalysesRegistry.AnalysisFactory((String)Ficus$.MODULE$.stringValueReader().read(config, new StringBuilder().append((Object)path).append((Object)".").append((Object)NameMapper$.MODULE$.apply(NameMapper$.MODULE$.apply$default$1()).map("id")).toString()), (String)Ficus$.MODULE$.stringValueReader().read(config, new StringBuilder().append((Object)path).append((Object)".").append((Object)NameMapper$.MODULE$.apply(NameMapper$.MODULE$.apply$default$1()).map("description")).toString()), (String)Ficus$.MODULE$.stringValueReader().read(config, new StringBuilder().append((Object)path).append((Object)".").append((Object)NameMapper$.MODULE$.apply(NameMapper$.MODULE$.apply$default$1()).map("factory")).toString()));
                    }
                    {
                        ValueReader.class.$init$((ValueReader)this);
                    }
                }, List$.MODULE$.canBuildFrom()));
                configuredAnalyses.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FPCFAnalysesRegistry.AnalysisFactory a) {
                        Predef$.MODULE$.println((Object)a);
                        FPCFAnalysesRegistry$.MODULE$.register(a.id(), a.description(), a.factory());
                    }
                });
            }
        }
        catch (Exception exception) {
            OPALLogger$.MODULE$.error("setup", "Error creating the FixpointRegistry. Invalid config. (org.opalj.fcpf.registry.analyses)", (LogContext)GlobalLogContext$.MODULE$);
        }
    }

    public void main(String[] args) {
    }

    public synchronized Iterable<String> analysisIDs() {
        return this.idToFactory.keys();
    }

    public synchronized Iterable<String> analysisDescriptions() {
        return this.idToDescription.values();
    }

    public synchronized Iterable<FPCFAnalysisRunner> factories() {
        return this.idToFactory.values();
    }

    public synchronized FPCFAnalysisRunner factory(String id) {
        return (FPCFAnalysisRunner)this.idToFactory.apply((Object)id);
    }

    private FPCFAnalysesRegistry$() {
        MODULE$ = this;
        this.idToFactory = Predef$.MODULE$.Map().empty();
        this.idToDescription = Predef$.MODULE$.Map().empty();
        this.registerFromConfig();
    }
}

