/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.frex;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import java.util.regex.Pattern;

public class Frex {
    private final String pat;

    private Frex(String direct) {
        this.pat = direct;
    }

    public static Frex or(Frex a, Frex ... bs) {
        return Arrays.stream(bs).reduce(new Frex("(" + a.pat + ")"), (x, y) -> new Frex(x.pat + "|(" + y.pat + ")"));
    }

    public static Frex contains(Frex frex) {
        return new Frex(".*(" + frex.pat + ").*");
    }

    public static Frex startsWith(Frex frex) {
        return new Frex(frex.pat + ".*");
    }

    public String buildPatternString() {
        return this.pat;
    }

    public Pattern buildPattern() {
        return Pattern.compile(this.pat);
    }

    public Pattern buildCaseInsensitivePattern() {
        return Pattern.compile(this.pat, 2);
    }

    public static Frex txt(String str) {
        return str.chars().mapToObj(c -> new Frex((char)c)).reduce(Frex::andThen).get();
    }

    public static Frex txt(String name, String str) {
        return new Frex("(?<" + name + ">" + str.chars().mapToObj((IntFunction<Frex>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$txt$2(int ), (I)Lde/pfabulist/frex/Frex;)()).reduce((BinaryOperator<Frex>)(BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, andThen(de.pfabulist.frex.Frex ), (Lde/pfabulist/frex/Frex;Lde/pfabulist/frex/Frex;)Lde/pfabulist/frex/Frex;)()).get().pat + ")");
    }

    private Frex(char ch) {
        switch (ch) {
            case '\\': {
                this.pat = "\\\\";
                break;
            }
            case '.': {
                this.pat = "\\.";
                break;
            }
            case '(': {
                this.pat = "\\(";
                break;
            }
            case ')': {
                this.pat = "\\)";
                break;
            }
            default: {
                this.pat = "" + ch;
            }
        }
    }

    public Frex andThen(Frex then) {
        return new Frex(this.pat + then.pat);
    }

    public static Frex num() {
        return new Frex("\\d*");
    }

    public static Frex num(String name) {
        return new Frex("(?<" + name + ">\\d*" + ")");
    }

    public static Frex hexDigit() {
        return new Frex("\\p{XDigit}");
    }

    public Frex times(int num) {
        return new Frex("(" + this.pat + "){" + num + "}");
    }

    public static Frex uuid(String name) {
        return Frex.var(name, Frex.uuid());
    }

    public static Frex uuid() {
        return Frex.hexDigit().times(8).andThen(Frex.txt("-")).andThen(Frex.hexDigit().times(4)).andThen(Frex.txt("-")).andThen(Frex.hexDigit().times(4)).andThen(Frex.txt("-")).andThen(Frex.hexDigit().times(4)).andThen(Frex.txt("-")).andThen(Frex.hexDigit().times(12));
    }

    public static Frex var(String name, Frex frex) {
        return new Frex("(?<" + name + ">" + frex.pat + ")");
    }

    public static Frex any() {
        return new Frex(".");
    }

    public Frex zeroOrMore() {
        return new Frex("(" + this.pat + ")*");
    }

    public Frex oneOrMore() {
        return new Frex("(" + this.pat + ")+");
    }

    private static /* synthetic */ Frex lambda$txt$2(int c) {
        return new Frex((char)c);
    }
}

