/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.authorizer;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.awslambda.AwsLambdaEvent;
import de.quantummaid.httpmaid.awslambda.EventUtils;
import de.quantummaid.httpmaid.awslambda.WebsocketEventUtils;
import de.quantummaid.httpmaid.awslambda.authorizer.AuthorizationDecisionMapper;
import de.quantummaid.httpmaid.awslambda.authorizer.LambdaAuthorizer;
import de.quantummaid.httpmaid.awslambda.authorizer.MapSerializer;
import de.quantummaid.httpmaid.awslambda.registry.EntryDeserializer;
import de.quantummaid.httpmaid.awslambda.sender.AwsWebsocketSender;
import de.quantummaid.httpmaid.endpoint.RawResponse;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketAuthorizationBuilder;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LambdaWebsocketAuthorizer
implements LambdaAuthorizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LambdaWebsocketAuthorizer.class);
    public static final String REGISTRY_ENTRY_KEY = "registryEntry";
    private final HttpMaid httpMaid;

    public static LambdaWebsocketAuthorizer lambdaWebsocketAuthorizer(HttpMaid httpMaid) {
        Validators.validateNotNull((Object)httpMaid, (String)"httpMaid");
        return new LambdaWebsocketAuthorizer(httpMaid);
    }

    @Override
    public Map<String, Object> delegate(Map<String, Object> event) {
        Map<String, Object> authorizerContext;
        AwsLambdaEvent awsLambdaEvent = AwsLambdaEvent.awsLambdaEvent(event);
        String methodArn = EventUtils.extractMethodArn((AwsLambdaEvent)awsLambdaEvent);
        log.debug("extracted methodArn: {}", (Object)methodArn);
        RawResponse authorizationResponse = LambdaWebsocketAuthorizer.authorize(awsLambdaEvent, this.httpMaid);
        AuthorizationDecision decision = (AuthorizationDecision)authorizationResponse.metaData().get(AuthorizationDecision.AUTHORIZATION_DECISION);
        if (decision.isAuthorized()) {
            WebsocketRegistryEntry registryEntry = (WebsocketRegistryEntry)authorizationResponse.metaData().get(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY_ENTRY);
            Map<String, Object> serializedEntry = EntryDeserializer.serializeEntry(registryEntry);
            String stringifiedEntry = MapSerializer.toString(serializedEntry);
            authorizerContext = Map.of(REGISTRY_ENTRY_KEY, stringifiedEntry);
        } else {
            authorizerContext = Collections.emptyMap();
        }
        String principalId = UUID.randomUUID().toString();
        return AuthorizationDecisionMapper.mapAuthorizationDecision(decision.isAuthorized(), methodArn, principalId, authorizerContext);
    }

    public static RawResponse authorize(AwsLambdaEvent event, HttpMaid httpMaid) {
        return (RawResponse)httpMaid.handleRequestSynchronously(() -> {
            RawWebsocketAuthorizationBuilder builder = RawWebsocketAuthorizationBuilder.rawWebsocketAuthorizationBuilder((WebsocketSenderId)AwsWebsocketSender.AWS_WEBSOCKET_SENDER);
            builder.withAdditionalMetaData(AwsLambdaEvent.AWS_LAMBDA_EVENT, (Object)event);
            QueryParameters queryParameters = WebsocketEventUtils.extractQueryParameters(event);
            builder.withQueryParameters(queryParameters);
            Headers headers = WebsocketEventUtils.extractHeaders(event);
            builder.withHeaders(headers);
            return builder.build();
        }, response -> response);
    }

    @Generated
    private LambdaWebsocketAuthorizer(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

