/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.registry;

import de.quantummaid.httpmaid.awslambda.sender.AwsWebsocketSender;
import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameter;
import de.quantummaid.httpmaid.http.QueryParameterName;
import de.quantummaid.httpmaid.http.QueryParameterValue;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntryDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntryDeserializer.class);
    private static final String HEADERS = "h";
    private static final String NAME = "n";
    private static final String VALUE = "v";
    private static final String QUERY_PARAMETERS = "q";
    private static final String ADDITIONAL_DATA = "a";

    private EntryDeserializer() {
    }

    public static WebsocketRegistryEntry deserializeEntry(ConnectionInformation connectionInformation, Map<String, Object> map) {
        Validators.validateNotNull((Object)connectionInformation, (String)"connectionInformation");
        Validators.validateNotNull(map, (String)"map");
        log.trace("deserializing entry {}", map);
        List serializedHeaders = (List)map.get(HEADERS);
        List headers = serializedHeaders.stream().map(headerMap -> {
            String name = (String)headerMap.get(NAME);
            String value = (String)headerMap.get(VALUE);
            return Header.header((HeaderName)HeaderName.headerName((String)name), (HeaderValue)HeaderValue.headerValue((String)value));
        }).collect(Collectors.toList());
        List serializedQueryParameters = (List)map.get(QUERY_PARAMETERS);
        List queryParameters = serializedQueryParameters.stream().map(queryParameterMap -> {
            String name = (String)queryParameterMap.get(NAME);
            String value = (String)queryParameterMap.get(VALUE);
            return QueryParameter.queryParameter((QueryParameterName)QueryParameterName.queryParameterName((String)name), (QueryParameterValue)QueryParameterValue.queryParameterValue((String)value));
        }).collect(Collectors.toList());
        Map additionalData = (Map)map.get(ADDITIONAL_DATA);
        String senderId = AwsWebsocketSender.AWS_WEBSOCKET_SENDER.asString();
        return WebsocketRegistryEntry.restoreFromStrings((ConnectionInformation)connectionInformation, (String)senderId, (Headers)Headers.headers(headers), (QueryParameters)QueryParameters.queryParameters(queryParameters), (Map)additionalData);
    }

    public static Map<String, Object> serializeEntry(WebsocketRegistryEntry entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List headers = entry.headers().asList().stream().map(header -> Map.of(NAME, header.name().stringValue(), VALUE, header.value().stringValue())).collect(Collectors.toList());
        map.put(HEADERS, headers);
        List queryParameters = entry.queryParameters().asList().stream().map(queryParameter -> Map.of(NAME, queryParameter.name().stringValue(), VALUE, queryParameter.value().stringValue())).collect(Collectors.toList());
        map.put(QUERY_PARAMETERS, queryParameters);
        map.put(ADDITIONAL_DATA, entry.additionalData());
        return map;
    }
}

