/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.repository.dynamodb;

import de.quantummaid.httpmaid.awslambda.repository.Repository;
import de.quantummaid.httpmaid.awslambda.repository.dynamodb.DynamoDbMarshaller;
import de.quantummaid.httpmaid.awslambda.repository.dynamodb.DynamoDbRepositoryException;
import de.quantummaid.httpmaid.awslambda.repository.dynamodb.DynamoDbUnmarshaller;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public final class DynamoDbRepository
implements Repository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamoDbRepository.class);
    private static final String VALUE_IDENTIFIER = "value";
    private final DynamoDbClient dynamoDbClient;
    private final String tableName;
    private final String primaryKey;
    private final Double enforcedMaxWriteCapacityUnits;

    public static DynamoDbRepository dynamoDbRepository(String tableName, String primaryKey) {
        DynamoDbClient dynamoDbClient = (DynamoDbClient)DynamoDbClient.builder().build();
        return DynamoDbRepository.dynamoDbRepository(dynamoDbClient, tableName, primaryKey);
    }

    public static DynamoDbRepository dynamoDbRepository(DynamoDbClient dynamoDbClient, String tableName, String primaryKey) {
        return DynamoDbRepository.dynamoDbRepository(dynamoDbClient, tableName, primaryKey, null);
    }

    public static DynamoDbRepository dynamoDbRepository(DynamoDbClient dynamoDbClient, String tableName, String primaryKey, Double enforcedMaxWriteCapacityUnits) {
        Validators.validateNotNull((Object)dynamoDbClient, (String)"dynamoDbClient");
        Validators.validateNotNull((Object)tableName, (String)"tableName");
        Validators.validateNotNull((Object)primaryKey, (String)"primaryKey");
        return new DynamoDbRepository(dynamoDbClient, tableName, primaryKey, enforcedMaxWriteCapacityUnits);
    }

    @Override
    public void store(String key, Map<String, Object> value) {
        Map<String, Object> wrappedMap = Map.of(this.primaryKey, key, VALUE_IDENTIFIER, value);
        Map<String, AttributeValue> marshalledMap = DynamoDbMarshaller.marshalTopLevelMap(wrappedMap);
        PutItemResponse response = this.dynamoDbClient.putItem(builder -> {
            builder.tableName(this.tableName).item(marshalledMap);
            if (this.enforcedMaxWriteCapacityUnits != null) {
                builder.returnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
            }
        });
        if (this.enforcedMaxWriteCapacityUnits != null) {
            ConsumedCapacity consumedCapacity = response.consumedCapacity();
            double writeCapacityUnits = consumedCapacity.capacityUnits();
            log.info("write of item {} to DynamoDB table {} consumed {} WCUs", new Object[]{key, this.tableName, writeCapacityUnits});
            if (writeCapacityUnits > this.enforcedMaxWriteCapacityUnits) {
                throw DynamoDbRepositoryException.dynamoDbRepositoryException("write capacity units of item " + key + " in DynamoDB table " + this.tableName + " consumed " + writeCapacityUnits + " WCUs but is only allowed to consume " + this.enforcedMaxWriteCapacityUnits + " WCUs (value: " + value + ")");
            }
        }
    }

    @Override
    public void delete(String key) {
        Map<String, AttributeValue> keyMap = DynamoDbMarshaller.marshalTopLevelMap(Map.of(this.primaryKey, key));
        this.dynamoDbClient.deleteItem(builder -> builder.key(keyMap).tableName(this.tableName));
    }

    @Override
    public Map<String, Object> load(String key) {
        Map<String, AttributeValue> keyMap = DynamoDbMarshaller.marshalTopLevelMap(Map.of(this.primaryKey, key));
        GetItemResponse getItemResponse = this.dynamoDbClient.getItem(builder -> builder.key(keyMap).tableName(this.tableName));
        Map responseItem = getItemResponse.item();
        Map<String, Object> marshalled = DynamoDbUnmarshaller.unmarshalMap(responseItem);
        return (Map)marshalled.get(VALUE_IDENTIFIER);
    }

    @Override
    public Map<String, Map<String, Object>> loadAll() {
        ScanResponse scan = this.dynamoDbClient.scan(builder -> builder.tableName(this.tableName));
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        scan.items().stream().map(DynamoDbUnmarshaller::unmarshalMap).forEach(map -> {
            String key = (String)map.get(this.primaryKey);
            Map value = (Map)map.get(VALUE_IDENTIFIER);
            result.put(key, value);
        });
        return result;
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public void close() {
        this.dynamoDbClient.close();
    }

    @Generated
    public String toString() {
        return "DynamoDbRepository(dynamoDbClient=" + this.dynamoDbClient + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", enforcedMaxWriteCapacityUnits=" + this.enforcedMaxWriteCapacityUnits + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDbRepository)) {
            return false;
        }
        DynamoDbRepository other = (DynamoDbRepository)o;
        Double this$enforcedMaxWriteCapacityUnits = this.enforcedMaxWriteCapacityUnits;
        Double other$enforcedMaxWriteCapacityUnits = other.enforcedMaxWriteCapacityUnits;
        if (this$enforcedMaxWriteCapacityUnits == null ? other$enforcedMaxWriteCapacityUnits != null : !((Object)this$enforcedMaxWriteCapacityUnits).equals(other$enforcedMaxWriteCapacityUnits)) {
            return false;
        }
        DynamoDbClient this$dynamoDbClient = this.dynamoDbClient;
        DynamoDbClient other$dynamoDbClient = other.dynamoDbClient;
        if (this$dynamoDbClient == null ? other$dynamoDbClient != null : !this$dynamoDbClient.equals(other$dynamoDbClient)) {
            return false;
        }
        String this$tableName = this.tableName;
        String other$tableName = other.tableName;
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.primaryKey;
        String other$primaryKey = other.primaryKey;
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $enforcedMaxWriteCapacityUnits = this.enforcedMaxWriteCapacityUnits;
        result = result * 59 + ($enforcedMaxWriteCapacityUnits == null ? 43 : ((Object)$enforcedMaxWriteCapacityUnits).hashCode());
        DynamoDbClient $dynamoDbClient = this.dynamoDbClient;
        result = result * 59 + ($dynamoDbClient == null ? 43 : $dynamoDbClient.hashCode());
        String $tableName = this.tableName;
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.primaryKey;
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    @Generated
    private DynamoDbRepository(DynamoDbClient dynamoDbClient, String tableName, String primaryKey, Double enforcedMaxWriteCapacityUnits) {
        this.dynamoDbClient = dynamoDbClient;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.enforcedMaxWriteCapacityUnits = enforcedMaxWriteCapacityUnits;
    }
}

