/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.sender;

import de.quantummaid.httpmaid.awslambda.AwsWebsocketConnectionInformation;
import de.quantummaid.httpmaid.awslambda.sender.ClientCache;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.AbstractGatewayClient;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.ApiGatewayClientFactory;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.GatewayOperation;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AwsWebsocketSender
implements WebsocketSender<AwsWebsocketConnectionInformation>,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AwsWebsocketSender.class);
    public static final WebsocketSenderId AWS_WEBSOCKET_SENDER = WebsocketSenderId.websocketSenderId((String)"AWS_WEBSOCKET_SENDER");
    private final ClientCache clientCache;

    public static AwsWebsocketSender awsWebsocketSender(ApiGatewayClientFactory clientFactory) {
        ClientCache clientCache = ClientCache.clientCache(clientFactory);
        return new AwsWebsocketSender(clientCache);
    }

    public void send(String message, List<AwsWebsocketConnectionInformation> connectionInformations, BiConsumer<AwsWebsocketConnectionInformation, Throwable> onException) {
        this.runOperation(connectionInformations, onException, (client, connectionId) -> client.sendMessage((String)connectionId, message));
    }

    public void disconnect(List<AwsWebsocketConnectionInformation> connectionInformations, BiConsumer<AwsWebsocketConnectionInformation, Throwable> onException) {
        this.runOperation(connectionInformations, onException, AbstractGatewayClient::disconnect);
    }

    private void runOperation(List<AwsWebsocketConnectionInformation> connectionInformations, BiConsumer<AwsWebsocketConnectionInformation, Throwable> onException, BiFunction<AbstractGatewayClient, String, GatewayOperation> operation) {
        Map<AwsWebsocketConnectionInformation, GatewayOperation> operations = connectionInformations.stream().collect(Collectors.toMap(connectionInformation -> connectionInformation, connectionInformation -> {
            String endpointUrl = connectionInformation.toEndpointUrl();
            AbstractGatewayClient client = this.clientCache.get(endpointUrl);
            String connectionId = connectionInformation.connectionId;
            return (GatewayOperation)operation.apply(client, connectionId);
        }));
        operations.forEach((connectionInformation, gatewayOperation) -> gatewayOperation.awaitResult(throwable -> onException.accept((AwsWebsocketConnectionInformation)connectionInformation, (Throwable)throwable)));
    }

    public WebsocketSenderId senderId() {
        return AWS_WEBSOCKET_SENDER;
    }

    @Override
    public void close() {
        this.clientCache.close();
    }

    @Generated
    public String toString() {
        return "AwsWebsocketSender(clientCache=" + this.clientCache + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsWebsocketSender)) {
            return false;
        }
        AwsWebsocketSender other = (AwsWebsocketSender)o;
        ClientCache this$clientCache = this.clientCache;
        ClientCache other$clientCache = other.clientCache;
        return !(this$clientCache == null ? other$clientCache != null : !this$clientCache.equals(other$clientCache));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientCache $clientCache = this.clientCache;
        result = result * 59 + ($clientCache == null ? 43 : $clientCache.hashCode());
        return result;
    }

    @Generated
    private AwsWebsocketSender(ClientCache clientCache) {
        this.clientCache = clientCache;
    }
}

