/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.sender;

import de.quantummaid.httpmaid.awslambda.sender.apigateway.AbstractGatewayClient;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.ApiGatewayClientFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class ClientCache
implements AutoCloseable {
    private final Map<String, AbstractGatewayClient> clientsByEndpointUrl;
    private final ApiGatewayClientFactory clientFactory;

    public static ClientCache clientCache(ApiGatewayClientFactory clientFactory) {
        return new ClientCache(new ConcurrentHashMap<String, AbstractGatewayClient>(), clientFactory);
    }

    public AbstractGatewayClient get(String endpointUrl) {
        return this.clientsByEndpointUrl.computeIfAbsent(endpointUrl, this.clientFactory::provide);
    }

    @Override
    public void close() {
        this.clientFactory.close();
        for (AbstractGatewayClient client : this.clientsByEndpointUrl.values()) {
            client.close();
        }
    }

    @Generated
    private ClientCache(Map<String, AbstractGatewayClient> clientsByEndpointUrl, ApiGatewayClientFactory clientFactory) {
        this.clientsByEndpointUrl = clientsByEndpointUrl;
        this.clientFactory = clientFactory;
    }
}

