/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.sender.apigateway.async;

import de.quantummaid.httpmaid.awslambda.sender.apigateway.AbstractGatewayClient;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.ApiGatewayClientUtils;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.GatewayOperation;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.async.FutureGatewayOperation;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiAsyncClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest;

public final class AsyncApiGatewayClient
implements AbstractGatewayClient {
    private final ApiGatewayManagementApiAsyncClient client;

    public static AbstractGatewayClient asyncApiGatewayClient(ApiGatewayManagementApiAsyncClient client) {
        return new AsyncApiGatewayClient(client);
    }

    @Override
    public GatewayOperation sendMessage(String connectionId, String message) {
        PostToConnectionRequest request = ApiGatewayClientUtils.postToConnectionRequest(connectionId, message);
        CompletableFuture future = this.client.postToConnection(request);
        return FutureGatewayOperation.futureGatewayOperation(future);
    }

    @Override
    public GatewayOperation disconnect(String connectionId) {
        DeleteConnectionRequest request = ApiGatewayClientUtils.deleteConnectionRequest(connectionId);
        CompletableFuture future = this.client.deleteConnection(request);
        return FutureGatewayOperation.futureGatewayOperation(future);
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Generated
    private AsyncApiGatewayClient(ApiGatewayManagementApiAsyncClient client) {
        this.client = client;
    }
}

