/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.sender.apigateway.sync;

import de.quantummaid.httpmaid.awslambda.sender.apigateway.AbstractGatewayClient;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.ApiGatewayClientUtils;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.GatewayOperation;
import de.quantummaid.httpmaid.awslambda.sender.apigateway.sync.AlreadyExecutedGatewayOperation;
import lombok.Generated;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest;

public final class SyncApiGatewayClient
implements AbstractGatewayClient {
    private final ApiGatewayManagementApiClient client;

    public static SyncApiGatewayClient syncApiGatewayClient(ApiGatewayManagementApiClient client) {
        return new SyncApiGatewayClient(client);
    }

    @Override
    public GatewayOperation sendMessage(String connectionId, String message) {
        PostToConnectionRequest request = ApiGatewayClientUtils.postToConnectionRequest(connectionId, message);
        return AlreadyExecutedGatewayOperation.executeSynchronouslyNow(() -> this.client.postToConnection(request));
    }

    @Override
    public GatewayOperation disconnect(String connectionId) {
        DeleteConnectionRequest request = ApiGatewayClientUtils.deleteConnectionRequest(connectionId);
        return AlreadyExecutedGatewayOperation.executeSynchronouslyNow(() -> this.client.deleteConnection(request));
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Generated
    private SyncApiGatewayClient(ApiGatewayManagementApiClient client) {
        this.client = client;
    }
}

