/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda;

import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import lombok.Generated;

public final class AwsWebsocketConnectionInformation
implements ConnectionInformation {
    public final String connectionId;
    public final String stage;
    public final String apiId;
    public final String region;

    public static AwsWebsocketConnectionInformation awsWebsocketConnectionInformation(String connectionId, String stage, String apiId, String region) {
        Validators.validateNotNull((Object)connectionId, (String)"connectionId");
        Validators.validateNotNull((Object)stage, (String)"stage");
        Validators.validateNotNull((Object)apiId, (String)"apiId");
        Validators.validateNotNull((Object)region, (String)"region");
        return new AwsWebsocketConnectionInformation(connectionId, stage, apiId, region);
    }

    public String toEndpointUrl() {
        String domainName = String.format("%s.execute-api.%s.amazonaws.com", this.apiId, this.region);
        return String.format("https://%s/%s", domainName, this.stage);
    }

    public String uniqueIdentifier() {
        return this.toEndpointUrl();
    }

    @Generated
    public String toString() {
        return "AwsWebsocketConnectionInformation(connectionId=" + this.connectionId + ", stage=" + this.stage + ", apiId=" + this.apiId + ", region=" + this.region + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsWebsocketConnectionInformation)) {
            return false;
        }
        AwsWebsocketConnectionInformation other = (AwsWebsocketConnectionInformation)o;
        String this$connectionId = this.connectionId;
        String other$connectionId = other.connectionId;
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$stage = this.stage;
        String other$stage = other.stage;
        if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
            return false;
        }
        String this$apiId = this.apiId;
        String other$apiId = other.apiId;
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        String this$region = this.region;
        String other$region = other.region;
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $connectionId = this.connectionId;
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $stage = this.stage;
        result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
        String $apiId = this.apiId;
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        String $region = this.region;
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    @Generated
    private AwsWebsocketConnectionInformation(String connectionId, String stage, String apiId, String region) {
        this.connectionId = connectionId;
        this.stage = stage;
        this.apiId = apiId;
        this.region = region;
    }
}

