/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.awslambda.AwsLambdaEvent;
import de.quantummaid.httpmaid.awslambda.AwsWebsocketConnectionInformation;
import de.quantummaid.httpmaid.awslambda.AwsWebsocketSender;
import de.quantummaid.httpmaid.http.HeadersBuilder;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnectBuilder;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketMessage;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public final class AwsWebsocketLambdaEndpoint {
    private static final String CONNECT_EVENT_TYPE = "CONNECT";
    private static final String DISCONNECT_EVENT_TYPE = "DISCONNECT";
    private static final String MESSAGE_EVENT_TYPE = "MESSAGE";
    private final HttpMaid httpMaid;

    public static AwsWebsocketLambdaEndpoint awsWebsocketLambdaEndpointFor(HttpMaid httpMaid) {
        Validators.validateNotNull((Object)httpMaid, (String)"httpMaid");
        return new AwsWebsocketLambdaEndpoint(httpMaid);
    }

    public Map<String, Object> delegate(Map<String, Object> event) {
        AwsLambdaEvent awsLambdaEvent = AwsLambdaEvent.awsLambdaEvent(event);
        return this.handleWebsocketRequest(awsLambdaEvent);
    }

    private Map<String, Object> handleWebsocketRequest(AwsLambdaEvent event) {
        AwsLambdaEvent requestContext = event.getMap("requestContext");
        String eventType = requestContext.getAsString("eventType");
        String connectionId = requestContext.getAsString("connectionId");
        String stage = requestContext.getAsString("stage");
        String apiId = requestContext.getAsString("apiId");
        String domainName = requestContext.getAsString("domainName");
        String region = AwsWebsocketLambdaEndpoint.extractRegionFromDomain(domainName);
        AwsWebsocketConnectionInformation connectionInformation = AwsWebsocketConnectionInformation.awsWebsocketConnectionInformation(connectionId, stage, apiId, region);
        if (CONNECT_EVENT_TYPE.equals(eventType)) {
            this.handleConnect(event, connectionInformation);
            return Collections.emptyMap();
        }
        if (DISCONNECT_EVENT_TYPE.equals(eventType)) {
            return Collections.emptyMap();
        }
        if (MESSAGE_EVENT_TYPE.equals(eventType)) {
            return this.handleMessage(event, connectionInformation);
        }
        throw new UnsupportedOperationException(String.format("Unsupported lambda event type '%s' with event '%s'", eventType, event));
    }

    private void handleConnect(AwsLambdaEvent event, AwsWebsocketConnectionInformation connectionInformation) {
        this.httpMaid.handleRequest(() -> {
            RawWebsocketConnectBuilder builder = RawWebsocketConnectBuilder.rawWebsocketConnectBuilder();
            builder.withConnectionInformation(AwsWebsocketSender.AWS_WEBSOCKET_SENDER, (ConnectionInformation)connectionInformation);
            Map queryParameters = (Map)event.getOrDefault("multiValueQueryStringParameters", HashMap::new);
            builder.withQueryParameterMap(queryParameters);
            Map headers = (Map)event.getOrDefault("multiValueHeaders", HashMap::new);
            HeadersBuilder headersBuilder = HeadersBuilder.headersBuilder();
            headersBuilder.withHeadersMap(headers);
            builder.withHeaders(headersBuilder.build());
            return builder.build();
        }, response -> {});
    }

    private Map<String, Object> handleMessage(AwsLambdaEvent event, ConnectionInformation connectionInformation) {
        return (Map)this.httpMaid.handleRequestSynchronously(() -> {
            String body = event.getAsString("body");
            return RawWebsocketMessage.rawWebsocketMessage((ConnectionInformation)connectionInformation, (String)body);
        }, response -> {
            LinkedHashMap responseMap = new LinkedHashMap();
            response.optionalStringBody().ifPresent(s -> responseMap.put("body", s));
            return responseMap;
        });
    }

    private static String extractRegionFromDomain(String domain) {
        return domain.split("\\.")[2];
    }

    @Generated
    public String toString() {
        return "AwsWebsocketLambdaEndpoint(httpMaid=" + this.httpMaid + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsWebsocketLambdaEndpoint)) {
            return false;
        }
        AwsWebsocketLambdaEndpoint other = (AwsWebsocketLambdaEndpoint)o;
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        return !(this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        return result;
    }

    @Generated
    private AwsWebsocketLambdaEndpoint(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

