/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.registry;

import de.quantummaid.httpmaid.awslambda.AwsWebsocketConnectionInformation;
import de.quantummaid.httpmaid.awslambda.repository.Repository;
import de.quantummaid.httpmaid.awslambda.repository.dynamodb.DynamoDbRepository;
import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameter;
import de.quantummaid.httpmaid.http.QueryParameterName;
import de.quantummaid.httpmaid.http.QueryParameterValue;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class DynamoDbWebsocketRegistry
implements WebsocketRegistry {
    private static final String TABLE_NAME = "WebsocketsTest";
    private final Repository repository;

    public static DynamoDbWebsocketRegistry dynamoDbWebsocketRegistry(Repository repository) {
        return new DynamoDbWebsocketRegistry(repository);
    }

    public static DynamoDbWebsocketRegistry dynamoDbWebsocketRegistry() {
        DynamoDbRepository repository = DynamoDbRepository.dynamoDbRepository(TABLE_NAME, "id");
        return DynamoDbWebsocketRegistry.dynamoDbWebsocketRegistry(repository);
    }

    public List<WebsocketRegistryEntry> connections() {
        List<Map<String, Object>> maps = this.repository.loadAll();
        return maps.stream().map(DynamoDbWebsocketRegistry::deserializeEntry).collect(Collectors.toList());
    }

    public WebsocketRegistryEntry byConnectionInformation(ConnectionInformation connectionInformation) {
        String key = connectionInformation.uniqueIdentifier();
        Map<String, Object> map = this.repository.load(key);
        return DynamoDbWebsocketRegistry.deserializeEntry(map);
    }

    public void addConnection(WebsocketRegistryEntry entry) {
        ConnectionInformation connectionInformation = entry.connectionInformation();
        String key = connectionInformation.uniqueIdentifier();
        Map<String, Object> map = DynamoDbWebsocketRegistry.serializeEntry(entry);
        this.repository.store(key, map);
    }

    private static WebsocketRegistryEntry deserializeEntry(Map<String, Object> map) {
        Map connectionInformationMap = (Map)map.get("connectionInformation");
        String connectionId = (String)connectionInformationMap.get("connectionId");
        String stage = (String)connectionInformationMap.get("stage");
        String apiId = (String)connectionInformationMap.get("apiId");
        String region = (String)connectionInformationMap.get("region");
        AwsWebsocketConnectionInformation connectionInformation = AwsWebsocketConnectionInformation.awsWebsocketConnectionInformation(connectionId, stage, apiId, region);
        String senderId = (String)map.get("senderId");
        List serializedHeaders = (List)map.get("headers");
        List headers = serializedHeaders.stream().map(headerMap -> {
            String name = (String)headerMap.get("name");
            String value = (String)headerMap.get("value");
            return Header.header((HeaderName)HeaderName.headerName((String)name), (HeaderValue)HeaderValue.headerValue((String)value));
        }).collect(Collectors.toList());
        Optional<String> contentType = Optional.ofNullable((String)map.get("contentType"));
        List serializedQueryParameters = (List)map.get("queryParameters");
        List queryParameters = serializedQueryParameters.stream().map(queryParameterMap -> {
            String name = (String)queryParameterMap.get("name");
            String value = (String)queryParameterMap.get("value");
            return QueryParameter.queryParameter((QueryParameterName)QueryParameterName.queryParameterName((String)name), (QueryParameterValue)QueryParameterValue.queryParameterValue((String)value));
        }).collect(Collectors.toList());
        return WebsocketRegistryEntry.restoreFromStrings((ConnectionInformation)connectionInformation, (String)senderId, (Headers)Headers.headers(headers), contentType, (QueryParameters)QueryParameters.queryParameters(queryParameters));
    }

    private static Map<String, Object> serializeEntry(WebsocketRegistryEntry entry) {
        AwsWebsocketConnectionInformation connectionInformation = (AwsWebsocketConnectionInformation)entry.connectionInformation();
        HashMap<String, String> connectionInformationMap = new HashMap<String, String>();
        connectionInformationMap.put("connectionId", connectionInformation.connectionId);
        connectionInformationMap.put("stage", connectionInformation.stage);
        connectionInformationMap.put("apiId", connectionInformation.apiId);
        connectionInformationMap.put("region", connectionInformation.region);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectionInformation", connectionInformationMap);
        map.put("senderId", entry.senderId().asString());
        List headers = entry.headers().asList().stream().map(header -> Map.of("name", header.name().stringValue(), "value", header.value().stringValue())).collect(Collectors.toList());
        map.put("headers", headers);
        String contentType = DynamoDbWebsocketRegistry.encodeContentType(entry.contentType());
        map.put("contentType", contentType);
        List queryParameters = entry.queryParameters().asList().stream().map(queryParameter -> Map.of("name", queryParameter.name().stringValue(), "value", queryParameter.value().stringValue())).collect(Collectors.toList());
        map.put("queryParameters", queryParameters);
        return map;
    }

    private static String encodeContentType(ContentType contentType) {
        if (contentType.isEmpty()) {
            return null;
        }
        return contentType.internalValueForMapping();
    }

    @Generated
    public String toString() {
        return "DynamoDbWebsocketRegistry(repository=" + this.repository + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDbWebsocketRegistry)) {
            return false;
        }
        DynamoDbWebsocketRegistry other = (DynamoDbWebsocketRegistry)o;
        Repository this$repository = this.repository;
        Repository other$repository = other.repository;
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Repository $repository = this.repository;
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }

    @Generated
    private DynamoDbWebsocketRegistry(Repository repository) {
        this.repository = repository;
    }
}

