/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.repository.dynamodb;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public final class DynamoDbUnmarshaller {
    private DynamoDbUnmarshaller() {
    }

    public static Map<String, Object> unmarshalMap(Map<String, AttributeValue> input) {
        HashMap<String, Object> result = new HashMap<String, Object>(input.size());
        input.keySet().forEach(key -> {
            AttributeValue attributeValue = (AttributeValue)input.get(key);
            Object value = DynamoDbUnmarshaller.unmarshal(attributeValue);
            result.put((String)key, value);
        });
        return result;
    }

    private static Object unmarshal(AttributeValue attributeValue) {
        if (attributeValue.hasM()) {
            Map map = attributeValue.m();
            return DynamoDbUnmarshaller.unmarshalMap(map);
        }
        Boolean nul = attributeValue.nul();
        if (nul != null && nul.booleanValue()) {
            return null;
        }
        if (attributeValue.s() != null) {
            return attributeValue.s();
        }
        if (attributeValue.l() != null) {
            return attributeValue.l().stream().map(DynamoDbUnmarshaller::unmarshal).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Unable to unmarshal from: " + attributeValue);
    }
}

