/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.repository.dynamodb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public final class DynamoDbMarshaller {
    private DynamoDbMarshaller() {
    }

    public static Map<String, AttributeValue> marshalTopLevelMap(Map<String, Object> map) {
        HashMap<String, AttributeValue> attributeValueMap = new HashMap<String, AttributeValue>(map.size());
        map.forEach((key, value) -> {
            AttributeValue marshalledValue = DynamoDbMarshaller.marshal(value);
            attributeValueMap.put((String)key, marshalledValue);
        });
        return attributeValueMap;
    }

    private static AttributeValue marshal(Object object) {
        if (object == null) {
            return DynamoDbMarshaller.marshalNull();
        }
        if (object instanceof String) {
            return DynamoDbMarshaller.marshalString((String)object);
        }
        if (object instanceof Map) {
            return DynamoDbMarshaller.marshalMap((Map)object);
        }
        if (object instanceof List) {
            return DynamoDbMarshaller.marshalList((List)object);
        }
        throw new UnsupportedOperationException("Unable to marshal object of type: " + object.getClass().getSimpleName());
    }

    private static AttributeValue marshalString(String string) {
        return (AttributeValue)AttributeValue.builder().s(string).build();
    }

    private static AttributeValue marshalMap(Map<String, Object> map) {
        Map<String, AttributeValue> attributeValueMap = DynamoDbMarshaller.marshalTopLevelMap(map);
        return (AttributeValue)AttributeValue.builder().m(attributeValueMap).build();
    }

    private static AttributeValue marshalList(List<Object> list) {
        List attributeValues = list.stream().map(DynamoDbMarshaller::marshal).collect(Collectors.toList());
        return (AttributeValue)AttributeValue.builder().l(attributeValues).build();
    }

    private static AttributeValue marshalNull() {
        return (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
    }
}

