/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.repository.dynamodb;

import de.quantummaid.httpmaid.awslambda.repository.Repository;
import de.quantummaid.httpmaid.awslambda.repository.dynamodb.DynamoDbMarshaller;
import de.quantummaid.httpmaid.awslambda.repository.dynamodb.DynamoDbUnmarshaller;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;

public final class DynamoDbRepository
implements Repository {
    private static final String VALUE_IDENTIFIER = "value";
    private final DynamoDbClient dynamoDbClient;
    private final String tableName;
    private final String primaryKey;

    public static DynamoDbRepository dynamoDbRepository(DynamoDbClient dynamoDbClient, String tableName, String primaryKey) {
        Validators.validateNotNull((Object)dynamoDbClient, (String)"dynamoDbClient");
        Validators.validateNotNull((Object)tableName, (String)"tableName");
        Validators.validateNotNull((Object)primaryKey, (String)"primaryKey");
        return new DynamoDbRepository(dynamoDbClient, tableName, primaryKey);
    }

    public static DynamoDbRepository dynamoDbRepository(String tableName, String primaryKey) {
        DynamoDbClient dynamoDbClient = (DynamoDbClient)DynamoDbClient.builder().build();
        return DynamoDbRepository.dynamoDbRepository(dynamoDbClient, tableName, primaryKey);
    }

    @Override
    public void store(String key, Map<String, Object> value) {
        Map<String, Object> wrappedMap = Map.of(this.primaryKey, key, VALUE_IDENTIFIER, value);
        Map<String, AttributeValue> marshalledMap = DynamoDbMarshaller.marshalTopLevelMap(wrappedMap);
        Put put = (Put)Put.builder().tableName(this.tableName).item(marshalledMap).build();
        TransactWriteItem transactWriteItem = (TransactWriteItem)TransactWriteItem.builder().put(put).build();
        TransactWriteItemsRequest transactionWriteRequest = (TransactWriteItemsRequest)TransactWriteItemsRequest.builder().transactItems(List.of(transactWriteItem)).build();
        this.dynamoDbClient.transactWriteItems(transactionWriteRequest);
    }

    @Override
    public void delete(String key) {
        Map<String, AttributeValue> keyMap = DynamoDbMarshaller.marshalTopLevelMap(Map.of(this.primaryKey, key));
        DeleteItemRequest deleteItemRequest = (DeleteItemRequest)DeleteItemRequest.builder().key(keyMap).tableName(this.tableName).build();
        this.dynamoDbClient.deleteItem(deleteItemRequest);
    }

    @Override
    public Map<String, Object> load(String key) {
        Map<String, AttributeValue> keyMap = DynamoDbMarshaller.marshalTopLevelMap(Map.of(this.primaryKey, key));
        GetItemRequest getItemRequest = (GetItemRequest)GetItemRequest.builder().key(keyMap).tableName(this.tableName).build();
        GetItemResponse getItemResponse = this.dynamoDbClient.getItem(getItemRequest);
        Map responseItem = getItemResponse.item();
        Map<String, Object> marshalled = DynamoDbUnmarshaller.unmarshalMap(responseItem);
        return (Map)marshalled.get(VALUE_IDENTIFIER);
    }

    @Override
    public List<Map<String, Object>> loadAll() {
        ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.tableName).build();
        ScanResponse scan = this.dynamoDbClient.scan(scanRequest);
        return scan.items().stream().map(DynamoDbUnmarshaller::unmarshalMap).map(map -> map.get(VALUE_IDENTIFIER)).map(object -> (Map)object).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.dynamoDbClient.close();
    }

    @Generated
    public String toString() {
        return "DynamoDbRepository(dynamoDbClient=" + this.dynamoDbClient + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDbRepository)) {
            return false;
        }
        DynamoDbRepository other = (DynamoDbRepository)o;
        DynamoDbClient this$dynamoDbClient = this.dynamoDbClient;
        DynamoDbClient other$dynamoDbClient = other.dynamoDbClient;
        if (this$dynamoDbClient == null ? other$dynamoDbClient != null : !this$dynamoDbClient.equals(other$dynamoDbClient)) {
            return false;
        }
        String this$tableName = this.tableName;
        String other$tableName = other.tableName;
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.primaryKey;
        String other$primaryKey = other.primaryKey;
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DynamoDbClient $dynamoDbClient = this.dynamoDbClient;
        result = result * 59 + ($dynamoDbClient == null ? 43 : $dynamoDbClient.hashCode());
        String $tableName = this.tableName;
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.primaryKey;
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    @Generated
    private DynamoDbRepository(DynamoDbClient dynamoDbClient, String tableName, String primaryKey) {
        this.dynamoDbClient = dynamoDbClient;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
    }
}

