/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.feel;

import de.redsix.dmncheck.feel.ExpressionType;
import de.redsix.dmncheck.feel.ExpressionTypes;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.util.Eithers;
import java.util.Collection;
import java.util.Objects;
import org.camunda.bpm.model.dmn.instance.ItemDefinition;
import org.camunda.bpm.model.dmn.instance.NamedElement;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Scanners;
import org.jparsec.Terminals;
import org.jparsec.Tokens;
import org.jparsec.error.ParserException;
import org.jparsec.pattern.Patterns;

public final class ExpressionTypeParser {
    private static final Parser<Void> IGNORED = Scanners.WHITESPACES.skipMany();
    private static final Parser<ExpressionType> STRING = Terminals.fragment((Object[])new Object[]{"stringfragment"}).map(__ -> ExpressionTypes.STRING());
    private static final Parser<ExpressionType> BOOLEAN = Terminals.fragment((Object[])new Object[]{"booleanfragment"}).map(__ -> ExpressionTypes.BOOLEAN());
    private static final Parser<ExpressionType> INTEGER = Terminals.fragment((Object[])new Object[]{"integerfragment"}).map(__ -> ExpressionTypes.INTEGER());
    private static final Parser<ExpressionType> LONG = Terminals.fragment((Object[])new Object[]{"longfragment"}).map(__ -> ExpressionTypes.LONG());
    private static final Parser<ExpressionType> DOUBLE = Terminals.fragment((Object[])new Object[]{"doublefragment"}).map(__ -> ExpressionTypes.DOUBLE());
    private static final Parser<ExpressionType> DATE = Terminals.fragment((Object[])new Object[]{"datefragment"}).map(__ -> ExpressionTypes.DATE());
    private static final Parser<ExpressionType> ENUM = Terminals.fragment((Object[])new Object[]{"enumfragment"}).map(ExpressionTypes::ENUM);
    private static final Parser<ExpressionType> TOP = Parsers.EOF.map(__ -> ExpressionTypes.TOP());

    private ExpressionTypeParser() {
    }

    private static Parser<?> TOKENIZER(Collection<ItemDefinition> itemDefinitions) {
        Parser itemDefinitionTokenizer = itemDefinitions.stream().map(NamedElement::getName).filter(Objects::nonNull).map(name -> Patterns.string((String)name).toScanner("itemDefinition").source().map(s -> Tokens.fragment((String)s, (Object)"itemDefinitionFragment"))).reduce(Parsers.never(), Parsers::or);
        return Parsers.or((Parser)Patterns.stringCaseInsensitive((String)"string").toScanner("string").source().map(s -> Tokens.fragment((String)s, (Object)"stringfragment")), (Parser)Patterns.stringCaseInsensitive((String)"boolean").toScanner("boolean").source().map(s -> Tokens.fragment((String)s, (Object)"booleanfragment")), (Parser)Patterns.stringCaseInsensitive((String)"integer").toScanner("boolean").source().map(s -> Tokens.fragment((String)s, (Object)"integerfragment")), (Parser)Patterns.stringCaseInsensitive((String)"long").toScanner("boolean").source().map(s -> Tokens.fragment((String)s, (Object)"longfragment")), (Parser)Patterns.stringCaseInsensitive((String)"double").toScanner("boolean").source().map(s -> Tokens.fragment((String)s, (Object)"doublefragment")), (Parser)Patterns.stringCaseInsensitive((String)"date").toScanner("boolean").source().map(s -> Tokens.fragment((String)s, (Object)"datefragment")), (Parser)itemDefinitionTokenizer, (Parser)Patterns.regex((String)"([a-z][a-z_0-9]*\\.)*[A-Z_]($[A-Z_]|[\\w_])*").toScanner("enum").source().map(s -> Tokens.fragment((String)s, (Object)"enumfragment")));
    }

    private static Parser<ExpressionType> ITEMDEFINITION(Collection<ItemDefinition> itemDefinitions) {
        return Terminals.fragment((Object[])new Object[]{"itemDefinitionFragment"}).map(name -> {
            ItemDefinition matchedItemDefinition = itemDefinitions.stream().filter(itemDefinition -> name.equals(itemDefinition.getName())).findFirst().orElseThrow(() -> new IllegalStateException("ItemDefinitions are broken."));
            return ExpressionTypes.ITEMDEFINITION(matchedItemDefinition);
        });
    }

    static Parser<ExpressionType> PARSER(Collection<ItemDefinition> itemDefinitions) {
        return Parsers.or(STRING, BOOLEAN, INTEGER, LONG, DOUBLE, DATE, ExpressionTypeParser.ITEMDEFINITION(itemDefinitions), ENUM, TOP).from(ExpressionTypeParser.TOKENIZER(itemDefinitions), IGNORED);
    }

    public static Either<ValidationResult.Builder.ElementStep, ExpressionType> parse(CharSequence charSequence, Collection<ItemDefinition> itemDefinitions) {
        try {
            return Eithers.right(charSequence != null ? (ExpressionType)ExpressionTypeParser.PARSER(itemDefinitions).parse(charSequence) : ExpressionTypes.TOP());
        }
        catch (ParserException e) {
            return Eithers.left(ValidationResult.init.message("Could not parse FEEL expression type '" + charSequence + "'"));
        }
    }
}

