/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.feel;

import de.redsix.dmncheck.feel.FeelExpression;
import de.redsix.dmncheck.feel.FeelExpressions;
import de.redsix.dmncheck.feel.Operator;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.util.Eithers;
import java.time.LocalDateTime;
import org.jparsec.OperatorTable;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Scanners;
import org.jparsec.Terminals;
import org.jparsec.Tokens;
import org.jparsec.error.ParserException;
import org.jparsec.pattern.Patterns;

public final class FeelParser {
    private static final Terminals OPERATORS = Terminals.operators((String[])new String[]{"+", "-", "*", "**", "/", "(", ")", "[", "]", "..", ",", "not(", "and", "or", "<", ">", "<=", ">=", "date and time(\"", "\")"});
    private static final Parser<Void> IGNORED = Scanners.WHITESPACES.skipMany();
    private static final Parser<?> TOKENIZER = Parsers.or((Parser)Patterns.regex((String)"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}").toScanner("date").source().map(s -> Tokens.fragment((String)s, (Object)"datefragment")), (Parser)Patterns.regex((String)"^-$").toScanner("empty").source().map(s -> Tokens.fragment((String)s, (Object)"emptyfragment")), (Parser)OPERATORS.tokenizer(), (Parser)Patterns.regex((String)"\"[^\"]*\"").toScanner("string").source().map(s -> Tokens.fragment((String)s, (Object)"stringfragment")), (Parser)Patterns.string((String)"true").or(Patterns.string((String)"false")).toScanner("boolean").source().map(s -> Tokens.fragment((String)s, (Object)"booleanfragment")), (Parser)Patterns.string((String)"null").toScanner("null").source().map(s -> Tokens.fragment((String)s, (Object)"nullfragment")), (Parser)Patterns.regex((String)"([a-zA-Z_$][\\w$\\.]*)").toScanner("variable").source().map(s -> Tokens.fragment((String)s, (Object)"variablefragment")), (Parser)Patterns.regex((String)"[0-9]+\\.[0-9]+").toScanner("strict-decimal").source().map(s -> Tokens.fragment((String)s, (Object)Tokens.Tag.DECIMAL)), (Parser)Terminals.IntegerLiteral.TOKENIZER.or(Terminals.IntegerLiteral.TOKENIZER));
    private static final Parser<FeelExpression> INTEGER = Terminals.IntegerLiteral.PARSER.map(Integer::valueOf).map(FeelExpressions::IntegerLiteral);
    private static final Parser<FeelExpression> DOUBLE = Terminals.DecimalLiteral.PARSER.map(Double::valueOf).map(FeelExpressions::DoubleLiteral);
    private static final Parser<FeelExpression> VARIABLE = Terminals.fragment((Object[])new Object[]{"variablefragment"}).map(FeelExpressions::VariableLiteral);
    private static final Parser<FeelExpression> STRING = Terminals.fragment((Object[])new Object[]{"stringfragment"}).map(s -> s.substring(1, s.length() - 1)).map(FeelExpressions::StringLiteral);
    private static final Parser<FeelExpression> BOOLEAN = Terminals.fragment((Object[])new Object[]{"booleanfragment"}).map(Boolean::valueOf).map(FeelExpressions::BooleanLiteral);
    private static final Parser<FeelExpression> NULL = Terminals.fragment((Object[])new Object[]{"nullfragment"}).map(__ -> FeelExpressions.Null());
    private static final Parser<FeelExpression> DATE = Parsers.between((Parser)OPERATORS.token("date and time(\""), (Parser)Terminals.fragment((Object[])new Object[]{"datefragment"}).map(LocalDateTime::parse).map(FeelExpressions::DateLiteral), (Parser)OPERATORS.token("\")"));
    static final Parser<FeelExpression> PARSER = FeelParser.feelExpressionParser().from(TOKENIZER, IGNORED);

    private FeelParser() {
    }

    private static Parser<FeelExpression> parseRangeExpression(Parser<Boolean> leftBound, Parser<FeelExpression> expression, Parser<Boolean> rightBound) {
        return Parsers.sequence(leftBound, expression, (Parser)OPERATORS.token("..").skipTimes(1), expression, rightBound, (isLeftInclusive, lowerBound, __, upperBound, isRightInclusive) -> FeelExpressions.RangeExpression(isLeftInclusive, lowerBound, upperBound, isRightInclusive));
    }

    private static Parser<FeelExpression> createRangeExpressionParser(Parser<FeelExpression> expressionParser) {
        return Parsers.or(FeelParser.parseRangeExpression(FeelParser.op("[", true), expressionParser, FeelParser.op("]", true)), FeelParser.parseRangeExpression(FeelParser.op("]", false), expressionParser, FeelParser.op("]", true)), FeelParser.parseRangeExpression(FeelParser.op("[", true), expressionParser, FeelParser.op("[", false)), FeelParser.parseRangeExpression(FeelParser.op("(", false), expressionParser, FeelParser.op("]", true)), FeelParser.parseRangeExpression(FeelParser.op("[", true), expressionParser, FeelParser.op(")", false)), FeelParser.parseRangeExpression(FeelParser.op("(", false), expressionParser, FeelParser.op(")", false)), FeelParser.parseRangeExpression(FeelParser.op("]", false), expressionParser, FeelParser.op(")", false)), FeelParser.parseRangeExpression(FeelParser.op("(", false), expressionParser, FeelParser.op("[", false)), FeelParser.parseRangeExpression(FeelParser.op("]", false), expressionParser, FeelParser.op("[", false)));
    }

    private static Parser<FeelExpression> createBinaryExpressionParser(Parser<FeelExpression> feelExpressionParser) {
        return new OperatorTable().infixr(FeelParser.op(",", FeelExpressions::DisjunctionExpression), 0).prefix(FeelParser.op("<", v -> FeelExpressions.UnaryExpression(Operator.LT, v)), 5).prefix(FeelParser.op(">", v -> FeelExpressions.UnaryExpression(Operator.GT, v)), 5).prefix(FeelParser.op("<=", v -> FeelExpressions.UnaryExpression(Operator.LE, v)), 5).prefix(FeelParser.op(">=", v -> FeelExpressions.UnaryExpression(Operator.GE, v)), 5).infixl(FeelParser.op("or", (l, r) -> FeelExpressions.BinaryExpression(l, Operator.OR, r)), 8).infixl(FeelParser.op("and", (l, r) -> FeelExpressions.BinaryExpression(l, Operator.AND, r)), 8).infixl(FeelParser.op("+", (l, r) -> FeelExpressions.BinaryExpression(l, Operator.ADD, r)), 10).infixl(FeelParser.op("-", (l, r) -> FeelExpressions.BinaryExpression(l, Operator.SUB, r)), 10).infixl(FeelParser.op("*", (l, r) -> FeelExpressions.BinaryExpression(l, Operator.MUL, r)), 20).infixl(FeelParser.op("**", (l, r) -> FeelExpressions.BinaryExpression(l, Operator.EXP, r)), 20).infixl(FeelParser.op("/", (l, r) -> FeelExpressions.BinaryExpression(l, Operator.DIV, r)), 20).prefix(FeelParser.op("-", v -> FeelExpressions.UnaryExpression(Operator.SUB, v)), 30).build(feelExpressionParser);
    }

    private static Parser<FeelExpression> parseNot(Parser<FeelExpression> feelParserReference) {
        return Parsers.between((Parser)OPERATORS.token("not("), feelParserReference, (Parser)OPERATORS.token(")")).map(expression -> {
            if (expression.containsNot()) {
                throw new RuntimeException("Negations cannot be nested in FEEL expressions.");
            }
            return FeelExpressions.UnaryExpression(Operator.NOT, expression);
        });
    }

    private static Parser<FeelExpression> parseEmpty() {
        return Parsers.EOF.map(__ -> FeelExpressions.Empty()).or(Terminals.fragment((Object[])new Object[]{"emptyfragment"}).map(__ -> FeelExpressions.Empty()));
    }

    private static <T> Parser<T> op(String name, T value) {
        return OPERATORS.token(name).retn(value);
    }

    private static Parser<FeelExpression> feelExpressionParser() {
        Parser.Reference feelParserReference = Parser.newReference();
        Parser literalParser = Parsers.or(INTEGER, DOUBLE, BOOLEAN, VARIABLE, STRING, DATE);
        Parser<FeelExpression> parseRangeExpression = FeelParser.createRangeExpressionParser((Parser<FeelExpression>)literalParser);
        Parser feelExpressionParserWithoutBinaryExpressions = Parsers.or((Parser)literalParser, NULL, FeelParser.parseNot((Parser<FeelExpression>)feelParserReference.lazy()), parseRangeExpression);
        Parser<FeelExpression> feelExpressionParser = FeelParser.createBinaryExpressionParser((Parser<FeelExpression>)feelExpressionParserWithoutBinaryExpressions);
        feelParserReference.set(feelExpressionParser);
        return Parsers.or(FeelParser.parseEmpty(), feelExpressionParser);
    }

    public static Either<ValidationResult.Builder.ElementStep, FeelExpression> parse(CharSequence charSequence) {
        try {
            return Eithers.right((FeelExpression)PARSER.parse(charSequence));
        }
        catch (ParserException e) {
            return Eithers.left(ValidationResult.init.message("Could not parse '" + charSequence + "': " + e.getMessage()));
        }
    }
}

