/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.core.SimpleValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.model.dmn.BuiltinAggregator;
import org.camunda.bpm.model.dmn.HitPolicy;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class AggregationValidator
extends SimpleValidator<DecisionTable> {
    public boolean isApplicable(DecisionTable decisionTable, ValidationContext validationContext) {
        return !HitPolicy.COLLECT.equals((Object)decisionTable.getHitPolicy());
    }

    public List<ValidationResult> validate(DecisionTable decisionTable, ValidationContext validationContext) {
        BuiltinAggregator builtinAggregator = decisionTable.getAggregation();
        if (Objects.nonNull(builtinAggregator)) {
            return Collections.singletonList(ValidationResult.init.message("Aggregations are only valid with HitPolicy " + HitPolicy.COLLECT).element((ModelElementInstance)decisionTable).build());
        }
        return Collections.emptyList();
    }

    public Class<DecisionTable> getClassUnderValidation() {
        return DecisionTable.class;
    }
}

