/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.core.SimpleValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class DuplicateColumnLabelValidator
extends SimpleValidator<DecisionTable> {
    public boolean isApplicable(DecisionTable decisionTable, ValidationContext validationContext) {
        return true;
    }

    public List<ValidationResult> validate(DecisionTable decisionTable, ValidationContext validationContext) {
        return Stream.concat(this.validateColumn(decisionTable, decisionTable.getInputs(), DmnElement::getLabel).stream(), this.validateColumn(decisionTable, decisionTable.getOutputs(), DmnElement::getLabel).stream()).collect(Collectors.toList());
    }

    private <T> List<ValidationResult> validateColumn(DecisionTable decisionTable, Collection<T> columns, Function<T, String> getLabel) {
        List labels = columns.stream().map(getLabel).collect(Collectors.toList());
        return labels.stream().filter(label -> Collections.frequency(labels, label) > 1).distinct().map(label -> ValidationResult.init.message("Column with label '" + label + "' is used more than once").severity(Severity.WARNING).element((ModelElementInstance)decisionTable).build()).collect(Collectors.toList());
    }

    public Class<DecisionTable> getClassUnderValidation() {
        return DecisionTable.class;
    }
}

