/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionTypeParser;
import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.TypeValidator;
import de.redsix.dmncheck.validators.core.ValidationContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.ItemDefinition;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ItemDefinitionAllowedValuesTypeValidator
extends TypeValidator<ItemDefinition> {
    public boolean isApplicable(ItemDefinition itemDefinition, ValidationContext validationContext) {
        return itemDefinition.getAllowedValues() != null || itemDefinition.getItemComponents().stream().anyMatch(itemComponent -> itemComponent.getAllowedValues() != null);
    }

    public List<ValidationResult> validate(ItemDefinition itemDefinition, ValidationContext validationContext) {
        Collection itemDefinitionsAndComponents = itemDefinition.getItemComponents().stream().filter(itemComponent -> itemComponent.getAllowedValues() != null).collect(Collectors.toList());
        if (itemDefinition.getAllowedValues() != null) {
            itemDefinitionsAndComponents.add(itemDefinition);
        }
        return itemDefinitionsAndComponents.stream().flatMap(itemDefinitionOrComponent -> {
            if (itemDefinitionOrComponent.getTypeRef() == null) {
                return Stream.of(ValidationResult.init.message("ItemDefintion uses AllowedValues without a type declaration").severity(Severity.WARNING).element((ModelElementInstance)itemDefinitionOrComponent).build());
            }
            String expressionType = itemDefinitionOrComponent.getTypeRef().getTextContent();
            return ExpressionTypeParser.parse(expressionType, validationContext.getItemDefinitions()).match(validationResult -> Stream.of(validationResult.element((ModelElementInstance)itemDefinitionOrComponent).build()), inputType -> this.typecheck((DmnElement)itemDefinitionOrComponent, Stream.of(itemDefinitionOrComponent.getAllowedValues()), Stream.of(inputType)));
        }).collect(Collectors.toList());
    }

    protected Class<ItemDefinition> getClassUnderValidation() {
        return ItemDefinition.class;
    }

    @Override
    public String errorMessage() {
        return "Type of item definition does not match type of allowed values";
    }
}

