/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators;

import de.redsix.dmncheck.feel.ExpressionType;
import de.redsix.dmncheck.feel.ExpressionTypes;
import de.redsix.dmncheck.feel.FeelParser;
import de.redsix.dmncheck.feel.FeelTypecheck;
import de.redsix.dmncheck.result.Severity;
import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.util.Either;
import de.redsix.dmncheck.util.Eithers;
import de.redsix.dmncheck.util.ProjectClassLoader;
import de.redsix.dmncheck.util.Util;
import de.redsix.dmncheck.validators.core.SimpleValidator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class TypeValidator<T extends ModelElementInstance>
extends SimpleValidator<T> {
    abstract String errorMessage();

    Stream<ValidationResult> typecheck(DmnElement dmnElement, Stream<? extends DmnElement> expressions, Stream<String> variables, Stream<ExpressionType> types) {
        Stream<Optional<ValidationResult.Builder.ElementStep>> intermediateResults = Util.zip(expressions, variables, types, (expression, variable, type) -> {
            FeelTypecheck.Context context = new FeelTypecheck.Context();
            context.put(variable, type);
            return this.typecheckExpression((DmnElement)expression, context, (ExpressionType)type);
        });
        return this.buildValidationResults(intermediateResults, dmnElement);
    }

    Stream<ValidationResult> typecheck(DmnElement dmnElement, Stream<? extends DmnElement> expressions, Stream<ExpressionType> types) {
        Stream<Optional<ValidationResult.Builder.ElementStep>> intermediateResults = Util.zip(expressions, types, (expression, type) -> {
            FeelTypecheck.Context emptyContext = new FeelTypecheck.Context();
            return this.typecheckExpression((DmnElement)expression, emptyContext, (ExpressionType)type);
        });
        return this.buildValidationResults(intermediateResults, dmnElement);
    }

    private Optional<ValidationResult.Builder.ElementStep> typecheckExpression(DmnElement dmnElement, FeelTypecheck.Context context, ExpressionType expectedType) {
        return FeelParser.parse(dmnElement.getTextContent()).bind(feelExpression -> FeelTypecheck.typecheck(context, feelExpression)).map(type -> {
            if (type.isSubtypeOf(ExpressionTypes.STRING()) && ExpressionTypes.getClassName(expectedType).isPresent()) {
                return this.checkEnumValue(ExpressionTypes.getClassName(expectedType).get(), dmnElement.getTextContent());
            }
            if (type.isSubtypeOf(expectedType) || ExpressionTypes.TOP().equals(type)) {
                return Optional.empty();
            }
            return Optional.of(ValidationResult.init.message(this.errorMessage()).severity(Severity.ERROR));
        }).match(Optional::of, Function.identity());
    }

    private Optional<ValidationResult.Builder.ElementStep> checkEnumValue(String className, String stringValue) {
        return this.loadEnum(className).bind(this::isEnum).bind(clazz -> this.doesStringBelongToEnum(className, stringValue, (Class<? extends Enum<?>>)clazz)).match(Optional::of, __ -> Optional.empty());
    }

    private Either<ValidationResult.Builder.ElementStep, Class<?>> doesStringBelongToEnum(String className, String stringValue, Class<? extends Enum<?>> clazz) {
        String value;
        Enum<?>[] enumConstants = clazz.getEnumConstants();
        List enumConstantNames = Arrays.stream(enumConstants == null ? new Enum[]{} : enumConstants).map(Enum::name).collect(Collectors.toList());
        if (enumConstantNames.contains(value = stringValue.substring(1, stringValue.length() - 1))) {
            return Eithers.right(clazz);
        }
        return Eithers.left(ValidationResult.init.message("Value " + stringValue + " does not belong to " + className));
    }

    private Either<ValidationResult.Builder.ElementStep, Class<?>> loadEnum(String className) {
        try {
            if (ProjectClassLoader.instance.classLoader != null) {
                return Eithers.right(ProjectClassLoader.instance.classLoader.loadClass(className));
            }
            return Eithers.left(ValidationResult.init.message("Classloader of project under validation not found"));
        }
        catch (ClassNotFoundException e) {
            return Eithers.left(ValidationResult.init.message("Class " + className + " not found on project classpath."));
        }
    }

    private Either<ValidationResult.Builder.ElementStep, Class<? extends Enum<?>>> isEnum(Class<?> clazz) {
        if (clazz.isEnum()) {
            return Eithers.right(clazz);
        }
        return Eithers.left(ValidationResult.init.message("Class " + clazz.getCanonicalName() + " is no enum."));
    }

    private Stream<ValidationResult> buildValidationResults(Stream<Optional<ValidationResult.Builder.ElementStep>> elementSteps, DmnElement dmnElement) {
        return elementSteps.filter(Optional::isPresent).map(Optional::get).map(validationResultBuilder -> validationResultBuilder.element((ModelElementInstance)dmnElement)).map(ValidationResult.Builder.BuildStep::build);
    }
}

