/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see </http:>//www.gnu.org/licenses/>.
 */
package de.richtercloud.execution.tools

/**
 * Wraps any unexpected exception during reading of process output and writing
 * to output stream in [OutputReaderThread].
 *
 * @author richter
 */
class OutputTransmissionException : RuntimeException {

    constructor(message: String) : super(message) {}

    constructor(message: String,
                cause: Throwable) : super(message,
            cause) {
    }

    constructor(cause: Throwable) : super(cause) {}

    companion object {
        private val serialVersionUID = 1L
    }
}
