/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package de.richtercloud.jhbuild.java.wrapper.download;

import java.awt.Window;
import org.apache.commons.lang3.StringUtils;
import de.richtercloud.jhbuild.java.wrapper.ExtractionMode;

/**
 *
 * @author richter
 */
public class DownloadDialog extends javax.swing.JDialog {
    private static final long serialVersionUID = 1L;
    private boolean canceled = false;

    /**
     * Creates new form MySQLDownloadDialog
     */
    public DownloadDialog(Window parent) {
        super(parent,
                ModalityType.APPLICATION_MODAL
        );
        initComponents();
    }

    public DownloadCombi getDownloadCombi() {
        String downloadURL = downloadURLTextField.getText();
        String downloadTarget = StringUtils.substringAfterLast(downloadURL, "/");
        ExtractionMode extractionMode;
        if(downloadURL.endsWith(".tar.gz")) {
            extractionMode = ExtractionMode.EXTRACTION_MODE_TAR_GZ;
        }else if(downloadURL.endsWith(".zip")) {
            extractionMode = ExtractionMode.EXTRACTION_MODE_ZIP;
        }else {
            extractionMode = ExtractionMode.EXTRACTION_MODE_NONE;
        }
        return new DownloadCombi(downloadURL, //downloadURL
                downloadTarget,
                extractionMode,
                extractionLocationTextField.getText(), //extractionLocation
                md5SumTextField.getText());
    }

    public boolean isCanceled() {
        return canceled;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        infoLabel = new javax.swing.JLabel();
        downloadURLTextField = new javax.swing.JTextField();
        downloadURLTextFieldLabel = new javax.swing.JLabel();
        extractionLocationTextField = new javax.swing.JTextField();
        extractionLocationTextFieldLabel = new javax.swing.JLabel();
        downloadButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        md5SumTextField = new javax.swing.JTextField();
        md5SumTextFieldLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        infoLabel.setText("Specify MySQL download and extraction location");

        downloadURLTextFieldLabel.setText("Download URL");

        extractionLocationTextFieldLabel.setText("Extraction location");

        downloadButton.setText("Download");
        downloadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                downloadButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        md5SumTextFieldLabel.setText("MD5 sum (optional)");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(infoLabel)
                        .addGap(0, 20, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(cancelButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(downloadButton))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(extractionLocationTextFieldLabel)
                            .addComponent(downloadURLTextFieldLabel)
                            .addComponent(md5SumTextFieldLabel))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(md5SumTextField, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(downloadURLTextField)
                            .addComponent(extractionLocationTextField))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(infoLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(downloadURLTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(downloadURLTextFieldLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(extractionLocationTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(extractionLocationTextFieldLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(md5SumTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(md5SumTextFieldLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(downloadButton)
                    .addComponent(cancelButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    @SuppressWarnings("PMD.UnusedFormalParameter")
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        this.canceled = true;
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    @SuppressWarnings("PMD.UnusedFormalParameter")
    private void downloadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downloadButtonActionPerformed
        this.canceled = false;
        setVisible(false);
    }//GEN-LAST:event_downloadButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton downloadButton;
    private javax.swing.JTextField downloadURLTextField;
    private javax.swing.JLabel downloadURLTextFieldLabel;
    private javax.swing.JTextField extractionLocationTextField;
    private javax.swing.JLabel extractionLocationTextFieldLabel;
    private javax.swing.JLabel infoLabel;
    private javax.swing.JTextField md5SumTextField;
    private javax.swing.JLabel md5SumTextFieldLabel;
    // End of variables declaration//GEN-END:variables
}
