/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.jhbuild.java.wrapper;

import de.richtercloud.jhbuild.java.wrapper.BinaryValidationException;
import java.io.File;

public final class BinaryUtils {
    public static void validateBinary(String binary, String name) throws BinaryValidationException {
        BinaryUtils.validateBinary(binary, name, System.getenv("PATH"));
    }

    public static void validateBinary(String binary, String name, String path) throws BinaryValidationException {
        String[] pathSplits;
        if (binary == null || binary.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s binary is null or empty", name));
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name mustn't be null or empty");
        }
        File binaryFile = new File(binary);
        if (binaryFile.exists()) {
            if (!binaryFile.isFile()) {
                throw new IllegalArgumentException(String.format("%s binary '%s' points to an existing location which is not a file", name, binary));
            }
            if (!binaryFile.canExecute()) {
                throw new IllegalArgumentException(String.format("%s binary '%s' points to an existing file can't be executed", name, binary));
            }
            return;
        }
        for (String pathSplit : pathSplits = path.split(File.pathSeparator)) {
            binaryFile = new File(pathSplit, binary);
            if (!binaryFile.exists() || !binaryFile.isFile() || !binaryFile.canExecute()) continue;
            return;
        }
        throw new BinaryValidationException(String.format("%s binary path '%s' points to an inexisting location or to a location which is not a file or can't be executed (directly or in path '%s')", name, binary, path));
    }

    private BinaryUtils() {
    }
}

