/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.jhbuild.java.wrapper.download;

import de.richtercloud.jhbuild.java.wrapper.ExtractionException;
import de.richtercloud.jhbuild.java.wrapper.ExtractionMode;
import de.richtercloud.jhbuild.java.wrapper.MD5SumCheckUnequalsCallback;
import de.richtercloud.jhbuild.java.wrapper.MD5SumCheckUnequalsCallbackReaction;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadCombi;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadEmptyCallback;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadEmptyCallbackReation;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadException;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadFailureCallback;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadFailureCallbackReation;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadUtils;
import de.richtercloud.jhbuild.java.wrapper.download.Downloader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoDownloader
implements Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoDownloader.class);

    @Override
    public boolean downloadFile(DownloadCombi downloadCombi, boolean skipMD5SumCheck, DownloadFailureCallback downloadFailureCallback, MD5SumCheckUnequalsCallback mD5SumCheckUnequalsCallback, DownloadEmptyCallback downloadEmptyCallback) throws IOException, ExtractionException, DownloadException, IllegalArgumentException {
        if (downloadCombi == null) {
            throw new IllegalArgumentException("downloadCombi mustn't be null");
        }
        if (downloadCombi.getDownloadURL() == null || downloadCombi.getDownloadTarget() == null || downloadCombi.getExtractionMode() == null || downloadCombi.getExtractionLocation() == null || downloadCombi.getMd5Sum() == null) {
            throw new IllegalArgumentException(String.format("downloadURL, downloadTarget, extractionMode, extractionLocation and md5sum of downloadCombi need to be not null (were %s, %s, %s, %s and %s", new Object[]{downloadCombi.getDownloadURL(), downloadCombi.getDownloadTarget(), downloadCombi.getExtractionMode(), downloadCombi.getExtractionLocation(), downloadCombi.getMd5Sum()}));
        }
        DownloadCombi downloadCombi0 = downloadCombi;
        boolean success = false;
        int numberOfRetries = 0;
        while (!success) {
            try {
                boolean notCanceled = this.download(downloadCombi0, skipMD5SumCheck, downloadFailureCallback, mD5SumCheckUnequalsCallback, downloadEmptyCallback);
                if (!notCanceled) {
                    return false;
                }
                success = true;
            }
            catch (ExtractionException | IOException ex) {
                downloadCombi0 = this.handleDownloadException(ex, downloadCombi0, numberOfRetries, downloadFailureCallback);
                if (downloadCombi0 == null) {
                    return false;
                }
                ++numberOfRetries;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean download(DownloadCombi downloadCombi, boolean skipMD5SumCheck, DownloadFailureCallback downloadFailureCallback, MD5SumCheckUnequalsCallback mD5SumCheckUnequalsCallback, DownloadEmptyCallback downloadEmptyCallback) throws IOException, ExtractionException, DownloadException {
        Object downloadTargetContent;
        boolean needDownload;
        assert (downloadCombi != null);
        assert (downloadCombi.getDownloadURL() != null);
        assert (downloadCombi.getDownloadTarget() != null);
        assert (downloadCombi.getExtractionMode() != null);
        assert (downloadCombi.getExtractionLocation() != null);
        assert (downloadCombi.getMd5Sum() != null);
        if (skipMD5SumCheck) {
            needDownload = !new File(downloadCombi.getDownloadTarget()).exists();
        } else {
            needDownload = true;
            if (!downloadCombi.getMd5Sum().isEmpty() && new File(downloadCombi.getDownloadTarget()).exists()) {
                LOGGER.debug(String.format("reading download file '%s' for MD5 sum calculation", downloadCombi.getDownloadTarget()));
                String md5 = DigestUtils.md5Hex((InputStream)new BufferedInputStream(Files.newInputStream(Paths.get(downloadCombi.getDownloadTarget(), new String[0]), new OpenOption[0])));
                if (downloadCombi.getMd5Sum().equals(md5)) {
                    LOGGER.debug(String.format("MD5 sum %s of download file '%s' matches", downloadCombi.getMd5Sum(), downloadCombi.getDownloadTarget()));
                    needDownload = false;
                } else {
                    LOGGER.debug(String.format("MD5 sum %s of download file '%s' doesn't match (should be %s), requesting new download", md5, downloadCombi.getDownloadTarget(), downloadCombi.getMd5Sum()));
                }
            }
        }
        if (this.isCanceled()) {
            LOGGER.debug(String.format("canceling download of %s because the downloader has been canceled", downloadCombi.getDownloadURL()));
            return false;
        }
        LOGGER.debug(String.format("needDownload: %s", String.valueOf(needDownload)));
        if (needDownload) {
            boolean success = false;
            int numberOfRetriesMD5Sum = 0;
            int numberOfRetriesEmpty = 0;
            while (!success) {
                URL downloadURLURL = new URL(downloadCombi.getDownloadURL());
                try (OutputStream out = Files.newOutputStream(Paths.get(downloadCombi.getDownloadTarget(), new String[0]), new OpenOption[0]);
                     InputStream downloadURLInputStream = downloadURLURL.openStream();){
                    LOGGER.debug(String.format("downloading from URL '%s' into file '%s'", downloadCombi.getDownloadURL(), downloadCombi.getDownloadTarget()));
                    IOUtils.copy((InputStream)downloadURLInputStream, (OutputStream)out);
                }
                if (this.isCanceled()) {
                    LOGGER.debug(String.format("canceling download of %s because the downloader has been canceled", downloadCombi.getDownloadURL()));
                    return false;
                }
                downloadTargetContent = IOUtils.toString((InputStream)Files.newInputStream(Paths.get(downloadCombi.getDownloadTarget(), new String[0]), new OpenOption[0]), (Charset)Charsets.UTF_8);
                if (((String)downloadTargetContent).isEmpty()) {
                    DownloadEmptyCallbackReation reaction = downloadEmptyCallback.run(numberOfRetriesEmpty);
                    if (reaction == DownloadEmptyCallbackReation.CANCEL) {
                        LOGGER.debug(String.format("canceling download of %s because the downloader has been canceled based on predefined decision for empty download", downloadCombi.getDownloadURL()));
                        return false;
                    }
                    ++numberOfRetriesEmpty;
                    continue;
                }
                if (downloadCombi.getMd5Sum().isEmpty()) {
                    success = true;
                } else {
                    LOGGER.debug(String.format("calculating MD5 checksum for download target file '%s'", downloadCombi.getDownloadTarget()));
                    String md5 = DigestUtils.md5Hex((InputStream)new BufferedInputStream(Files.newInputStream(Paths.get(downloadCombi.getDownloadTarget(), new String[0]), new OpenOption[0])));
                    if (downloadCombi.getMd5Sum().equals(md5)) {
                        success = true;
                    } else {
                        MD5SumCheckUnequalsCallbackReaction reaction = mD5SumCheckUnequalsCallback.run(downloadCombi.getMd5Sum(), md5, numberOfRetriesMD5Sum);
                        if (reaction == MD5SumCheckUnequalsCallbackReaction.CANCEL) {
                            LOGGER.debug(String.format("canceling download of %s because the downloader has been canceled based on predefined decision for md5 checksum mismatch", downloadCombi.getDownloadURL()));
                            return false;
                        }
                    }
                }
                ++numberOfRetriesMD5Sum;
            }
        }
        if (this.isCanceled()) {
            LOGGER.debug(String.format("canceling download of %s because the downloader has been canceled", downloadCombi.getDownloadURL()));
            return false;
        }
        if (downloadCombi.getExtractionMode() == ExtractionMode.EXTRACTION_MODE_NONE) {
            LOGGER.debug(String.format("nothing to do for extraction mode '%s', returning successfully", ExtractionMode.EXTRACTION_MODE_NONE.getLabel()));
            return true;
        }
        File extractionDir = new File(downloadCombi.getExtractionLocation());
        if (extractionDir.exists() && !extractionDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("extraction directory '%s' is an existing path which doesn't point to a directory", extractionDir.getAbsolutePath()));
        }
        if (!extractionDir.exists() || extractionDir.exists() && extractionDir.list().length == 0) {
            InputStream fileInputStream = Files.newInputStream(Paths.get(downloadCombi.getDownloadTarget(), new String[0]), new OpenOption[0]);
            if (null == downloadCombi.getExtractionMode()) {
                throw new IllegalArgumentException(String.format("extractionMode mustn't be null", downloadCombi.getExtractionMode().getLabel()));
            }
            if (downloadCombi.getExtractionMode() == ExtractionMode.EXTRACTION_MODE_TAR_GZ || downloadCombi.getExtractionMode() == ExtractionMode.EXTRACTION_MODE_TAR_XZ) {
                GZIPInputStream compressedInputStream = downloadCombi.getExtractionMode() == ExtractionMode.EXTRACTION_MODE_TAR_GZ ? new GZIPInputStream(fileInputStream) : new XZCompressorInputStream(fileInputStream);
                TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)compressedInputStream);
                downloadTargetContent = null;
                try {
                    TarArchiveEntry entry;
                    String extractionDirTar = extractionDir.getParent();
                    LOGGER.debug(String.format("extracting .tar.gz archive into '%s'", extractionDirTar));
                    while ((entry = (TarArchiveEntry)tarArchiveInputStream.getNextEntry()) != null) {
                        File outputFile = new File(extractionDirTar, entry.getName());
                        if (entry.isDirectory()) {
                            LOGGER.trace(String.format("Attempting to write output directory %s.", outputFile.getAbsolutePath()));
                            if (!outputFile.exists()) {
                                LOGGER.trace(String.format("Attempting to create output directory %s.", outputFile.getAbsolutePath()));
                                Files.createDirectories(outputFile.toPath(), new FileAttribute[0]);
                            }
                        } else {
                            LOGGER.trace(String.format("Creating output file %s.", outputFile.getAbsolutePath()));
                            File outputFileParent = outputFile.getParentFile();
                            if (!outputFileParent.exists()) {
                                Files.createDirectories(outputFileParent.toPath(), new FileAttribute[0]);
                            }
                            try (OutputStream outputFileStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
                                IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)outputFileStream);
                            }
                        }
                        int modeOctal = Integer.parseInt(Integer.toOctalString(entry.getMode()));
                        Path outputFilePath = Paths.get(outputFile.getAbsolutePath(), new String[0]);
                        StringBuilder permStringBuilder = new StringBuilder(9);
                        int modeUser = modeOctal / 100;
                        int modeGroup = modeOctal % 100 / 10;
                        int modeOthers = modeOctal % 10;
                        permStringBuilder.append((modeUser & 4) == 0 ? (char)'-' : 'r').append((modeUser & 2) == 0 ? (char)'-' : 'w').append((modeUser & 1) == 0 ? (char)'-' : 'x').append((modeGroup & 4) == 0 ? (char)'-' : 'r').append((modeGroup & 2) == 0 ? (char)'-' : 'w').append((modeGroup & 1) == 0 ? (char)'-' : 'x').append((modeOthers & 4) == 0 ? (char)'-' : 'r').append((modeOthers & 2) == 0 ? (char)'-' : 'w').append((modeOthers & 1) == 0 ? (char)'-' : 'x');
                        String permString = permStringBuilder.toString();
                        Files.setPosixFilePermissions(outputFilePath, PosixFilePermissions.fromString(permString));
                        Files.setLastModifiedTime(outputFile.toPath(), FileTime.fromMillis(entry.getLastModifiedDate().getTime()));
                        LOGGER.trace(String.format("last modified time of file or directory '%s' is %s", outputFile.getAbsolutePath(), Files.getLastModifiedTime(outputFilePath, new LinkOption[0])));
                    }
                    return true;
                }
                catch (Throwable extractionDirTar) {
                    downloadTargetContent = extractionDirTar;
                    throw extractionDirTar;
                }
                finally {
                    if (tarArchiveInputStream != null) {
                        if (downloadTargetContent != null) {
                            try {
                                tarArchiveInputStream.close();
                            }
                            catch (Throwable extractionDirTar) {
                                ((Throwable)downloadTargetContent).addSuppressed(extractionDirTar);
                            }
                        } else {
                            tarArchiveInputStream.close();
                        }
                    }
                }
            }
            if (downloadCombi.getExtractionMode() != ExtractionMode.EXTRACTION_MODE_ZIP) throw new IllegalArgumentException(String.format("extractionMode %s isn't supported", downloadCombi.getExtractionMode().getLabel()));
            Files.createDirectories(extractionDir.toPath(), new FileAttribute[0]);
            LOGGER.debug(String.format("extracting .zip archive into '%s'", extractionDir));
            try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(Paths.get(downloadCombi.getDownloadTarget(), new String[0]), new OpenOption[0]));){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    String filePath = extractionDir.getParent() + File.separator + entry.getName();
                    File fileParent = new File(filePath).getParentFile();
                    if (!fileParent.exists()) {
                        Files.createDirectories(fileParent.toPath(), new FileAttribute[0]);
                    }
                    if (!entry.isDirectory()) {
                        DownloadUtils.extractFile(zipIn, filePath);
                    } else {
                        File dir = new File(filePath);
                        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                    }
                    Files.setLastModifiedTime(Paths.get(filePath, new String[0]), entry.getLastModifiedTime());
                    LOGGER.trace(String.format("last modified time of file or directory '%s' is %s", filePath, Files.getLastModifiedTime(Paths.get(filePath, new String[0]), new LinkOption[0])));
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
                return true;
            }
        }
        if (extractionDir.isDirectory()) return true;
        throw new ExtractionException(extractionDir);
    }

    protected boolean isCanceled() {
        return false;
    }

    protected DownloadCombi handleDownloadException(Exception ex, DownloadCombi previousDownloadCombi, int numberOfRetries, DownloadFailureCallback downloadFailureCallback) {
        if (downloadFailureCallback.run(ex, numberOfRetries) == DownloadFailureCallbackReation.CANCEL) {
            return null;
        }
        return previousDownloadCombi;
    }
}

