/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.jhbuild.java.wrapper.download;

import de.richtercloud.jhbuild.java.wrapper.ArchitectureNotRecognizedException;
import de.richtercloud.jhbuild.java.wrapper.OSNotRecognizedException;
import de.richtercloud.jhbuild.java.wrapper.SupportedOS;
import de.richtercloud.jhbuild.java.wrapper.WindowsBitness;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DownloadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadUtils.class);
    public static final String MD5_SUM_CHECK_FAILED_RETRY = "Retry download";
    public static final String MD5_SUM_CHECK_FAILED_ABORT = "Abort download";

    public static WindowsBitness getWindowsBitness() {
        assert (SystemUtils.IS_OS_WINDOWS);
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        return arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? WindowsBitness.WINDOWS_BITNESS_64 : WindowsBitness.WINDOWS_BITNESS_32;
    }

    public static SupportedOS getCurrentOS() throws OSNotRecognizedException, ArchitectureNotRecognizedException {
        LOGGER.debug(String.format("system properties os.name is '%s' and os.arch is '%s'", System.getProperty("os.name"), System.getProperty("os.arch")));
        if (SystemUtils.IS_OS_LINUX) {
            if ("amd64".equals(SystemUtils.OS_ARCH)) {
                LOGGER.debug("assuming Linux 64-bit");
                return SupportedOS.LINUX_64;
            }
            if ("i386".equals(SystemUtils.OS_ARCH)) {
                LOGGER.debug("assuming Linux 32-bit");
                return SupportedOS.LINUX_32;
            }
            throw new ArchitectureNotRecognizedException("Linux");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            if (DownloadUtils.getWindowsBitness() == WindowsBitness.WINDOWS_BITNESS_64) {
                LOGGER.debug("assuming Windows 64-bit");
                return SupportedOS.WINDOWS_64;
            }
            if (DownloadUtils.getWindowsBitness() == WindowsBitness.WINDOWS_BITNESS_32) {
                LOGGER.debug("assuming Windows 32-bit");
                return SupportedOS.WINDOWS_32;
            }
            throw new ArchitectureNotRecognizedException("Windows");
        }
        if (SystemUtils.IS_OS_MAC) {
            if ("x84_86".equals(SystemUtils.OS_ARCH)) {
                LOGGER.debug("assuming Mac OSX 64-bit");
                return SupportedOS.MAC_OSX_64;
            }
            throw new ArchitectureNotRecognizedException("Mac OSX");
        }
        throw new OSNotRecognizedException();
    }

    public static void extractFile(ZipInputStream zipInputStream, String filePath) throws IOException {
        if (zipInputStream == null) {
            throw new IllegalArgumentException("zipInputStream mustn't be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("filePath mustn't be null");
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)bos);
            bos.flush();
        }
    }

    private DownloadUtils() {
    }
}

