/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.jhbuild.java.wrapper.download;

import de.richtercloud.jhbuild.java.wrapper.ExtractionException;
import de.richtercloud.jhbuild.java.wrapper.MD5SumCheckUnequalsCallback;
import de.richtercloud.jhbuild.java.wrapper.download.AutoDownloader;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadCombi;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadDialog;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadEmptyCallback;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadException;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadFailureCallback;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadFailureCallbackReation;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import richtercloud.swing.worker.get.wait.dialog.SwingWorkerGetWaitDialog;

public class GUIDownloader
extends AutoDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GUIDownloader.class);
    private final Window downloadDialogParent;
    private final String downloadDialogTitle;
    private final String downloadDialogLabelText;
    private final String downloadDialogProgressBarText;
    private SwingWorkerGetWaitDialog dialog;

    public GUIDownloader(Window downloadDialogParent, String downloadDialogTitle, String downloadDialogLabelText, String downloadDialogProgressBarText) {
        this.downloadDialogParent = downloadDialogParent;
        this.downloadDialogTitle = downloadDialogTitle;
        this.downloadDialogLabelText = downloadDialogLabelText;
        this.downloadDialogProgressBarText = downloadDialogProgressBarText;
    }

    @Override
    protected boolean download(final DownloadCombi downloadCombi, final boolean skipMD5SumCheck, final DownloadFailureCallback downloadFailureCallback, final MD5SumCheckUnequalsCallback mD5SumCheckUnequalsCallback, final DownloadEmptyCallback downloadEmptyCallback) throws IOException, ExtractionException, DownloadException {
        this.dialog = new SwingWorkerGetWaitDialog(this.downloadDialogParent, this.downloadDialogTitle, this.downloadDialogLabelText, this.downloadDialogProgressBarText);
        SwingWorker<Boolean, Void> downloadWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws FileNotFoundException, IOException, ExtractionException, DownloadException {
                boolean retValue = GUIDownloader.super.download(downloadCombi, skipMD5SumCheck, downloadFailureCallback, mD5SumCheckUnequalsCallback, downloadEmptyCallback);
                return retValue;
            }

            @Override
            protected void done() {
                GUIDownloader.this.dialog.setVisible(false);
            }
        };
        downloadWorker.execute();
        this.dialog.setVisible(true);
        if (this.dialog.isCanceled()) {
            return false;
        }
        try {
            return (Boolean)downloadWorker.get();
        }
        catch (InterruptedException ex) {
            LOGGER.error("unexpected interrupted exception occured", (Throwable)ex);
            throw new DownloadException(ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            if (ex.getCause() instanceof ExtractionException) {
                throw (ExtractionException)ex.getCause();
            }
            LOGGER.error("unexpected interrupted exception occured", (Throwable)ex);
            throw new DownloadException(ex);
        }
    }

    @Override
    protected boolean isCanceled() {
        return this.dialog != null && this.dialog.isCanceled();
    }

    @Override
    protected DownloadCombi handleDownloadException(Exception ex, DownloadCombi previousDownloadCombi, int numberOfRetries, DownloadFailureCallback downloadFailureCallback) {
        DownloadFailureCallbackReation reaction = downloadFailureCallback.run(ex, numberOfRetries);
        if (reaction == DownloadFailureCallbackReation.CANCEL) {
            return null;
        }
        DownloadDialog downloadDialog = new DownloadDialog(this.downloadDialogParent);
        downloadDialog.setLocationRelativeTo(this.downloadDialogParent);
        downloadDialog.setVisible(true);
        if (downloadDialog.isCanceled()) {
            return null;
        }
        return downloadDialog.getDownloadCombi();
    }
}

