/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.jhbuild.java.wrapper;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import de.richtercloud.execution.tools.BinaryUtils;
import de.richtercloud.execution.tools.BinaryValidationException;
import de.richtercloud.execution.tools.ExecutionUtils;
import de.richtercloud.execution.tools.OutputReaderThread;
import de.richtercloud.execution.tools.OutputReaderThreadMode;
import de.richtercloud.jhbuild.java.wrapper.ActionOnMissingBinary;
import de.richtercloud.jhbuild.java.wrapper.BuildFailureException;
import de.richtercloud.jhbuild.java.wrapper.BuildStep;
import de.richtercloud.jhbuild.java.wrapper.ExtractionException;
import de.richtercloud.jhbuild.java.wrapper.ExtractionMode;
import de.richtercloud.jhbuild.java.wrapper.MD5SumCheckUnequalsCallback;
import de.richtercloud.jhbuild.java.wrapper.MissingSystemBinaryException;
import de.richtercloud.jhbuild.java.wrapper.ModuleBuildFailureException;
import de.richtercloud.jhbuild.java.wrapper.OutputMode;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadCombi;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadEmptyCallback;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadException;
import de.richtercloud.jhbuild.java.wrapper.download.DownloadFailureCallback;
import de.richtercloud.jhbuild.java.wrapper.download.Downloader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JHBuildJavaWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JHBuildJavaWrapper.class);
    public static final String GIT_DEFAULT = "git";
    public static final String JHBUILD_DEFAULT = "jhbuild";
    public static final String SH_DEFAULT = "bash";
    public static final String MAKE_DEFAULT = "make";
    public static final String PYTHON_DEFAULT = "python";
    public static final String CC_DEFAULT = "gcc";
    public static final String MSGFMT_DEFAULT = "msgfmt";
    public static final String CPAN_DEFAULT = "cpan";
    public static final String PATCH_DEFAULT = "patch";
    public static final String OPENSSL_DEFAULT = "openssl";
    public static final File CONFIG_DIR = new File(SystemUtils.getUserHome(), ".jhbuild-java-wrapper");
    public static final File INSTALLATION_PREFIX_DIR_DEFAULT = new File(CONFIG_DIR, "installation-prefix");
    public static final File DOWNLOAD_DIR_DEFAULT = new File(CONFIG_DIR, "downloads");
    private static final String PATH = "PATH";
    private static final String CONFIGURE = "configure";
    private static final String GIT_TEMPLATE = "git";
    private static final String JHBUILD_TEMPLATE = "jhbuild";
    private static final String JHBUILD_TEMPLATE_2 = "jhbuild ";
    private static final String PYTHON_TEMPLATE = "python";
    private static final String CPAN_TEMPLATE = "cpan";
    private static final String OPENSSL_TEMPLATE = "openssl";
    private static final String REDIRECTED_TEMPLATE = "[redirected]";
    private static final String ACTION_TEMPLATE = "action %s not supported";
    private static final String OUTPUT_MODE_TEMPLATE = "output mode %s not supported";
    private static final File JHBUILD_FILE_LOCK_FILE = new File(CONFIG_DIR, "lock");
    private static final Lock JHBUILD_THREAD_LOCK = new ReentrantLock();
    private String git;
    private String msgfmt;
    private String cpan;
    private String patch;
    private String openssl;
    private String jhbuild;
    private final String sh;
    private final String make;
    private String python;
    private final String cc;
    private final ActionOnMissingBinary actionOnMissingGit;
    private final ActionOnMissingBinary actionOnMissingZlib;
    private final ActionOnMissingBinary actionOnMissingJHBuild;
    private final ActionOnMissingBinary actionOnMissingPython;
    private final ActionOnMissingBinary actionOnMissingMsgfmt;
    private final ActionOnMissingBinary actionOnMissingCpan;
    private final ActionOnMissingBinary actionOnMissingOpenssl;
    private final boolean skipMD5SumCheck;
    private final File installationPrefixDir;
    private final File downloadDir;
    private boolean inited;
    private final OutputStream stdoutOutputStream;
    private final OutputStream stderrOutputStream;
    private boolean canceled;
    private Process activeProcess;
    private final Map<Process, Pair<OutputReaderThread, OutputReaderThread>> processOutputReaderThreadMap = new HashMap<Process, Pair<OutputReaderThread, OutputReaderThread>>();
    private final Downloader downloader;
    private final int parallelism;
    private final Map<Process, Pair<ByteArrayOutputStream, ByteArrayOutputStream>> processErrorStreamMap = new HashMap<Process, Pair<ByteArrayOutputStream, ByteArrayOutputStream>>();
    private final OutputMode outputMode;
    private final int outputLimit;
    private boolean exitOnError;

    public static int calculateParallelism() {
        return Runtime.getRuntime().availableProcessors();
    }

    public JHBuildJavaWrapper(ActionOnMissingBinary actionOnMissingGit, ActionOnMissingBinary actionOnMissingZlib, ActionOnMissingBinary actionOnMissingJHBuild, ActionOnMissingBinary actionOnMissingPython, ActionOnMissingBinary actionOnMissingMsgfmt, ActionOnMissingBinary actionOnMissingCpan, ActionOnMissingBinary actionOnMissingOpenssl, Downloader downloader, boolean skipMD5SumCheck, OutputStream stdoutOutputStream, OutputStream stderrOutputStream, OutputMode outputMode, int outputLimit, boolean exitOnError) throws IOException {
        this(INSTALLATION_PREFIX_DIR_DEFAULT, DOWNLOAD_DIR_DEFAULT, actionOnMissingGit, actionOnMissingZlib, actionOnMissingJHBuild, actionOnMissingPython, actionOnMissingMsgfmt, actionOnMissingCpan, actionOnMissingOpenssl, downloader, skipMD5SumCheck, stdoutOutputStream, stderrOutputStream, outputMode, outputLimit, exitOnError);
    }

    public JHBuildJavaWrapper(File installationPrefixDir, File downloadDir, ActionOnMissingBinary actionOnMissingGit, ActionOnMissingBinary actionOnMissingZlib, ActionOnMissingBinary actionOnMissingJHBuild, ActionOnMissingBinary actionOnMissingPython, ActionOnMissingBinary actionOnMissingMsgfmt, ActionOnMissingBinary actionOnMissingCpan, ActionOnMissingBinary actionOnMissingOpenssl, Downloader downloader, boolean skipMD5SumCheck, OutputStream stdoutOutputStream, OutputStream stderrOutputStream, OutputMode outputMode, int outputLimit, boolean exitOnError) throws IOException {
        this(installationPrefixDir, downloadDir, "git", "jhbuild", SH_DEFAULT, MAKE_DEFAULT, "python", CC_DEFAULT, MSGFMT_DEFAULT, "cpan", PATCH_DEFAULT, "openssl", downloader, skipMD5SumCheck, stdoutOutputStream, stderrOutputStream, outputMode, outputLimit, exitOnError, actionOnMissingGit, actionOnMissingZlib, actionOnMissingJHBuild, actionOnMissingPython, actionOnMissingMsgfmt, actionOnMissingCpan, actionOnMissingOpenssl, JHBuildJavaWrapper.calculateParallelism());
    }

    public JHBuildJavaWrapper(File installationPrefixDir, File downloadDir, String git, String jhbuild, String sh, String make, String python, String cc, String msgfmt, String cpan, String patch, String openssl, Downloader downloader, boolean skipMD5SumCheck, OutputStream stdoutOutputStream, OutputStream stderrOutputStream, OutputMode outputMode, int outputLimit, boolean exitOnError, ActionOnMissingBinary actionOnMissingGit, ActionOnMissingBinary actionOnMissingZlib, ActionOnMissingBinary actionOnMissingJHBuild, ActionOnMissingBinary actionOnMissingPython, ActionOnMissingBinary actionOnMissingMsgfmt, ActionOnMissingBinary actionOnMissingCpan, ActionOnMissingBinary actionOnMissingOpenssl, int parallelism) throws IOException {
        if (installationPrefixDir.exists() && !installationPrefixDir.isDirectory()) {
            throw new IllegalArgumentException("installationPrefixDir points to an existing location and is not a directory");
        }
        this.installationPrefixDir = installationPrefixDir;
        if (!installationPrefixDir.exists()) {
            FileUtils.forceMkdir((File)installationPrefixDir);
        }
        this.downloadDir = downloadDir;
        if (!downloadDir.exists()) {
            FileUtils.forceMkdir((File)downloadDir);
        }
        this.git = git;
        this.jhbuild = jhbuild;
        this.sh = sh;
        this.make = make;
        this.python = python;
        this.cc = cc;
        this.msgfmt = msgfmt;
        this.cpan = cpan;
        this.patch = patch;
        this.openssl = openssl;
        if (downloader == null) {
            throw new IllegalArgumentException("downloader mustn't be null");
        }
        this.downloader = downloader;
        this.actionOnMissingGit = actionOnMissingGit;
        this.actionOnMissingZlib = actionOnMissingZlib;
        this.actionOnMissingJHBuild = actionOnMissingJHBuild;
        this.actionOnMissingPython = actionOnMissingPython;
        this.actionOnMissingMsgfmt = actionOnMissingMsgfmt;
        this.actionOnMissingCpan = actionOnMissingCpan;
        this.actionOnMissingOpenssl = actionOnMissingOpenssl;
        this.skipMD5SumCheck = skipMD5SumCheck;
        this.stdoutOutputStream = stdoutOutputStream;
        this.stderrOutputStream = stderrOutputStream;
        this.outputMode = outputMode;
        this.outputLimit = outputLimit;
        this.exitOnError = exitOnError;
        if (parallelism < 1) {
            throw new IllegalArgumentException(String.format("parallelism value of less than 1 doesn't make sense (was %d)", parallelism));
        }
        this.parallelism = parallelism;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public File getInstallationPrefixDir() {
        return this.installationPrefixDir;
    }

    private Process createProcess(String path, String ... commands) throws IOException {
        return this.createProcess((File)null, path, commands);
    }

    private Process createProcess(File directory, String path, String ... commands) throws IOException {
        return this.createProcess(directory, (Map<String, String>)ImmutableMap.builder().put((Object)PATH, (Object)path).build(), commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process createProcess(File directory, Map<String, String> env, String ... commands) throws IOException {
        ByteArrayOutputStream stderrErrorStream0;
        LOGGER.debug(String.format("building process with commands '%s' ('%s') with environment '%s' running in %s", Arrays.toString(commands), String.join((CharSequence)" ", commands), env, directory != null ? String.format("directory '%s'", directory.getAbsolutePath()) : "current directory"));
        ByteArrayOutputStream stdoutErrorStream = new ByteArrayOutputStream();
        ByteArrayOutputStream stderrErrorStream = new ByteArrayOutputStream();
        if (this.outputMode == OutputMode.JOIN_STDOUT_STDERR) {
            stderrErrorStream0 = stdoutErrorStream;
        } else if (this.outputMode == OutputMode.SPLIT_STDOUT_STDERR) {
            stderrErrorStream0 = stderrErrorStream;
        } else {
            throw new IllegalArgumentException(String.format(OUTPUT_MODE_TEMPLATE, new Object[]{this.outputMode}));
        }
        Triple process = ExecutionUtils.createProcess((File)directory, env, (String)this.sh, new LinkedList<OutputStream>(Arrays.asList(this.stdoutOutputStream, stdoutErrorStream)), new LinkedList<OutputStream>(Arrays.asList(this.stderrOutputStream, stderrErrorStream0)), (OutputReaderThreadMode)OutputReaderThreadMode.OUTPUT_STREAM, (String[])commands);
        this.processErrorStreamMap.put((Process)process.getLeft(), (Pair<ByteArrayOutputStream, ByteArrayOutputStream>)new ImmutablePair((Object)stdoutErrorStream, (Object)stderrErrorStream0));
        this.processOutputReaderThreadMap.put((Process)process.getLeft(), (Pair<OutputReaderThread, OutputReaderThread>)new ImmutablePair(process.getMiddle(), process.getRight()));
        JHBuildJavaWrapper jHBuildJavaWrapper = this;
        synchronized (jHBuildJavaWrapper) {
            this.activeProcess = (Process)process.getLeft();
        }
        return (Process)process.getLeft();
    }

    private boolean init(String installationPrefixPath) throws IOException, ExtractionException, InterruptedException, MissingSystemBinaryException, BuildFailureException, DownloadException {
        if (this.inited) {
            LOGGER.debug("already inited");
            return true;
        }
        assert (this.downloadDir.exists() && this.downloadDir.isDirectory());
        LOGGER.trace(String.format("silenceStdout: %s", this.stdoutOutputStream));
        LOGGER.trace(String.format("silenceStderr: %s", this.stderrOutputStream));
        try {
            BinaryUtils.validateBinary((String)this.cc, (String)"cc", (String)installationPrefixPath);
        }
        catch (BinaryValidationException gccBinaryValidationException) {
            throw new MissingSystemBinaryException("cc", (Exception)((Object)gccBinaryValidationException));
        }
        try {
            BinaryUtils.validateBinary((String)this.cpan, (String)"cpan", (String)installationPrefixPath);
        }
        catch (BinaryValidationException ex) {
            switch (this.actionOnMissingCpan) {
                case FAIL: {
                    throw new IllegalStateException(String.format("cpan binary '%s' doesn't exist and can't be found in PATH", this.cpan), ex);
                }
                case DOWNLOAD: {
                    DownloadCombi perlDownloadCombi = new DownloadCombi("http://www.cpan.org/src/5.0/perl-5.26.1.tar.gz", new File(this.downloadDir, "perl-5.26.1.tar.gz").getAbsolutePath(), ExtractionMode.EXTRACTION_MODE_TAR_GZ, new File(this.downloadDir, "perl-5.26.1").getAbsolutePath(), "a7e5c531ee1719c53ec086656582ea86");
                    List<BuildStepProcess> buildStepProcesses = this.generateBuildStepProcessesAutotools(installationPrefixPath, this.parallelism, "configure.gnu", new String[0]);
                    this.cpan = this.installPrerequisiteAutotools(installationPrefixPath, "cpan", "cpan", perlDownloadCombi, null, buildStepProcesses);
                    if (this.cpan == null) {
                        return false;
                    }
                    try {
                        BinaryUtils.validateBinary((String)this.cpan, (String)"cpan", (String)installationPrefixPath);
                        break;
                    }
                    catch (BinaryValidationException ex2) {
                        throw new IllegalStateException("cpan exisistence check or installation failed when cpan installation is expected to have been successful", ex2);
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format(ACTION_TEMPLATE, new Object[]{this.actionOnMissingCpan}), ex);
                }
            }
        }
        try {
            BinaryUtils.validateBinary((String)this.msgfmt, (String)"gettext", (String)installationPrefixPath);
        }
        catch (BinaryValidationException ex) {
            switch (this.actionOnMissingMsgfmt) {
                case FAIL: {
                    throw new IllegalStateException(String.format("msgfmt binary '%s' doesn't exist and can't be found in PATH", this.msgfmt), ex);
                }
                case DOWNLOAD: {
                    DownloadCombi gettextDownloadCombi = new DownloadCombi("https://ftp.gnu.org/pub/gnu/gettext/gettext-0.19.8.1.tar.xz", new File(this.downloadDir, "gettext-0.19.8.1.tar.gz").getAbsolutePath(), ExtractionMode.EXTRACTION_MODE_TAR_XZ, new File(this.downloadDir, "gettext-0.19.8.1").getAbsolutePath(), "df3f5690eaa30fd228537b00cb7b7590");
                    DownloadCombi gettextPatchDownloadCombi = new DownloadCombi(JHBuildJavaWrapper.class.getResource("/patches/gettext/texi2html.patch").toExternalForm(), "texi2html.patch", ExtractionMode.EXTRACTION_MODE_NONE, "texi2html.patch", "77c7ac38a7cacab88753da0f0d8936fb");
                    this.msgfmt = this.installPrerequisiteAutotools(installationPrefixPath, MSGFMT_DEFAULT, "gettext", gettextDownloadCombi, new LinkedList<DownloadCombi>(Arrays.asList(gettextPatchDownloadCombi)), this.parallelism);
                    if (this.msgfmt == null) {
                        return false;
                    }
                    try {
                        BinaryUtils.validateBinary((String)this.msgfmt, (String)MSGFMT_DEFAULT, (String)installationPrefixPath);
                        break;
                    }
                    catch (BinaryValidationException ex1) {
                        throw new IllegalArgumentException("msgfmt exisistence check or installation failed when gettext installation is expected to have been successful", ex1);
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format(ACTION_TEMPLATE, new Object[]{this.actionOnMissingMsgfmt}), ex);
                }
            }
        }
        boolean zlibPresent = this.checkLibPresence(this.installationPrefixDir, "zlib.pc");
        if (zlibPresent) {
            LOGGER.debug("using existing version of zlib in installation prefix");
        } else {
            switch (this.actionOnMissingZlib) {
                case FAIL: {
                    throw new IllegalStateException("library zlib doesn't exist in installation prefix");
                }
                case DOWNLOAD: {
                    DownloadCombi zlibDownloadCombi = new DownloadCombi("https://www.zlib.net/zlib-1.2.11.tar.gz", new File(this.downloadDir, "zlib-1.2.11.tar.gz").getAbsolutePath(), ExtractionMode.EXTRACTION_MODE_TAR_GZ, new File(this.downloadDir, "zlib-1.2.11").getAbsolutePath(), "1c9f62f0778697a09d36121ead88e08e");
                    String zlib = this.installPrerequisiteAutotools(installationPrefixPath, "", "zlib", zlibDownloadCombi, null, this.parallelism);
                    if (zlib == null) {
                        return false;
                    }
                    assert ("".equals(zlib));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(ACTION_TEMPLATE, new Object[]{this.actionOnMissingZlib}));
                }
            }
        }
        try {
            BinaryUtils.validateBinary((String)this.git, (String)"git", (String)installationPrefixPath);
        }
        catch (BinaryValidationException ex) {
            switch (this.actionOnMissingGit) {
                case FAIL: {
                    throw new IllegalStateException(String.format("git binary '%s' doesn't exist and can't be found in PATH", this.git), ex);
                }
                case DOWNLOAD: {
                    DownloadCombi gitDownloadCombi = new DownloadCombi("https://www.kernel.org/pub/software/scm/git/git-2.13.3.tar.gz", new File(this.downloadDir, "git-2.13.3.tar.gz").getAbsolutePath(), ExtractionMode.EXTRACTION_MODE_TAR_GZ, new File(this.downloadDir, "git-2.13.3").getAbsolutePath(), "d2dc550f6693ba7e5b16212b2714f59f");
                    this.git = this.installPrerequisiteAutotools(installationPrefixPath, "git", "git", gitDownloadCombi, null, this.parallelism);
                    if (this.git == null) {
                        return false;
                    }
                    try {
                        BinaryUtils.validateBinary((String)this.git, (String)"git", (String)installationPrefixPath);
                        break;
                    }
                    catch (BinaryValidationException ex1) {
                        throw new IllegalArgumentException("git exisistence check or installation failed when git installation is expected to have been successful", ex1);
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format(ACTION_TEMPLATE, new Object[]{this.actionOnMissingGit}), ex);
                }
            }
        }
        try {
            BinaryUtils.validateBinary((String)this.openssl, (String)"openssl", (String)installationPrefixPath);
        }
        catch (BinaryValidationException ex1) {
            switch (this.actionOnMissingOpenssl) {
                case FAIL: {
                    throw new IllegalStateException(String.format("openssl binary '%s' doesn't exist and can't be found in PATH", this.openssl), ex1);
                }
                case DOWNLOAD: {
                    DownloadCombi opensslDownloadCombi = new DownloadCombi("https://www.openssl.org/source/openssl-1.1.1-pre1.tar.gz", new File(this.downloadDir, "openssl-1.1.1-pre1.tar.gz").getAbsolutePath(), ExtractionMode.EXTRACTION_MODE_TAR_GZ, new File(this.downloadDir, "openssl-1.1.1-pre1").getAbsolutePath(), "4ccfcaeeeb14730597aad0bc049a46b4");
                    this.openssl = this.installPrerequisiteAutotools(installationPrefixPath, "openssl", "openssl", opensslDownloadCombi, null, this.parallelism);
                    if (this.openssl == null) {
                        return false;
                    }
                    try {
                        BinaryUtils.validateBinary((String)this.openssl, (String)"openssl", (String)installationPrefixPath);
                        break;
                    }
                    catch (BinaryValidationException ex2) {
                        throw new IllegalArgumentException("openssl exisistence check or installation failed when openssl installation is expected to have been successful", ex2);
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format(ACTION_TEMPLATE, new Object[]{this.actionOnMissingOpenssl}), ex1);
                }
            }
        }
        try {
            BinaryUtils.validateBinary((String)this.python, (String)"python", (String)installationPrefixPath);
        }
        catch (BinaryValidationException ex1) {
            switch (this.actionOnMissingPython) {
                case FAIL: {
                    throw new IllegalStateException(String.format("python binary '%s' doesn't exist and can't be found in PATH", this.python), ex1);
                }
                case DOWNLOAD: {
                    DownloadCombi pythonDownloadCombi = new DownloadCombi("https://www.python.org/ftp/python/3.6.4/Python-3.6.4.tgz", new File(this.downloadDir, "Python-3.6.4.tgz").getAbsolutePath(), ExtractionMode.EXTRACTION_MODE_TAR_GZ, new File(this.downloadDir, "Python-3.6.4").getAbsolutePath(), "9de6494314ea199e3633211696735f65");
                    this.python = this.installPrerequisiteAutotools(installationPrefixPath, "python", "python", pythonDownloadCombi, null, this.parallelism);
                    if (this.python == null) {
                        return false;
                    }
                    try {
                        BinaryUtils.validateBinary((String)this.python, (String)"python", (String)installationPrefixPath);
                        break;
                    }
                    catch (BinaryValidationException ex2) {
                        throw new IllegalArgumentException("python exisistence check or installation failed when python installation is expected to have been successful", ex2);
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format(ACTION_TEMPLATE, new Object[]{this.actionOnMissingPython}), ex1);
                }
            }
        }
        try {
            BinaryUtils.validateBinary((String)this.jhbuild, (String)"jhbuild", (String)installationPrefixPath);
        }
        catch (BinaryValidationException ex) {
            switch (this.actionOnMissingJHBuild) {
                case FAIL: {
                    throw new IllegalStateException(String.format("jhbuild binary '%s' doesn't exist and can't be found in PATH", this.jhbuild), ex);
                }
                case DOWNLOAD: {
                    if (this.jhbuildDownload(installationPrefixPath)) break;
                    return false;
                }
                default: {
                    throw new IllegalArgumentException(String.format(ACTION_TEMPLATE, new Object[]{this.actionOnMissingJHBuild}), ex);
                }
            }
        }
        this.inited = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jhbuildDownload(String installationPrefixPath) throws InterruptedException, BuildFailureException, IOException {
        Object jhbuildCloneProcess;
        Object jhbuildSourceRootCheckProcess;
        File jhbuildCloneDir = new File(this.downloadDir, "jhbuild");
        boolean needClone = true;
        if (jhbuildCloneDir.exists() && jhbuildCloneDir.list().length > 0) {
            JHBuildJavaWrapper jHBuildJavaWrapper = this;
            synchronized (jHBuildJavaWrapper) {
                if (this.canceled) {
                    return false;
                }
            }
            jhbuildSourceRootCheckProcess = this.createProcess(jhbuildCloneDir, installationPrefixPath, this.git, "status");
            LOGGER.debug("waiting for jhbuild source root check");
            ((Process)jhbuildSourceRootCheckProcess).waitFor();
            if (((Process)jhbuildSourceRootCheckProcess).exitValue() != 0) {
                OutputReaderThread stdoutReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(jhbuildSourceRootCheckProcess).getKey();
                OutputReaderThread stderrReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(jhbuildSourceRootCheckProcess).getValue();
                String stdout = REDIRECTED_TEMPLATE;
                String stderr = REDIRECTED_TEMPLATE;
                if (stdoutReaderThread != null) {
                    stdoutReaderThread.join();
                    stdout = ((ByteArrayOutputStream)this.processErrorStreamMap.get(jhbuildSourceRootCheckProcess).getLeft()).toString();
                    if (this.outputLimit > 0) {
                        stdout = this.handleOutputLimit(stdout);
                    }
                }
                if (stderrReaderThread != null) {
                    stderrReaderThread.join();
                    stderr = ((ByteArrayOutputStream)this.processErrorStreamMap.get(jhbuildSourceRootCheckProcess).getRight()).toString();
                }
                if (this.outputMode == OutputMode.JOIN_STDOUT_STDERR) {
                    throw new IllegalStateException(String.format("The jhbuild clone directory '%s' already exist, is not empty and is not a valid git source root. This might be the result of a failing previous checkout. You need to check and eventually delete the existing directory or specify another download directory for JHBuild Java wrapper (git status process had output '%s').", jhbuildCloneDir.getAbsolutePath(), stdout));
                }
                if (this.outputMode == OutputMode.SPLIT_STDOUT_STDERR) {
                    throw new IllegalStateException(String.format("The jhbuild clone directory '%s' already exist, is not empty and is not a valid git source root. This might be the result of a failing previous checkout. You need to check and eventually delete the existing directory or specify another download directory for JHBuild Java wrapper (git status process had stdout '%s' and stderr '%s').", jhbuildCloneDir.getAbsolutePath(), stdout, stderr));
                }
                throw new IllegalArgumentException(String.format(OUTPUT_MODE_TEMPLATE, new Object[]{this.outputMode}));
            }
            needClone = false;
        }
        if (needClone) {
            jhbuildSourceRootCheckProcess = this;
            synchronized (jhbuildSourceRootCheckProcess) {
                if (this.canceled) {
                    return false;
                }
            }
            jhbuildCloneProcess = this.createProcess(installationPrefixPath, this.git, "clone", "https://gitlab.gnome.org/GNOME/jhbuild.git", jhbuildCloneDir.getAbsolutePath());
            LOGGER.debug("waiting for jhbuild download");
            ((Process)jhbuildCloneProcess).waitFor();
            if (((Process)jhbuildCloneProcess).exitValue() != 0) {
                this.handleBuilderFailure("jhbuild", BuildStep.CLONE, (Process)jhbuildCloneProcess);
            }
            LOGGER.debug("jhbuild download finished");
        }
        jhbuildCloneProcess = this;
        synchronized (jhbuildCloneProcess) {
            if (this.canceled) {
                return false;
            }
        }
        Process jhbuildAutogenProcess = this.createProcess(jhbuildCloneDir, installationPrefixPath, this.sh, "autogen.sh", String.format("--prefix=%s", this.installationPrefixDir.getAbsolutePath()));
        LOGGER.debug("waiting for jhbuild build bootstrap process");
        jhbuildAutogenProcess.waitFor();
        if (jhbuildAutogenProcess.exitValue() != 0) {
            this.handleBuilderFailure("jhbuild", BuildStep.BOOTSTRAP, jhbuildAutogenProcess);
        }
        LOGGER.debug("jhbuild build bootstrap process finished");
        JHBuildJavaWrapper stdoutReaderThread = this;
        synchronized (stdoutReaderThread) {
            if (this.canceled) {
                return false;
            }
        }
        Process jhbuildMakeProcess = this.createProcess(jhbuildCloneDir, installationPrefixPath, this.make, String.format("-j%d", this.parallelism));
        LOGGER.debug("waiting for jhbuild build process");
        jhbuildMakeProcess.waitFor();
        if (jhbuildMakeProcess.exitValue() != 0) {
            this.handleBuilderFailure("jhbuild", BuildStep.MAKE, jhbuildMakeProcess);
        }
        LOGGER.debug("jhbuild build process finished");
        JHBuildJavaWrapper stderrReaderThread = this;
        synchronized (stderrReaderThread) {
            if (this.canceled) {
                return false;
            }
        }
        Process jhbuildMakeInstallProcess = this.createProcess(jhbuildCloneDir, installationPrefixPath, this.make, "install");
        LOGGER.debug("waiting for jhbuild installation process");
        jhbuildMakeInstallProcess.waitFor();
        if (jhbuildMakeInstallProcess.exitValue() != 0) {
            this.handleBuilderFailure("jhbuild", BuildStep.MAKE_INSTALL, jhbuildMakeInstallProcess);
        }
        LOGGER.debug("jhbuild installation process finished");
        this.jhbuild = "jhbuild";
        LOGGER.debug(String.format("using jhbuild command '%s'", this.jhbuild));
        return true;
    }

    private void handleBuilderFailure(String moduleName, BuildStep buildFailureStep, Process failedBuildProcess) throws BuildFailureException, IOException, InterruptedException {
        String stdout = null;
        String stderr = null;
        if (this.stdoutOutputStream != null) {
            OutputReaderThread stdoutReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(failedBuildProcess).getKey();
            stdoutReaderThread.join();
            stdout = ((ByteArrayOutputStream)this.processErrorStreamMap.get(failedBuildProcess).getLeft()).toString();
            if (this.outputLimit > 0) {
                stdout = this.handleOutputLimit(stdout);
            }
        }
        if (this.stderrOutputStream != null) {
            OutputReaderThread stderrReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(failedBuildProcess).getValue();
            stderrReaderThread.join();
            stderr = ((ByteArrayOutputStream)this.processErrorStreamMap.get(failedBuildProcess).getRight()).toString();
        }
        if (this.outputMode == OutputMode.JOIN_STDOUT_STDERR) {
            throw new BuildFailureException(moduleName, buildFailureStep, stdout);
        }
        if (this.outputMode == OutputMode.SPLIT_STDOUT_STDERR) {
            throw new BuildFailureException(moduleName, buildFailureStep, stdout, stderr);
        }
        throw new IllegalArgumentException(String.format(OUTPUT_MODE_TEMPLATE, new Object[]{this.outputMode}));
    }

    private String handleOutputLimit(String output) {
        assert (this.outputLimit > 0);
        int stdoutSize = output.length() * 8;
        int begin = stdoutSize - this.outputLimit >= 0 ? (stdoutSize - this.outputLimit) / 8 : 0;
        return String.format("(shortened to the last %d bytes according to specified output limit) %s", this.outputLimit, output.substring(begin, output.length() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelInstallModuleset() {
        this.canceled = true;
        JHBuildJavaWrapper jHBuildJavaWrapper = this;
        synchronized (jHBuildJavaWrapper) {
            if (this.activeProcess != null) {
                this.activeProcess.destroy();
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean installModuleset(String moduleName) throws IOException, ExtractionException, InterruptedException, MissingSystemBinaryException, BuildFailureException, ModuleBuildFailureException, DownloadException {
        InputStream modulesetInputStream = JHBuildJavaWrapper.class.getResourceAsStream("/moduleset-default.xml");
        assert (modulesetInputStream != null);
        return this.installModuleset(modulesetInputStream, moduleName);
    }

    public boolean installModuleset(InputStream modulesetInputStream, String moduleName) throws IOException, ExtractionException, InterruptedException, MissingSystemBinaryException, BuildFailureException, ModuleBuildFailureException, DownloadException, IllegalArgumentException {
        this.canceled = false;
        if (modulesetInputStream == null) {
            throw new IllegalArgumentException("modulesetInputStream mustn't be null");
        }
        if (moduleName == null || moduleName.isEmpty()) {
            throw new IllegalArgumentException("moduleName mustn't be null or empty");
        }
        return this.runLockGuarded(() -> {
            String installationPrefixPath = String.join((CharSequence)File.pathSeparator, String.join((CharSequence)File.separator, this.installationPrefixDir.getAbsolutePath(), "bin"), System.getenv(PATH));
            LOGGER.debug(String.format("using PATH %s for installation routines", installationPrefixPath));
            boolean notCanceled = this.init(installationPrefixPath);
            if (!notCanceled) {
                return false;
            }
            LOGGER.debug(String.format("building module %s with jhbuild command %s", moduleName, this.jhbuild));
            String jHBuildrcTemplate = String.format("prefix=\"%s\"\ncheckoutroot = \"%s\"", this.installationPrefixDir.getAbsolutePath(), this.downloadDir.getAbsolutePath());
            LOGGER.debug("jhbuild configuration file template result: '{}'", (Object)jHBuildrcTemplate);
            File jHBuildrcFile = Files.createTempFile(JHBuildJavaWrapper.class.getSimpleName(), "jhbuildrc", new FileAttribute[0]).toFile();
            IOUtils.write((String)jHBuildrcTemplate, (OutputStream)Files.newOutputStream(jHBuildrcFile.toPath(), new OpenOption[0]), (Charset)Charsets.UTF_8);
            Process jhbuildBootstrapProcess = this.createProcess(installationPrefixPath, this.jhbuild, String.format("--file=%s", jHBuildrcFile.getAbsolutePath()), this.exitOnError ? "--exit-on-error" : "", "bootstrap");
            LOGGER.debug("waiting for jhbuild bootstrap process");
            jhbuildBootstrapProcess.waitFor();
            if (jhbuildBootstrapProcess.exitValue() != 0) {
                OutputReaderThread stdoutReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(jhbuildBootstrapProcess).getKey();
                OutputReaderThread stderrReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(jhbuildBootstrapProcess).getValue();
                String stdout = REDIRECTED_TEMPLATE;
                String stderr = REDIRECTED_TEMPLATE;
                if (stdoutReaderThread != null) {
                    stdoutReaderThread.join();
                    stdout = ((ByteArrayOutputStream)this.processErrorStreamMap.get(jhbuildBootstrapProcess).getLeft()).toString();
                    if (this.outputLimit > 0) {
                        stdout = this.handleOutputLimit(stdout);
                    }
                }
                if (stderrReaderThread != null) {
                    stderrReaderThread.join();
                    stderr = ((ByteArrayOutputStream)this.processErrorStreamMap.get(jhbuildBootstrapProcess).getRight()).toString();
                }
                if (this.outputMode == OutputMode.JOIN_STDOUT_STDERR) {
                    throw new ModuleBuildFailureException(String.format("jhbuild bootstrap process returned with code %d (output was '%s')", jhbuildBootstrapProcess.exitValue(), stdout));
                }
                if (this.outputMode == OutputMode.SPLIT_STDOUT_STDERR) {
                    throw new ModuleBuildFailureException(String.format("jhbuild bootstrap process returned with code %d (stdout was '%s' and stderr was '%s')", jhbuildBootstrapProcess.exitValue(), stdout, stderr));
                }
                throw new IllegalArgumentException(String.format(OUTPUT_MODE_TEMPLATE, new Object[]{this.outputMode}));
            }
            LOGGER.debug("jhbuild bootstrap process finished");
            File modulesetFile = Files.createTempFile(JHBuildJavaWrapper.class.getSimpleName(), "moduleset", new FileAttribute[0]).toFile();
            IOUtils.copy((InputStream)modulesetInputStream, (OutputStream)Files.newOutputStream(modulesetFile.toPath(), new OpenOption[0]));
            Process jhbuildProcess = this.createProcess(installationPrefixPath, this.jhbuild, String.format("--file=%s", jHBuildrcFile.getAbsolutePath()), String.format("--moduleset=%s", modulesetFile.getAbsolutePath()), "--no-interact", this.exitOnError ? "--exit-on-error" : "", "build", "--nodeps", moduleName);
            LOGGER.debug("waiting for jhbuild build process");
            jhbuildProcess.waitFor();
            if (jhbuildProcess.exitValue() != 0) {
                OutputReaderThread stdoutReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(jhbuildProcess).getKey();
                OutputReaderThread stderrReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(jhbuildProcess).getValue();
                String stdout = REDIRECTED_TEMPLATE;
                String stderr = REDIRECTED_TEMPLATE;
                if (stdoutReaderThread != null) {
                    stdoutReaderThread.join();
                    stdout = ((ByteArrayOutputStream)this.processErrorStreamMap.get(jhbuildProcess).getLeft()).toString();
                    if (this.outputLimit > 0) {
                        stdout = this.handleOutputLimit(stdout);
                    }
                }
                if (stderrReaderThread != null) {
                    stderrReaderThread.join();
                    stderr = ((ByteArrayOutputStream)this.processErrorStreamMap.get(jhbuildProcess).getRight()).toString();
                }
                if (this.outputMode == OutputMode.JOIN_STDOUT_STDERR) {
                    throw new ModuleBuildFailureException(String.format("jhbuild returned with code %d during building of module '%s' (output was '%s')", jhbuildProcess.exitValue(), moduleName, stdout));
                }
                if (this.outputMode == OutputMode.SPLIT_STDOUT_STDERR) {
                    throw new ModuleBuildFailureException(String.format("jhbuild returned with code %d during building of module '%s' (stdout was '%s' and stderr was '%s')", jhbuildProcess.exitValue(), moduleName, stdout, stderr));
                }
                throw new IllegalArgumentException(String.format(OUTPUT_MODE_TEMPLATE, new Object[]{this.outputMode}));
            }
            LOGGER.debug("jhbuild build process finished");
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runLockGuarded(LockGuardedLambda lockGuardedLambda) throws IOException, ExtractionException, InterruptedException, MissingSystemBinaryException, BuildFailureException, ModuleBuildFailureException, DownloadException, IllegalArgumentException {
        JHBUILD_THREAD_LOCK.lock();
        try {
            boolean bl;
            if (!JHBUILD_FILE_LOCK_FILE.exists()) {
                Files.createDirectories(Paths.get(JHBUILD_FILE_LOCK_FILE.getParent(), new String[0]), new FileAttribute[0]);
                JHBUILD_FILE_LOCK_FILE.createNewFile();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(JHBUILD_FILE_LOCK_FILE, "rw");
            FileLock fileLock = randomAccessFile.getChannel().lock(0L, Long.MAX_VALUE, false);
            try {
                bl = lockGuardedLambda.action();
            }
            catch (Throwable throwable) {
                try {
                    fileLock.release();
                }
                finally {
                    randomAccessFile.close();
                }
                throw throwable;
            }
            try {
                fileLock.release();
            }
            finally {
                randomAccessFile.close();
            }
            return bl;
        }
        finally {
            JHBUILD_THREAD_LOCK.unlock();
        }
    }

    private String installPrerequisiteAutotools(String installationPrefixPath, String binary, String binaryDescription, DownloadCombi downloadCombi, List<DownloadCombi> patchDownloadCombis, int parallelism) throws IOException, ExtractionException, MissingSystemBinaryException, InterruptedException, BuildFailureException, DownloadException {
        List<BuildStepProcess> buildStepProcesses = this.generateBuildStepProcessesAutotools(installationPrefixPath, parallelism, CONFIGURE, new String[0]);
        return this.installPrerequisiteAutotools(installationPrefixPath, binary, binaryDescription, downloadCombi, patchDownloadCombis, buildStepProcesses);
    }

    private String installPrerequisiteAutotools(String installationPrefixPath, String binary, String binaryDescription, DownloadCombi downloadCombi, List<DownloadCombi> patchDownloadCombis, List<BuildStepProcess> buildStepProcesses) throws IOException, ExtractionException, MissingSystemBinaryException, InterruptedException, BuildFailureException, DownloadException {
        String retValue = this.installPrerequisite0(installationPrefixPath, binary, binaryDescription, downloadCombi, patchDownloadCombis, buildStepProcesses);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installPrerequisite0(String installationPrefixPath, String binary, String binaryDescription, DownloadCombi downloadCombi, List<DownloadCombi> patchDownloadCombis, List<BuildStepProcess> buildSteps) throws IOException, ExtractionException, MissingSystemBinaryException, InterruptedException, BuildFailureException, DownloadException {
        boolean notDownloadCanceled = this.downloader.downloadFile(downloadCombi, this.skipMD5SumCheck, DownloadFailureCallback.RETRY_5_TIMES, MD5SumCheckUnequalsCallback.RETRY_5_TIMES, DownloadEmptyCallback.RETRY_5_TIMES);
        if (!notDownloadCanceled) {
            LOGGER.debug(String.format("install prerequisiste download for %s canceled", binaryDescription));
            return null;
        }
        File extractionLocationDir = new File(downloadCombi.getExtractionLocation());
        assert (extractionLocationDir.exists());
        if (patchDownloadCombis != null && !patchDownloadCombis.isEmpty()) {
            try {
                BinaryUtils.validateBinary((String)this.patch, (String)PATCH_DEFAULT, (String)installationPrefixPath);
            }
            catch (BinaryValidationException ex1) {
                throw new MissingSystemBinaryException(PATCH_DEFAULT, (Exception)((Object)ex1));
            }
            for (DownloadCombi patchDownloadCombi : patchDownloadCombis) {
                boolean notPatchDownloadCanceled = this.downloader.downloadFile(patchDownloadCombi, this.skipMD5SumCheck, DownloadFailureCallback.RETRY_5_TIMES, MD5SumCheckUnequalsCallback.RETRY_5_TIMES, DownloadEmptyCallback.RETRY_5_TIMES);
                if (!notPatchDownloadCanceled) {
                    LOGGER.debug(String.format("install prerequisiste download for %s canceled", binaryDescription));
                    return null;
                }
                assert (patchDownloadCombi.getExtractionLocation() != null);
                File patchFile = new File(patchDownloadCombi.getExtractionLocation());
                if (!patchFile.isFile()) {
                    throw new IllegalArgumentException(String.format("patch download combi %s caused download (and eventual extraction) of something which is not a file", patchDownloadCombi));
                }
                LOGGER.info(String.format("patching source root %s using patch file %s", extractionLocationDir.getAbsolutePath(), patchFile.getAbsolutePath()));
                Process patchProcess = this.createProcess(extractionLocationDir, installationPrefixPath, this.patch, "-p1", String.format("<%s", patchFile.getAbsolutePath()));
                patchProcess.waitFor();
                if (patchProcess.exitValue() != 0) {
                    throw new IllegalArgumentException(String.format("patching extraction direction %s with patch file %s failed", extractionLocationDir.getAbsolutePath(), patchFile.getAbsolutePath()));
                }
                OutputReaderThread stdoutReaderThread = (OutputReaderThread)this.processOutputReaderThreadMap.get(patchProcess).getKey();
                String patchProcessStdout = REDIRECTED_TEMPLATE;
                if (stdoutReaderThread != null) {
                    stdoutReaderThread.join();
                    patchProcessStdout = ((ByteArrayOutputStream)this.processErrorStreamMap.get(patchProcess).getLeft()).toString();
                }
                LOGGER.debug(String.format("successful patch process' output was: %s", patchProcessStdout));
            }
        }
        try {
            BinaryUtils.validateBinary((String)this.make, (String)MAKE_DEFAULT, (String)installationPrefixPath);
        }
        catch (BinaryValidationException ex1) {
            throw new MissingSystemBinaryException(MAKE_DEFAULT, (Exception)((Object)ex1));
        }
        JHBuildJavaWrapper jHBuildJavaWrapper = this;
        synchronized (jHBuildJavaWrapper) {
            if (this.canceled) {
                LOGGER.debug(String.format("canceling prerequisiste installation of %s because the build wrapper has been canceled", binaryDescription));
                return null;
            }
        }
        for (BuildStepProcess buildProcessStep : buildSteps) {
            Process process = buildProcessStep.getProcess(extractionLocationDir);
            process.waitFor();
            if (process.exitValue() != 0) {
                BuildStep buildStep = buildProcessStep.getBuildStep();
                this.handleBuilderFailure(binaryDescription, buildStep, process);
            }
            JHBuildJavaWrapper jHBuildJavaWrapper2 = this;
            synchronized (jHBuildJavaWrapper2) {
                if (this.canceled) {
                    LOGGER.debug(String.format("canceling prerequisiste installation of %s because the build wrapper has been canceled", binaryDescription));
                    return null;
                }
            }
        }
        return binary;
    }

    protected boolean checkLibPresence(File installationPrefixDir, String pcFileName) throws IOException {
        Optional<Path> hit = Files.walk(installationPrefixDir.toPath(), new FileVisitOption[0]).filter(file -> file.getFileName().toFile().getName().equals(pcFileName)).findAny();
        if (!hit.isPresent()) {
            hit = ((Stream)Stream.of(File.listRoots()).parallel()).map(root -> {
                try {
                    return Files.walk(Paths.get(root.getName(), new String[0]), new FileVisitOption[0]).filter(file -> file.getFileName().toFile().getName().equals(pcFileName)).findAny();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).filter(root -> root.isPresent()).map(root -> (Path)root.get()).findAny();
        }
        return hit.isPresent();
    }

    private List<BuildStepProcess> generateBuildStepProcessesAutotools(final String installationPrefixPath, final int parallelism, final String configureName, final String ... additionalConfigureOptions) {
        assert (parallelism >= 1) : String.format("parallelism has to be >= 1 in order to make sense (was %s)", parallelism);
        return new LinkedList<BuildStepProcess>(Arrays.asList(new BuildStepProcess(){

            @Override
            public Process getProcess(File extractionLocationDir) throws IOException {
                LinkedList<String> commandList = new LinkedList<String>(Arrays.asList(JHBuildJavaWrapper.this.sh, configureName, String.format("--prefix=%s", JHBuildJavaWrapper.this.installationPrefixDir.getAbsolutePath())));
                for (String additionalConfigureOption : additionalConfigureOptions) {
                    commandList.add(additionalConfigureOption);
                }
                String[] commands = commandList.toArray(new String[0]);
                Process configureProcess = JHBuildJavaWrapper.this.createProcess(extractionLocationDir, (Map)ImmutableMap.builder().put((Object)JHBuildJavaWrapper.PATH, (Object)installationPrefixPath).put((Object)"CFLAGS", (Object)String.format("-I%s -L%s", new File(JHBuildJavaWrapper.this.installationPrefixDir, "include").getAbsolutePath(), new File(JHBuildJavaWrapper.this.installationPrefixDir, "lib").getAbsolutePath())).build(), commands);
                return configureProcess;
            }

            @Override
            public BuildStep getBuildStep() {
                return BuildStep.CONFIGURE;
            }
        }, new BuildStepProcess(){

            @Override
            public Process getProcess(File extractionLocationDir) throws IOException {
                return JHBuildJavaWrapper.this.createProcess(extractionLocationDir, (Map)ImmutableMap.builder().put((Object)JHBuildJavaWrapper.PATH, (Object)installationPrefixPath).put((Object)"CFLAGS", (Object)String.format("-I%s -L%s", new File(JHBuildJavaWrapper.this.installationPrefixDir, "include").getAbsolutePath(), new File(JHBuildJavaWrapper.this.installationPrefixDir, "lib").getAbsolutePath())).build(), new String[]{JHBuildJavaWrapper.this.make, String.format("-j%d", parallelism)});
            }

            @Override
            public BuildStep getBuildStep() {
                return BuildStep.MAKE;
            }
        }, new BuildStepProcess(){

            @Override
            public Process getProcess(File extractionLocationDir) throws IOException {
                return JHBuildJavaWrapper.this.createProcess(extractionLocationDir, installationPrefixPath, new String[]{JHBuildJavaWrapper.this.make, "install"});
            }

            @Override
            public BuildStep getBuildStep() {
                return BuildStep.MAKE_INSTALL;
            }
        }));
    }

    @FunctionalInterface
    private static interface LockGuardedLambda {
        public boolean action() throws IOException, ExtractionException, InterruptedException, MissingSystemBinaryException, BuildFailureException, ModuleBuildFailureException, DownloadException, IllegalArgumentException;
    }

    private static interface BuildStepProcess {
        public Process getProcess(File var1) throws IOException;

        public BuildStep getBuildStep();
    }
}

