/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.asyncio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.serialization.util.FSTUtil;

public abstract class AsyncSocketConnection {
    protected ByteBuffer readBuf = ByteBuffer.allocateDirect(4096);
    protected SelectionKey key;
    protected SocketChannel chan;
    protected Promise writePromise;
    protected ByteBuffer writingBuffer;
    protected boolean isClosed;
    protected Executor myActor;
    protected Thread theExecutingThread;

    public AsyncSocketConnection(SelectionKey key, SocketChannel chan) {
        this.key = key;
        this.chan = chan;
    }

    public abstract void closed(Throwable var1);

    public void close() throws IOException {
        this.chan.close();
    }

    boolean readData() throws IOException {
        this.checkThread();
        this.readBuf.position(0);
        this.readBuf.limit(this.readBuf.capacity());
        int read = this.chan.read(this.readBuf);
        if (read == -1) {
            throw new EOFException("connection closed");
        }
        this.readBuf.flip();
        if (this.readBuf.limit() > 0) {
            this.dataReceived(this.readBuf);
        }
        return read == this.readBuf.capacity();
    }

    protected void checkThread() {
        if (this.theExecutingThread == null) {
            this.theExecutingThread = Thread.currentThread();
        } else if (this.theExecutingThread != Thread.currentThread()) {
            System.err.println("unexpected multithreading");
            Thread.dumpStack();
        }
    }

    protected IPromise directWrite(ByteBuffer buf) {
        this.checkThread();
        if (this.myActor == null) {
            this.myActor = Actor.current();
        }
        if (this.writePromise != null) {
            throw new RuntimeException("concurrent write con:" + this.chan.isConnected() + " open:" + this.chan.isOpen());
        }
        this.writePromise = new Promise();
        this.writingBuffer = buf;
        Promise res = this.writePromise;
        try {
            int written = 0;
            written = this.chan.write(buf);
            if (written < 0) {
                this.writeFinished(new IOException("connection closed"));
            }
            if (buf.remaining() <= 0) {
                this.writeFinished(null);
            }
        }
        catch (Exception e) {
            res.reject(e);
            FSTUtil.rethrow((Throwable)e);
        }
        return res;
    }

    ByteBuffer getWritingBuffer() {
        return this.writingBuffer;
    }

    public boolean canWrite() {
        return this.writePromise == null;
    }

    void writeFinished(Object error) {
        this.checkThread();
        this.writingBuffer = null;
        Promise wp = this.writePromise;
        this.writePromise = null;
        if (!wp.isSettled()) {
            if (error != null) {
                wp.reject(error);
            } else {
                wp.resolve();
            }
        }
    }

    public abstract void dataReceived(ByteBuffer var1);

    public boolean isClosed() {
        return !this.chan.isOpen() || this.isClosed;
    }
}

