/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.util;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.Scheduler;

public class Hoarde<T extends Actor> {
    Actor[] actors;
    int index = 0;
    Promise prev;

    public Hoarde(int numActors, Class<T> actor) {
        this.actors = new Actor[numActors];
        for (int i = 0; i < this.actors.length; ++i) {
            this.actors[i] = Actors.AsActor(actor);
        }
    }

    public Hoarde(int numActors, Class<T> actor, Scheduler sched) {
        this.actors = new Actor[numActors];
        for (int i = 0; i < this.actors.length; ++i) {
            this.actors[i] = Actors.AsActor(actor, sched);
        }
    }

    public <X> IPromise<T>[] map(BiFunction<T, Integer, IPromise<X>> init) {
        IPromise[] res = new IPromise[this.actors.length];
        for (int i = 0; i < this.actors.length; ++i) {
            Actor actor = this.actors[i];
            res[i] = init.apply(actor, i);
        }
        return res;
    }

    public Hoarde<T> each(Consumer<T> tocall) {
        for (int i = 0; i < this.actors.length; ++i) {
            tocall.accept(this.actors[i]);
        }
        return this;
    }

    public Hoarde<T> each(BiConsumer<T, Integer> init) {
        for (int i = 0; i < this.actors.length; ++i) {
            init.accept(this.actors[i], i);
        }
        return this;
    }

    public IPromise ordered(Function<T, IPromise> toCall) {
        IPromise result = toCall.apply(this.actors[this.index]);
        ++this.index;
        if (this.index == this.actors.length) {
            this.index = 0;
        }
        if (this.prev == null) {
            this.prev = new Promise();
            result.then(this.prev);
            return this.prev;
        }
        Promise p = new Promise();
        this.prev.getNext().finallyDo((res, err) -> result.then((res1, err1) -> p.complete(res1, err1)));
        this.prev = p;
        return p;
    }

    public int getSize() {
        return this.actors.length;
    }

    public T getActor(int i) {
        return (T)this.actors[i];
    }
}

