package de.schegge.enumconverter;

import ftl.ParseException;
import org.freshmarker.Template;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;

import static java.nio.charset.StandardCharsets.UTF_8;

public class FreshMarkerSourceCodeGenerator implements SourceCodeGenerator {

    private final Template template;

    public FreshMarkerSourceCodeGenerator(Class<?> baseClass, String name, String version) {
        org.freshmarker.Configuration configuration = new org.freshmarker.Configuration();
        String templateContent = new Scanner(baseClass.getResourceAsStream("template.ftl"), UTF_8).useDelimiter("\\A").next();
        Map<String, Object> model = Map.of(
                "author", Objects.requireNonNull(name) + " by Jens Kaiser",
                "version", Objects.requireNonNull(version));
        template = configuration.getTemplate("template.ftl", templateContent).reduce(model);

    }

    @Override
    public void processTemplate(Map<String, Object> root, PrintWriter out) {
        try {
            template.process(root, out);
        } catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}
