package de.schegge.enumconverter;

import java.util.List;

public final class ValueHolder {

  private final String key;
  private final List<String> value;

  private final boolean plain;

  ValueHolder(String key, List<String> value, boolean plain) {
    this.key = key;
    this.value = value;
    this.plain = plain;
  }

  public String getKey() {
    return key;
  }

  public List<String> getValue() {
    return value;
  }

  public boolean isPlain() {
    return plain;
  }

  @Override
  public String toString() {
    return key + "=" + value + " (" + plain + ")";
  }
}
