/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import de.sciss.fscape.stream.Control;
import de.sciss.fscape.stream.FileBuffer$;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.channels.FileChannel;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%u!\u0002\u0012$\u0011\u0003ac!\u0002\u0018$\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004\"\u0002\u001d\u0002\t\u0003I\u0004B\u0002\u001d\u0002\t\u0003\t\tA\u0002\u0004\u0002\u0010\u00051\u0011\u0011\u0003\u0005\t{\u0015\u0011)\u0019!C\u0001}!I\u00111C\u0003\u0003\u0002\u0003\u0006Ia\u0010\u0005\u000b\u0003\u000f)!\u0011!Q\u0001\n\u0005%\u0001B\u0002\u001c\u0006\t\u0003\t)\u0002C\u0004\u0002 \u0015!\t%!\t\t\u0011\u0005MR\u0001)A\u0005\u0003kA\u0001\"!\u0012\u0006A\u0003%\u0011q\t\u0005\t\u0003/*\u0001\u0015)\u0003\u0002Z!A\u0011\u0011M\u0003!B\u0013\t\u0019\u0007C\u0003Q\u000b\u0011\u0005\u0011\u000b\u0003\u0004V\u000b\u0011\u0005\u0011\u0011\u000e\u0005\u0006?\u0016!\tA\u0018\u0005\u00069\u0016!\t!\u0015\u0005\b\u0003[*A\u0011BA8\u0011\u0019\tX\u0001\"\u0001\u0002t!1a/\u0002C\u0001\u0003wBa\u0001Y\u0003\u0005\u0002\u0005\u0005\u0005\"B/\u0006\t\u0003qfa\u0002\u0018$!\u0003\r\n\u0001\u0010\u0005\u0006{a1\tA\u0010\u0005\b!b\u0001\rQ\"\u0001R\u0011\u001d)\u0006\u00041A\u0007\u0002YCQ\u0001\u0018\r\u0007\u0002ECQ!\u0018\r\u0007\u0002yCQa\u0018\r\u0007\u0002yCQ\u0001\u0019\r\u0007\u0002\u0005DQ!\u001d\r\u0007\u0002IDQA\u001e\r\u0007\u0002]\f!BR5mK\n+hMZ3s\u0015\t!S%\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003M\u001d\naAZ:dCB,'B\u0001\u0015*\u0003\u0015\u00198-[:t\u0015\u0005Q\u0013A\u00013f\u0007\u0001\u0001\"!L\u0001\u000e\u0003\r\u0012!BR5mK\n+hMZ3s'\t\t\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\nQ!\u00199qYf$\u0012A\u000f\u000b\u0003wm\u0004\"!\f\r\u0014\u0005a\u0001\u0014\u0001\u00024jY\u0016,\u0012a\u0010\t\u0003\u00016s!!\u0011&\u000f\u0005\tKeBA\"I\u001d\t!u)D\u0001F\u0015\t15&\u0001\u0004=e>|GOP\u0005\u0002U%\u0011\u0001&K\u0005\u0003{\u001dJ!a\u0013'\u0002\u000fA\f7m[1hK*\u0011QhJ\u0005\u0003\u001d>\u0013AAR5mK*\u00111\nT\u0001\ta>\u001c\u0018\u000e^5p]V\t!\u000b\u0005\u00022'&\u0011AK\r\u0002\u0005\u0019>tw-\u0001\u0007q_NLG/[8o?\u0012*\u0017\u000f\u0006\u0002X5B\u0011\u0011\u0007W\u0005\u00033J\u0012A!\u00168ji\"91lGA\u0001\u0002\u0004\u0011\u0016a\u0001=%c\u0005Ia.^7Ge\u0006lWm]\u0001\u0007e\u0016<\u0018N\u001c3\u0015\u0003]\u000bq\u0001Z5ta>\u001cX-\u0001\u0003sK\u0006$G\u0003B,cU>DQaY\u0010A\u0002\u0011\f1AY;g!\r\tTmZ\u0005\u0003MJ\u0012Q!\u0011:sCf\u0004\"!\r5\n\u0005%\u0014$A\u0002#pk\ndW\rC\u0003l?\u0001\u0007A.A\u0002pM\u001a\u0004\"!M7\n\u00059\u0014$aA%oi\")\u0001o\ba\u0001Y\u0006\u0019A.\u001a8\u0002\u000b]\u0014\u0018\u000e^3\u0015\t]\u001bH/\u001e\u0005\u0006G\u0002\u0002\r\u0001\u001a\u0005\u0006W\u0002\u0002\r\u0001\u001c\u0005\u0006a\u0002\u0002\r\u0001\\\u0001\u000boJLG/\u001a,bYV,GcA,yu\")\u00110\ta\u0001O\u0006)a/\u00197vK\")\u0001/\ta\u0001%\")Ap\u0001a\u0002{\u0006!1\r\u001e:m!\tic0\u0003\u0002\u0000G\t91i\u001c8ue>dG#B\u001e\u0002\u0004\u0005\u0015\u0001\"B\u001f\u0005\u0001\u0004y\u0004bBA\u0004\t\u0001\u0007\u0011\u0011B\u0001\u0010I\u0016dW\r^3P]\u0012K7\u000f]8tKB\u0019\u0011'a\u0003\n\u0007\u00055!GA\u0004C_>dW-\u00198\u0003\t%k\u0007\u000f\\\n\u0004\u000bAZ\u0014!\u00024jY\u0016\u0004CCBA\f\u00037\ti\u0002E\u0002\u0002\u001a\u0015i\u0011!\u0001\u0005\u0006{%\u0001\ra\u0010\u0005\b\u0003\u000fI\u0001\u0019AA\u0005\u0003!!xn\u0015;sS:<GCAA\u0012!\u0011\t)#!\f\u000f\t\u0005\u001d\u0012\u0011\u0006\t\u0003\tJJ1!a\u000b3\u0003\u0019\u0001&/\u001a3fM&!\u0011qFA\u0019\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0006\u001a\u0002\u0007I\fg\r\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0005%|'BAA \u0003\u0011Q\u0017M^1\n\t\u0005\r\u0013\u0011\b\u0002\u0011%\u0006tGm\\7BG\u000e,7o\u001d$jY\u0016\f!a\u00195\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005A1\r[1o]\u0016d7O\u0003\u0003\u0002R\u0005u\u0012a\u00018j_&!\u0011QKA&\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\u0002\u0005\t\u0014\u0007\u0003BA.\u0003;j!!a\u0014\n\t\u0005}\u0013q\n\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00013c!\u0011\tY&!\u001a\n\t\u0005\u001d\u0014q\n\u0002\r\t>,(\r\\3Ck\u001a4WM\u001d\u000b\u0004/\u0006-\u0004\"B=\u0011\u0001\u0004\u0011\u0016!C3ogV\u0014XMQ;g)\r9\u0016\u0011\u000f\u0005\u0006aN\u0001\rA\u0015\u000b\b/\u0006U\u0014qOA=\u0011\u0015\u0019G\u00031\u0001e\u0011\u0015YG\u00031\u0001m\u0011\u0015\u0001H\u00031\u0001m)\u00159\u0016QPA@\u0011\u0015IX\u00031\u0001h\u0011\u0015\u0001X\u00031\u0001S)\u001d9\u00161QAC\u0003\u000fCQa\u0019\fA\u0002\u0011DQa\u001b\fA\u00021DQ\u0001\u001d\fA\u00021\u0004")
public interface FileBuffer {
    public static FileBuffer apply(File file, boolean bl) {
        return FileBuffer$.MODULE$.apply(file, bl);
    }

    public static FileBuffer apply(Control control) {
        return FileBuffer$.MODULE$.apply(control);
    }

    public File file();

    public long position();

    public void position_$eq(long var1);

    public long numFrames();

    public void rewind();

    public void dispose();

    public void read(double[] var1, int var2, int var3);

    public void write(double[] var1, int var2, int var3);

    public void writeValue(double var1, long var3);

    public static final class Impl
    implements FileBuffer {
        private final File file;
        private final boolean deleteOnDispose;
        private final RandomAccessFile raf;
        private final FileChannel ch;
        private ByteBuffer bb;
        private DoubleBuffer db;

        @Override
        public File file() {
            return this.file;
        }

        public String toString() {
            return new StringBuilder(12).append("FileBuffer(").append(this.file()).append(")").toString();
        }

        @Override
        public long position() {
            return this.ch.position() / 8L;
        }

        @Override
        public void position_$eq(long value) {
            this.ch.position(value * 8L);
        }

        @Override
        public void dispose() {
            block0: {
                this.ch.close();
                if (!this.deleteOnDispose) break block0;
                this.file().delete();
            }
        }

        @Override
        public long numFrames() {
            return this.ch.size() / 8L;
        }

        private void ensureBuf(long len) {
            block0: {
                int lim = (int)package$.MODULE$.min(len, 8192L);
                if (this.db != null && this.db.capacity() >= lim) break block0;
                this.bb = ByteBuffer.allocate(lim << 3);
                this.db = this.bb.asDoubleBuffer();
            }
        }

        @Override
        public void write(double[] buf, int off, int len) {
            this.ensureBuf(len);
            int off0 = off;
            int len0 = len;
            while (len0 > 0) {
                int chunk = package$.MODULE$.min(8192, len0);
                this.db.clear();
                this.db.put(buf, off0, chunk);
                this.bb.rewind().limit(chunk << 3);
                this.ch.write(this.bb);
                len0 -= chunk;
                off0 += chunk;
            }
        }

        @Override
        public void writeValue(double value, long len) {
            int chunk;
            this.ensureBuf(len);
            int sz = (int)package$.MODULE$.min(len, (long)this.db.capacity());
            this.db.clear();
            for (int i = 0; i < sz; ++i) {
                this.db.put(value);
            }
            for (long len0 = len; len0 > 0L; len0 -= (long)chunk) {
                chunk = (int)package$.MODULE$.min(8192L, len0);
                this.bb.rewind().limit(chunk << 3);
                this.ch.write(this.bb);
            }
        }

        @Override
        public void read(double[] buf, int off, int len) {
            this.ensureBuf(len);
            int off0 = off;
            int len0 = len;
            while (len0 > 0) {
                int chunk = package$.MODULE$.min(8192, len0);
                this.bb.rewind().limit(chunk << 3);
                this.ch.read(this.bb);
                this.db.clear();
                this.db.get(buf, off0, chunk);
                len0 -= chunk;
                off0 += chunk;
            }
        }

        @Override
        public void rewind() {
            this.position_$eq(0L);
        }

        public Impl(File file, boolean deleteOnDispose) {
            this.file = file;
            this.deleteOnDispose = deleteOnDispose;
            this.raf = new RandomAccessFile(file, "rw");
            this.ch = this.raf.getChannel();
            this.bb = null;
            this.db = null;
        }
    }
}

