/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import akka.stream.FanInShape5;
import akka.stream.Outlet;
import de.sciss.fscape.stream.BufD;
import de.sciss.fscape.stream.BufI;
import de.sciss.fscape.stream.BufL;
import de.sciss.fscape.stream.Builder;
import de.sciss.fscape.stream.Control$;
import de.sciss.fscape.stream.FileBuffer;
import de.sciss.fscape.stream.Fourier;
import de.sciss.fscape.stream.Fourier$LongOps$;
import de.sciss.numbers.Implicits$;
import de.sciss.numbers.RichInt$;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class Fourier$ {
    public static Fourier$ MODULE$;

    static {
        new Fourier$();
    }

    public Outlet<BufD> apply(Outlet<BufD> in, Outlet<BufL> size, Outlet<BufL> padding, Outlet<BufD> dir, Outlet<BufI> mem, Builder b) {
        Fourier.Stage stage0 = new Fourier.Stage(b.layer(), Control$.MODULE$.fromBuilder(b));
        FanInShape5 stage = (FanInShape5)b.add(stage0);
        b.connect(in, stage.in0());
        b.connect(size, stage.in1());
        b.connect(padding, stage.in2());
        b.connect(dir, stage.in3());
        b.connect(mem, stage.in4());
        return stage.out();
    }

    private final String name() {
        return "Fourier";
    }

    public long de$sciss$fscape$stream$Fourier$$LongOps(long a) {
        return a;
    }

    private <A> void swap(Object arr, int i, int j) {
        Object temp = ScalaRunTime$.MODULE$.array_apply(arr, i);
        ScalaRunTime$.MODULE$.array_update(arr, i, ScalaRunTime$.MODULE$.array_apply(arr, j));
        ScalaRunTime$.MODULE$.array_update(arr, j, temp);
    }

    public void de$sciss$fscape$stream$Fourier$$storageFFT(FileBuffer[] audioFiles, File[] tempFiles, long len, double dir, int memAmount) {
        Predef$.MODULE$.require(memAmount >= 2 && RichInt$.MODULE$.isPowerOfTwo$extension(Implicits$.MODULE$.intNumberWrapper(memAmount)));
        Predef$.MODULE$.require(len >= 2L && Fourier$LongOps$.MODULE$.isPowerOfTwo$extension(this.de$sciss$fscape$stream$Fourier$$LongOps(len)));
        int[] indexMap = new int[]{1, 0, 3, 2};
        int[] indices = new int[4];
        double[] buf1 = new double[memAmount];
        double[] buf2 = new double[memAmount];
        double[] buf3 = new double[memAmount];
        long mMax = len;
        long numSteps = len / (long)memAmount;
        long halfSteps = numSteps >> 1;
        double thetaBase = dir * Math.PI;
        int kd = memAmount >> 1;
        long n2 = len;
        long jk = len;
        long kc = 0L;
        this.rewind$1(audioFiles, tempFiles, indices);
        do {
            double theta = thetaBase / (double)(len / mMax);
            double tempW = package$.MODULE$.sin(theta / (double)2);
            double wpRe = -2.0 * tempW * tempW;
            double wpIm = package$.MODULE$.sin(theta);
            double wRe = 1.0;
            double wIm = 0.0;
            mMax >>= 1;
            int i = 0;
            while (i < 2) {
                int step = 0;
                do {
                    audioFiles[indices[0]].read(buf1, 0, memAmount);
                    audioFiles[indices[1]].read(buf2, 0, memAmount);
                    for (int j = 0; j < memAmount; j += 2) {
                        int h = j + 1;
                        double tempRe = wRe * buf2[j] - wIm * buf2[h];
                        double tempIm = wIm * buf2[j] + wRe * buf2[h];
                        buf2[j] = buf1[j] - tempRe;
                        int n = j;
                        buf1[n] = buf1[n] + tempRe;
                        buf2[h] = buf1[h] - tempIm;
                        buf1[h] = buf1[h] + tempIm;
                    }
                    if ((kc += (long)kd) == mMax) {
                        kc = 0L;
                        double tempW2 = wRe;
                        wRe += tempW2 * wpRe - wIm * wpIm;
                        wIm += tempW2 * wpIm + wIm * wpRe;
                    }
                    audioFiles[indices[2]].write(buf1, 0, memAmount);
                    audioFiles[indices[3]].write(buf2, 0, memAmount);
                } while ((long)(++step) < halfSteps);
                if (i == 0 && n2 != len && n2 == (long)memAmount) {
                    indices[0] = indexMap[indices[0]];
                    indices[1] = indices[0];
                }
                if (halfSteps == 0L) {
                    i = 2;
                    continue;
                }
                ++i;
            }
            this.rewind$1(audioFiles, tempFiles, indices);
            if ((jk >>= 1) == 1L) {
                Predef$.MODULE$.assert(false, (Function0 & Serializable & scala.Serializable)() -> "We never get here?");
                mMax = len;
                jk = len;
            }
            if ((n2 >>= 1) > (long)memAmount) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    for (long step = 0L; step < numSteps; step += n2 / (long)memAmount) {
                        for (long n1 = 0L; n1 < n2; n1 += (long)memAmount) {
                            audioFiles[indices[0]].read(buf1, 0, memAmount);
                            audioFiles[indices[2]].write(buf1, 0, memAmount);
                        }
                        indices[2] = indexMap[indices[2]];
                    }
                    indices[0] = indexMap[indices[0]];
                }
                this.rewind$1(audioFiles, tempFiles, indices);
                continue;
            }
            if (n2 != (long)memAmount) continue;
            indices[1] = indices[0];
        } while (n2 >= (long)memAmount);
        int j = 0;
        do {
            double theta = thetaBase / (double)(len / mMax);
            double tempW = package$.MODULE$.sin(theta / (double)2);
            double wpRe = -2.0 * tempW * tempW;
            double wpIm = package$.MODULE$.sin(theta);
            double wRe = 1.0;
            double wIm = 0.0;
            mMax >>= 1;
            int ks = kd;
            kd >>= 1;
            for (int i = 0; i < 2; ++i) {
                int step = 0;
                while ((long)step < numSteps) {
                    audioFiles[indices[0]].read(buf3, 0, memAmount);
                    int kk = 0;
                    int k = ks;
                    do {
                        int h = kk + ks + 1;
                        double tempRe = wRe * buf3[kk + ks] - wIm * buf3[h];
                        double tempIm = wIm * buf3[kk + ks] + wRe * buf3[h];
                        buf1[j] = buf3[kk] + tempRe;
                        buf2[j] = buf3[kk] - tempRe;
                        buf1[++j] = buf3[++kk] + tempIm;
                        buf2[j] = buf3[kk] - tempIm;
                        ++j;
                        if (++kk < k) continue;
                        if ((kc += (long)kd) == mMax) {
                            kc = 0L;
                            double tempW3 = wRe;
                            wRe += tempW3 * wpRe - wIm * wpIm;
                            wIm += tempW3 * wpIm + wIm * wpRe;
                        }
                        k = (kk += ks) + ks;
                    } while (kk < memAmount);
                    if (j == memAmount) {
                        audioFiles[indices[2]].write(buf1, 0, memAmount);
                        audioFiles[indices[3]].write(buf2, 0, memAmount);
                        j = 0;
                    }
                    ++step;
                }
                indices[0] = indexMap[indices[0]];
            }
            this.rewind$1(audioFiles, tempFiles, indices);
        } while ((jk >>= 1) > 1L);
    }

    private final void rewind$1(FileBuffer[] audioFiles$1, File[] tempFiles$1, int[] indices$1) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])audioFiles$1)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.rewind();
            return BoxedUnit.UNIT;
        });
        this.swap(audioFiles$1, 1, 3);
        this.swap(audioFiles$1, 0, 2);
        this.swap(tempFiles$1, 1, 3);
        this.swap(tempFiles$1, 0, 2);
        indices$1[0] = 2;
        indices$1[1] = 3;
        indices$1[2] = 0;
        indices$1[3] = 1;
    }

    private Fourier$() {
        MODULE$ = this;
    }
}

