/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import akka.stream.Attributes;
import akka.stream.FanInShape14;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.stage.OutHandler;
import de.sciss.fscape.Util$;
import de.sciss.fscape.graph.BinaryOp;
import de.sciss.fscape.graph.BinaryOp$Op$;
import de.sciss.fscape.package$;
import de.sciss.fscape.stream.BufD;
import de.sciss.fscape.stream.BufI;
import de.sciss.fscape.stream.BufLike;
import de.sciss.fscape.stream.Builder;
import de.sciss.fscape.stream.Control;
import de.sciss.fscape.stream.Node;
import de.sciss.fscape.stream.PenImage$;
import de.sciss.fscape.stream.impl.NodeImpl;
import de.sciss.fscape.stream.impl.StageImpl;
import de.sciss.numbers.Implicits$;
import de.sciss.numbers.IntFunctions$;
import de.sciss.numbers.RichDouble;
import de.sciss.numbers.RichInt$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015s!\u0002,X\u0011\u0003\u0001g!\u00022X\u0011\u0003\u0019\u0007\"\u00026\u0002\t\u0003Y\u0007\"\u00027\u0002\t\u0003i\u0007\"CA\u001b\u0003\t\u0007IQBA\u001c\u0011!\ti$\u0001Q\u0001\u000e\u0005eRABA \u0003\u0011\t\tE\u0002\u0004\u0002\\\u00051\u0011Q\f\u0005\u000b\u0003_:!\u0011!Q\u0001\n\u0005E\u0004BCA<\u000f\t\u0005\t\u0015a\u0003\u0002z!1!n\u0002C\u0001\u0003\u007fB\u0011\"!#\b\u0005\u0004%\t!a#\t\u0011\u00055u\u0001)A\u0005\u0003\u0003Bq!a$\b\t\u0003\t\tJ\u0002\u0004\u0002\u0016\u00061\u0011q\u0013\u0005\r\u0003\u0013s!\u0011!Q\u0001\n\u0005-\u00141\u0016\u0005\r\u0003_r!\u0011!Q\u0001\n\u0005E\u0014Q\u0016\u0005\r\u0003or!\u0011!Q\u0001\f\u0005e\u0014q\u0016\u0005\u0007U:!\t!a-\t\u0011\u0005uf\u0002)Q\u0005\u0003\u007fC\u0001\"!2\u000fA\u0003&\u0011q\u0019\u0005\t\u0003\u001bt\u0001\u0015)\u0003\u0002@\"A\u0011q\u001a\b!B\u0013\t9\r\u0003\u0005\u0002R:\u0001\u000b\u0015BA`\u0011!\t\u0019N\u0004Q!\n\u0005\u001d\u0007bCA\u0003\u001d\u0001\u0007\t\u0011)Q\u0005\u0003\u007fC1\"a\u0004\u000f\u0001\u0004\u0005\t\u0015)\u0003\u0002@\"Y\u0011q\u0004\bA\u0002\u0003\u0005\u000b\u0015BA`\u0011-\t\u0019C\u0004a\u0001\u0002\u0003\u0006K!!6\t\u0017\u0005\u001db\u00021A\u0001B\u0003&\u0011q\u0019\u0005\f\u0003Wq\u0001\u0019!A!B\u0013\ti\u0010C\u0006\u000209\u0001\r\u0011!Q!\n\u0005u\bbCA\u001a\u001d\u0001\u0007\t\u0011)Q\u0005\u0003\u007fC\u0001Ba\u0001\u000fA\u0003%!Q\u0001\u0005\t\u0005#r\u0001\u0015!\u0003\u0003\u0006!A!1\u000b\b!\u0002\u0013\u0011)\u0001\u0003\u0005\u0003V9\u0001\u000b\u0011\u0002B\u0003\u0011!\u00119F\u0004Q\u0001\n\te\u0003\u0002\u0003B.\u001d\u0001\u0006IA!\u0018\t\u0011\tmd\u0002)A\u0005\u0005{B\u0001Ba'\u000fA\u0003%!Q\u0010\u0005\t\u0005;s\u0001\u0015!\u0003\u0003~!A!q\u0014\b!\u0002\u0013\u0011i\b\u0003\u0005\u0003\":\u0001\u000b\u0011\u0002B?\u0011!\u0011\u0019K\u0004Q\u0001\n\t\u0015\u0006\u0002\u0003BT\u001d\u0001\u0006IA!*\t\u0011\t%f\u0002)A\u0005\u0005{B\u0001Ba+\u000fA\u0003%!Q\u0016\u0005\t\u0005\u0007t\u0001\u0015!\u0003\u0003F\"A!q\u001b\b!B\u0013\ty\fC\u0006\u0003Z:\u0001\r\u0011!Q!\n\tm\u0007\u0002CAS\u001d\u0001\u0006K!a0\t\u0011\tug\u0002)Q\u0005\u0003\u007fCqAa8\u000f\t#\u0012I\u0005C\u0004\u0003b:!IA!\u0013\u0007\r\t}dB\u0002BA\u0011)\u0011Id\u000eB\u0001B\u0003%!1\u0013\u0005\u0007U^\"\tA!&\t\u000f\t\u001ds\u0007\"\u0005\u0003J\u00191!\u0011\u0002\b\u0007\u0005\u0017A!B!\u000f<\u0005\u0003\u0005\u000b\u0011\u0002B\u001e\u0011\u0019Q7\b\"\u0001\u0003B!9!qI\u001e\u0005\u0012\t%cA\u0002B0\u001d\u0019\u0011\t\u0007\u0003\u0006\u0003:}\u0012\t\u0011)A\u0005\u0005gBaA[ \u0005\u0002\tU\u0004b\u0002B$\u007f\u0011E!\u0011\n\u0005\b\u0005GtA\u0011\u0001B%\u0011\u001d\u0011)O\u0004C!\u0005ODqA!@\u000f\t\u0013\u0011I\u0005C\u0004\u0003\u0000:!IA!\u0013\t\u000f\r\u0005a\u0002\"\u0003\u0003J!911\u0001\b\u0005\n\t%\u0003bBB\u0003\u001d\u0011%!\u0011\n\u0005\b\u0007\u000fqA\u0011\u0002B%\u0011\u001d\u0019IA\u0004C\u0005\u0005\u0013Bqaa\u0003\u000f\t\u0013\u0011I\u0005\u0003\u0005\u0004\u000e9\u0001\u000b\u0015BAd\u0011-\u0019yA\u0004a\u0001\u0002\u0003\u0006K!a\u0014\t\u0011\rEa\u0002)Q\u0005\u0003\u007fC\u0001ba\u0005\u000fA\u0003&\u0011q\u0018\u0005\b\u0007+qA\u0011\u0002B%\u0011\u001d\u00199B\u0004C\u0005\u0005\u0013Bqa!\u0007\u000f\t\u0013\u0011I\u0005C\u0004\u0004\u001c9!Ia!\b\t\u000f\r=b\u0002\"\u0003\u00042\u0005A\u0001+\u001a8J[\u0006<WM\u0003\u0002Y3\u000611\u000f\u001e:fC6T!AW.\u0002\r\u0019\u001c8-\u00199f\u0015\taV,A\u0003tG&\u001c8OC\u0001_\u0003\t!Wm\u0001\u0001\u0011\u0005\u0005\fQ\"A,\u0003\u0011A+g.S7bO\u0016\u001c\"!\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001-A\u0003baBd\u0017\u0010\u0006\u000eowv|\u00181AA\u0007\u0003#\t)\"!\u0007\u0002\u001e\u0005\u0005\u0012QEA\u0015\u0003[\t\t\u0004\u0006\u0002pmB\u0011\u0001o\u001d\b\u0003CFL!A],\u0002\u000fA\f7m[1hK&\u0011A/\u001e\u0002\u0005\u001fV$HI\u0003\u0002s/\")qo\u0001a\u0002q\u0006\t!\r\u0005\u0002bs&\u0011!p\u0016\u0002\b\u0005VLG\u000eZ3s\u0011\u0015a8\u00011\u0001p\u0003\r\u0019(o\u0019\u0005\u0006}\u000e\u0001\ra\\\u0001\u0006C2\u0004\b.\u0019\u0005\u0007\u0003\u0003\u0019\u0001\u0019A8\u0002\u0007\u0011\u001cH\u000fC\u0004\u0002\u0006\r\u0001\r!a\u0002\u0002\u000b]LG\r\u001e5\u0011\u0007A\fI!C\u0002\u0002\fU\u0014AaT;u\u0013\"9\u0011qB\u0002A\u0002\u0005\u001d\u0011A\u00025fS\u001eDG\u000f\u0003\u0004\u0002\u0014\r\u0001\ra\\\u0001\u0002q\"1\u0011qC\u0002A\u0002=\f\u0011!\u001f\u0005\b\u00037\u0019\u0001\u0019AA\u0004\u0003\u0011qW\r\u001f;\t\u000f\u0005}1\u00011\u0001\u0002\b\u0005!!/\u001e7f\u0011\u001d\t\u0019c\u0001a\u0001\u0003\u000f\t!a\u001c9\t\u000f\u0005\u001d2\u00011\u0001\u0002\b\u0005!qO]1q\u0011\u0019\tYc\u0001a\u0001_\u00069!o\u001c7m\u001f\u001a4\u0007BBA\u0018\u0007\u0001\u0007q.\u0001\u0006lC&\u001cXM\u001d\"fi\u0006Dq!a\r\u0004\u0001\u0004\t9!A\u0007{KJ|7I]8tg&twm]\u0001\u0005]\u0006lW-\u0006\u0002\u0002:=\u0011\u00111H\u0011\u0002-\u0006)a.Y7fA\t)1\u000b[1qKB\u0011\u00131IA&\u0003\u001f\ny%a\u0014\u0002V\u0005U\u0013qJA(\u0003+\n)&!\u0016\u0002V\u0005=\u0013qJA+\u0003\u001fj!!!\u0012\u000b\u0007a\u000b9E\u0003\u0002\u0002J\u0005!\u0011m[6b\u0013\u0011\ti%!\u0012\u0003\u0019\u0019\u000bg.\u00138TQ\u0006\u0004X-\r\u001b\u0011\u0007\u0005\f\t&C\u0002\u0002T]\u0013AAQ;g\tB\u0019\u0011-a\u0016\n\u0007\u0005esK\u0001\u0003Ck\u001aL%!B*uC\u001e,7cA\u0004\u0002`A1\u0011\u0011MA4\u0003Wj!!a\u0019\u000b\u0007\u0005\u0015t+\u0001\u0003j[Bd\u0017\u0002BA5\u0003G\u0012\u0011b\u0015;bO\u0016LU\u000e\u001d7\u0011\u0007\u00055d!D\u0001\u0002\u0003\u0015a\u0017-_3s!\r\u0001\u00181O\u0005\u0004\u0003k*(!\u0002'bs\u0016\u0014\u0018\u0001B2ue2\u00042!YA>\u0013\r\tih\u0016\u0002\b\u0007>tGO]8m)\u0011\t\t)a\"\u0015\t\u0005\r\u0015Q\u0011\t\u0004\u0003[:\u0001bBA<\u0015\u0001\u000f\u0011\u0011\u0010\u0005\b\u0003_R\u0001\u0019AA9\u0003\u0015\u0019\b.\u00199f+\t\t\t%\u0001\u0004tQ\u0006\u0004X\rI\u0001\fGJ,\u0017\r^3M_\u001eL7\r\u0006\u0003\u0002\u0014\u000em\u0002cAA7\u001d\t)Aj\\4jGN)a\"!'\u0002 B1\u0011\u0011MAN\u0003WJA!!(\u0002d\tAaj\u001c3f\u00136\u0004H\u000e\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\u0011\t)+!\u0012\u0002\u000bM$\u0018mZ3\n\t\u0005%\u00161\u0015\u0002\u000b\u001fV$\b*\u00198eY\u0016\u0014\u0018\u0002BAE\u00037KA!a\u001c\u0002\u001c&!\u0011\u0011WAN\u0003\u001d\u0019wN\u001c;s_2$b!!.\u0002:\u0006mF\u0003BAJ\u0003oCq!a\u001e\u0013\u0001\b\tI\bC\u0004\u0002\nJ\u0001\r!a\u001b\t\u000f\u0005=$\u00031\u0001\u0002r\u0005Q\u0011-\u001e=ECR\f'+Z7\u0011\u0007\u0015\f\t-C\u0002\u0002D\u001a\u00141!\u00138u\u00031\tW\u000f\u001f#bi\u0006\u0014V-\u00193z!\r)\u0017\u0011Z\u0005\u0004\u0003\u00174'a\u0002\"p_2,\u0017M\\\u0001\u000bIN$H)\u0019;b%\u0016l\u0017\u0001\u00043ti\u0012\u000bG/\u0019*fC\u0012L\u0018A\u00039f]\u0012\u000bG/\u0019*f[\u0006a\u0001/\u001a8ECR\f'+Z1esB!\u0011q[A|\u001d\u0011\tI.!=\u000f\t\u0005m\u0017Q\u001e\b\u0005\u0003;\fYO\u0004\u0003\u0002`\u0006%h\u0002BAq\u0003Ol!!a9\u000b\u0007\u0005\u0015x,\u0001\u0004=e>|GOP\u0005\u0002=&\u0011A,X\u0005\u00035nK1!a<Z\u0003\u00159'/\u00199i\u0013\u0011\t\u00190!>\u0002\u0011\tKg.\u0019:z\u001fBT1!a<Z\u0013\u0011\tI0a?\u0003\u0005=\u0003(\u0002BAz\u0003k\u00042!ZA\u0000\u0013\r\u0011\tA\u001a\u0002\u0007\t>,(\r\\3\u0002\t!\u001c&o\u0019\t\b\u0005\u000fY\u0014Q`A(\u001b\u0005q!\u0001\u0004)f]&s\u0007*\u00198eY\u0016\u0014XC\u0002B\u0007\u00053\u0011icE\u0002<\u0005\u001f\u0001\u0002Ba\u0002\u0003\u0012\tU!1F\u0005\u0005\u0005'\tYJA\u0007J]\"\u000bg\u000e\u001a7fe&k\u0007\u000f\u001c\t\u0005\u0005/\u0011I\u0002\u0004\u0001\u0005\u000f\tm1H1\u0001\u0003\u001e\t\t\u0011)\u0005\u0003\u0003 \t\u0015\u0002cA3\u0003\"%\u0019!1\u00054\u0003\u000f9{G\u000f[5oOB\u0019QMa\n\n\u0007\t%bMA\u0002B]f\u0004BAa\u0006\u0003.\u00119!qF\u001eC\u0002\tE\"!A#\u0012\t\t}!1\u0007\t\u0006a\nU\"QC\u0005\u0004\u0005o)(a\u0002\"vM\u0016cW-\\\u0001\u0003S:\u0004b!a\u0011\u0003>\t-\u0012\u0002\u0002B \u0003\u000b\u0012Q!\u00138mKR$BAa\u0011\u0003FA9!qA\u001e\u0003\u0016\t-\u0002b\u0002B\u001d{\u0001\u0007!1H\u0001\f]>$\u0018NZ=WC2,X\r\u0006\u0002\u0003LA\u0019QM!\u0014\n\u0007\t=cM\u0001\u0003V]&$\u0018A\u00025BYBD\u0017-\u0001\u0002i1\u0006\u0011\u0001.W\u0001\u0006Q:+\u0007\u0010\u001e\t\b\u0005\u000fY\u0014qXA+\u0003\u0011AGi\u001d;\u0011\u000f\t\u001dq(!@\u0002P\taAi\u001d;J]\"\u000bg\u000e\u001a7feV1!1\rB5\u0005[\u001a2a\u0010B3!!\u00119A!\u0005\u0003h\t-\u0004\u0003\u0002B\f\u0005S\"qAa\u0007@\u0005\u0004\u0011i\u0002\u0005\u0003\u0003\u0018\t5Da\u0002B\u0018\u007f\t\u0007!qN\t\u0005\u0005?\u0011\t\bE\u0003q\u0005k\u00119\u0007\u0005\u0004\u0002D\tu\"1\u000e\u000b\u0005\u0005o\u0012I\bE\u0004\u0003\b}\u00129Ga\u001b\t\u000f\te\u0012\t1\u0001\u0003t\u00051\u0001nV5ei\"\u0004rAa\u00028\u0003\u007f\u000b)F\u0001\u0007BkbLe\u000eS1oI2,'/\u0006\u0004\u0003\u0004\n%%QR\n\u0004o\t\u0015\u0005\u0003\u0003B\u0004\u0005#\u00119Ia#\u0011\t\t]!\u0011\u0012\u0003\b\u000579$\u0019\u0001B\u000f!\u0011\u00119B!$\u0005\u000f\t=rG1\u0001\u0003\u0010F!!q\u0004BI!\u0015\u0001(Q\u0007BD!\u0019\t\u0019E!\u0010\u0003\fR!!q\u0013BM!\u001d\u00119a\u000eBD\u0005\u0017CqA!\u000f:\u0001\u0004\u0011\u0019*A\u0004i\u0011\u0016Lw\r\u001b;\u0002\u000b!\u0014V\u000f\\3\u0002\u0007!|\u0005/A\u0003i/J\f\u0007/\u0001\u0005i%>dGn\u00144g!\u001d\u00119aNA\u007f\u0003\u001f\n1\u0002[&bSN,'OQ3uC\u0006q\u0001NW3s_\u000e\u0013xn]:j]\u001e\u001c\u0018!\u00049f]&s\u0007*\u00198eY\u0016\u00148\u000fE\u0003f\u0005_\u0013\u0019,C\u0002\u00032\u001a\u0014Q!\u0011:sCf\u0004dA!.\u0003:\n}\u0006c\u0002B\u0004w\t]&Q\u0018\t\u0005\u0005/\u0011I\fB\u0006\u0003<>\n\t\u0011!A\u0003\u0002\tu!aA0%cA!!q\u0003B`\t-\u0011\tmLA\u0001\u0002\u0003\u0015\tA!\b\u0003\u0007}##'A\u0007bkbLe\u000eS1oI2,'o\u001d\t\u0006K\n=&q\u0019\u0019\u0007\u0005\u0013\u0014iMa5\u0011\u0011\t\u001d!\u0011\u0003Bf\u0005#\u0004BAa\u0006\u0003N\u0012Y!q\u001a\u0019\u0002\u0002\u0003\u0005)\u0011\u0001B\u000f\u0005\ryFe\r\t\u0005\u0005/\u0011\u0019\u000eB\u0006\u0003VB\n\t\u0011!A\u0003\u0002\tu!aA0%i\u0005IaM]1nKNK'0Z\u0001\tMJ\fW.\u001a\"vMB)QMa,\u0002~\u0006QAm\u001d;Xe&$H/\u001a8\u0002\u000fM$x\u000e\u001d9fI\u0006iaM]3f\u001fV$()\u001e4gKJ\faa\u001c8Qk2d\u0017AE8o\t><hn\u001d;sK\u0006lg)\u001b8jg\"$BAa\u0013\u0003j\"9!1\u001e#A\u0002\t5\u0018!B2bkN,\u0007\u0003\u0002Bx\u0005otAA!=\u0003v:!\u0011\u0011\u001dBz\u0013\u00059\u0017B\u0001:g\u0013\u0011\u0011IPa?\u0003\u0013QC'o\\<bE2,'B\u0001:g\u0003I\u0011X-];fgRtU\r\u001f;Bkb$\u0015\r^1\u0002%I,\u0017/^3ti:+\u0007\u0010\u001e#ti\u0012\u000bG/Y\u0001\u0013e\u0016\fX/Z:u\u001d\u0016DH\u000fU3o\t\u0006$\u0018-\u0001\no_RLg-_!vq\u0012\u000bG/\u0019*fC\u0012L\u0018A\u00058pi&4\u0017\u0010R:u\t\u0006$\u0018MU3bIf\f!C\\8uS\u001aL\b+\u001a8ECR\f'+Z1es\u0006q\u0001O]8dKN\u001c\u0018)\u001e=ECR\f\u0017A\u00049s_\u000e,7o\u001d#ti\u0012\u000bG/Y\u0001\u0006]\u0016DH\u000fU\u0001\u0007EV4w*\u001e;\u0002\r=,Ho\u00144g\u0003)yW\u000f^,sSR$XM\\\u0001\u000faJ|7-Z:t!\u0016tG)\u0019;b\u00039\u0001(o\\2fgN|U\u000f\u001e#bi\u0006\f\u0001b\u001e:ji\u0016|U\u000f^\u0001\nG\u0006d7MV1mk\u0016$\"\"!@\u0004 \r\r2qEB\u0016\u0011\u001d\u0019\t\u0003\u0016a\u0001\u0003{\f!aQ:\t\u000f\r\u0015B\u000b1\u0001\u0002~\u0006\u0011\u0011i\u001d\u0005\b\u0007S!\u0006\u0019AA\u007f\u0003\t\u0019E\rC\u0004\u0004.Q\u0003\r!!@\u0002\u0003]\fq\u0001\u001d:pG\u0016\u001c8\u000f\u0006\u0006\u0003L\rM2QGB\u001c\u0007sAq!a\u0005V\u0001\u0004\ti\u0010C\u0004\u0002\u0018U\u0003\r!!@\t\u000f\r\u0005R\u000b1\u0001\u0002~\"91QE+A\u0002\u0005u\bbBB\u001f\u001b\u0001\u00071qH\u0001\u0005CR$(\u000f\u0005\u0003\u0002D\r\u0005\u0013\u0002BB\"\u0003\u000b\u0012!\"\u0011;ue&\u0014W\u000f^3t\u0001")
public final class PenImage {
    public static Outlet<BufD> apply(Outlet<BufD> outlet, Outlet<BufD> outlet2, Outlet<BufD> outlet3, Outlet<BufI> outlet4, Outlet<BufI> outlet5, Outlet<BufD> outlet6, Outlet<BufD> outlet7, Outlet<BufI> outlet8, Outlet<BufI> outlet9, Outlet<BufI> outlet10, Outlet<BufI> outlet11, Outlet<BufD> outlet12, Outlet<BufD> outlet13, Outlet<BufI> outlet14, Builder builder) {
        return PenImage$.MODULE$.apply(outlet, outlet2, outlet3, outlet4, outlet5, outlet6, outlet7, outlet8, outlet9, outlet10, outlet11, outlet12, outlet13, outlet14, builder);
    }

    public static final class Logic
    extends NodeImpl<FanInShape14<BufD, BufD, BufD, BufI, BufI, BufD, BufD, BufI, BufI, BufI, BufI, BufD, BufD, BufI, BufD>>
    implements OutHandler {
        public int de$sciss$fscape$stream$PenImage$Logic$$auxDataRem;
        private boolean auxDataReady;
        public int de$sciss$fscape$stream$PenImage$Logic$$dstDataRem;
        private boolean dstDataReady;
        public int de$sciss$fscape$stream$PenImage$Logic$$penDataRem;
        private boolean penDataReady;
        private int width;
        private int height;
        private int rule;
        private BinaryOp.Op op;
        private boolean wrap;
        private double rollOff;
        private double kaiserBeta;
        private int zeroCrossings;
        private final PenInHandler<Object, BufD> hSrc;
        private final PenInHandler<Object, BufD> hAlpha;
        private final PenInHandler<Object, BufD> hX;
        private final PenInHandler<Object, BufD> hY;
        private final PenInHandler<Object, BufI> hNext;
        private final DstInHandler<Object, BufD> hDst;
        private final AuxInHandler<Object, BufI> hWidth;
        private final AuxInHandler<Object, BufI> hHeight;
        private final AuxInHandler<Object, BufI> hRule;
        private final AuxInHandler<Object, BufI> hOp;
        private final AuxInHandler<Object, BufI> hWrap;
        private final AuxInHandler<Object, BufD> hRollOff;
        private final AuxInHandler<Object, BufD> hKaiserBeta;
        private final AuxInHandler<Object, BufI> hZeroCrossings;
        private final PenInHandler<?, ?>[] penInHandlers;
        private final NodeImpl.InHandlerImpl<?, ?>[] auxInHandlers;
        private int frameSize;
        private double[] frameBuf;
        private int stage;
        private int dstWritten;
        private boolean nextP;
        private BufD bufOut;
        private int outOff;
        private int outWritten;

        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this);
        }

        @Override
        public void stopped() {
            Node.stopped$(this);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.auxInHandlers)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.freeBuffer();
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.penInHandlers)).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.freeBuffer();
                return BoxedUnit.UNIT;
            });
            this.frameBuf = null;
            this.freeOutBuffer();
        }

        private void freeOutBuffer() {
            block0: {
                if (this.bufOut == null) break block0;
                this.bufOut.release(super.control());
                this.bufOut = null;
            }
        }

        public void onPull() {
            block0: {
                package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("onPull() ").append(this).toString());
                if (this.stage != 3) break block0;
                this.processOutData();
            }
        }

        public void onDownstreamFinish(Throwable cause) {
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("onDownstreamFinish() ").append(this).toString());
            OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
        }

        private void requestNextAuxData() {
            block2: {
                package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "requestNextAuxData");
                Predef$.MODULE$.assert(this.stage == 0);
                Predef$.MODULE$.assert(!this.auxDataReady);
                if (this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem != 0) break block2;
                this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.auxInHandlers)).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.hasNext()));
                if (this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem > 0) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.auxInHandlers)).foreach((Function1 & Serializable & scala.Serializable)h -> {
                        Logic.$anonfun$requestNextAuxData$3(h);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    this.de$sciss$fscape$stream$PenImage$Logic$$notifyAuxDataReady();
                }
            }
        }

        private void requestNextDstData() {
            block2: {
                package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "requestNextDstData");
                Predef$.MODULE$.assert(this.stage == 1);
                Predef$.MODULE$.assert(!this.dstDataReady);
                if (this.de$sciss$fscape$stream$PenImage$Logic$$dstDataRem != 0) break block2;
                if (this.hDst.hasNext()) {
                    this.de$sciss$fscape$stream$PenImage$Logic$$dstDataRem = 1;
                    this.hDst.next();
                } else {
                    this.de$sciss$fscape$stream$PenImage$Logic$$notifyDstDataReady();
                }
            }
        }

        private void requestNextPenData() {
            block2: {
                package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "requestNextPenData");
                Predef$.MODULE$.assert(this.stage == 2);
                Predef$.MODULE$.assert(!this.penDataReady);
                if (this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem != 0) break block2;
                this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.penInHandlers)).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.hasNext()));
                if (this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem > 0) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.penInHandlers)).foreach((Function1 & Serializable & scala.Serializable)h -> {
                        Logic.$anonfun$requestNextPenData$3(h);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    this.de$sciss$fscape$stream$PenImage$Logic$$notifyPenDataReady();
                }
            }
        }

        public void de$sciss$fscape$stream$PenImage$Logic$$notifyAuxDataReady() {
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "notifyAuxDataReady");
            Predef$.MODULE$.assert(!this.auxDataReady);
            if (this.stage == 0) {
                this.processAuxData();
            } else {
                this.auxDataReady = true;
            }
        }

        public void de$sciss$fscape$stream$PenImage$Logic$$notifyDstDataReady() {
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "notifyDstDataReady");
            Predef$.MODULE$.assert(!this.dstDataReady);
            if (this.stage == 1) {
                this.processDstData();
            } else {
                this.dstDataReady = true;
            }
        }

        public void de$sciss$fscape$stream$PenImage$Logic$$notifyPenDataReady() {
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "notifyPenDataReady");
            Predef$.MODULE$.assert(!this.penDataReady);
            if (this.stage == 2) {
                this.processPenData();
            } else {
                this.penDataReady = true;
            }
        }

        private void processAuxData() {
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "processAuxData");
            Predef$.MODULE$.assert(this.stage == 0);
            this.width = scala.runtime.RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(this.hWidth.takeValue())), 1);
            this.height = scala.runtime.RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(this.hHeight.takeValue())), 1);
            this.rule = RichInt$.MODULE$.clip$extension(Implicits$.MODULE$.intNumberWrapper(BoxesRunTime.unboxToInt(this.hRule.takeValue())), 1, 12);
            this.op = BinaryOp$Op$.MODULE$.apply(RichInt$.MODULE$.clip$extension(Implicits$.MODULE$.intNumberWrapper(BoxesRunTime.unboxToInt(this.hOp.takeValue())), 0, 100));
            this.wrap = BoxesRunTime.unboxToInt(this.hWrap.takeValue()) != 0;
            this.rollOff = new RichDouble(Implicits$.MODULE$.doubleNumberWrapper(BoxesRunTime.unboxToDouble(this.hRollOff.takeValue()))).clip(0.0, 1.0);
            this.kaiserBeta = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble(this.hKaiserBeta.takeValue())), 0.0);
            this.zeroCrossings = scala.runtime.RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(this.hZeroCrossings.takeValue())), 0);
            int newFrameSize = this.width * this.height;
            if (this.frameSize != newFrameSize) {
                this.frameSize = newFrameSize;
                this.frameBuf = new double[newFrameSize];
            }
            this.stage = 1;
            if (this.dstDataReady) {
                this.dstDataReady = false;
                this.processDstData();
            } else {
                this.requestNextDstData();
            }
        }

        private void processDstData() {
            int n;
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "processDstData");
            Predef$.MODULE$.assert(this.stage == 1);
            int dstRem = this.hDst.bufRemain();
            int frameRem = this.frameSize - this.dstWritten;
            if (dstRem == 0) {
                Util$.MODULE$.fill(this.frameBuf, this.dstWritten, frameRem, BoxesRunTime.unboxToDouble(this.hDst.takeValue()));
                n = frameRem;
            } else {
                BufD b = (BufD)this.hDst.buf();
                int _chunk = scala.math.package$.MODULE$.min(dstRem, frameRem);
                int dstOff = this.hDst.offset();
                Util$.MODULE$.copy(b.buf(), dstOff, this.frameBuf, this.dstWritten, _chunk);
                this.hDst.updateOffset(dstOff + _chunk);
                n = _chunk;
            }
            int chunk = n;
            this.dstWritten += chunk;
            if (this.dstWritten < this.frameSize) {
                this.requestNextDstData();
            } else {
                this.stage = 2;
                if (this.penDataReady) {
                    this.penDataReady = false;
                    this.processPenData();
                } else {
                    this.requestNextPenData();
                }
            }
        }

        private void processPenData() {
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "processPenData");
            Predef$.MODULE$.assert(this.stage == 2);
            int srcRem = this.hSrc.bufRemain();
            int alphaRem = this.hAlpha.bufRemain();
            int xRem = this.hX.bufRemain();
            int yRem = this.hY.bufRemain();
            int nextRem = this.hNext.bufRemain();
            boolean next = false;
            double src = 0.0;
            double alpha = 0.0;
            double x = 0.0;
            double y = 0.0;
            int chunk = Integer.MAX_VALUE;
            if (srcRem > 0 && srcRem < chunk) {
                chunk = srcRem;
            }
            if (alphaRem > 0 && alphaRem < chunk) {
                chunk = alphaRem;
            }
            if (xRem > 0 && xRem < chunk) {
                chunk = xRem;
            }
            if (yRem > 0 && yRem < chunk) {
                chunk = yRem;
            }
            if (nextRem > 0 && nextRem < chunk) {
                chunk = nextRem;
            }
            if (!this.hSrc.hasNext()) {
                this.goToOut$1();
                return;
            }
            Predef$.MODULE$.assert(chunk < Integer.MAX_VALUE);
            while (chunk > 0) {
                boolean bl = next = BoxesRunTime.unboxToInt(this.hNext.peekValue()) != 0;
                if (!this.nextP && next) {
                    this.goToOut$1();
                    return;
                }
                this.hNext.skipValue();
                src = BoxesRunTime.unboxToDouble(this.hSrc.takeValue());
                alpha = BoxesRunTime.unboxToDouble(this.hAlpha.takeValue());
                x = BoxesRunTime.unboxToDouble(this.hX.takeValue());
                y = BoxesRunTime.unboxToDouble(this.hY.takeValue());
                this.process(x, y, src, alpha);
                --chunk;
                this.nextP = next;
            }
            this.requestNextPenData();
        }

        private void processOutData() {
            block6: {
                package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "processOutData");
                Predef$.MODULE$.assert(this.stage == 3);
                if (this.bufOut == null) {
                    this.bufOut = super.control().borrowBufD();
                }
                int chunk = scala.math.package$.MODULE$.min(this.bufOut.size() - this.outOff, this.frameSize - this.outWritten);
                Util$.MODULE$.copy(this.frameBuf, this.outWritten, this.bufOut.buf(), this.outOff, chunk);
                this.outOff += chunk;
                this.outWritten += chunk;
                if (this.outOff == this.bufOut.size()) {
                    this.writeOut();
                }
                if (this.outWritten != this.frameSize) break block6;
                if (this.hSrc.hasNext()) {
                    this.stage = 0;
                    if (this.auxDataReady) {
                        this.auxDataReady = false;
                        this.processAuxData();
                    } else {
                        this.requestNextAuxData();
                    }
                } else {
                    this.writeOut();
                    this.completeStage();
                }
            }
        }

        private void writeOut() {
            package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "writeOut");
            if (this.outOff > 0) {
                this.bufOut.size_$eq(this.outOff);
                this.push(((FanInShape14)super.shape()).out(), this.bufOut);
                this.outOff = 0;
                this.bufOut = null;
            } else {
                this.freeOutBuffer();
            }
        }

        private double calcValue(double Cs, double As, double Cd, double w) {
            double d;
            int n = this.rule;
            switch (n) {
                case 1: {
                    d = 0.0;
                    break;
                }
                case 2: 
                case 5: {
                    d = Cs * w;
                    break;
                }
                case 4: 
                case 9: {
                    d = Cd;
                    break;
                }
                case 3: {
                    d = this.op.apply(Cs * w, Cd * (1.0 - As * w));
                    break;
                }
                case 7: {
                    d = this.op.apply(Cs * w, Cd);
                    break;
                }
                case 6: 
                case 11: {
                    d = Cd * (As * w);
                    break;
                }
                case 8: {
                    d = Cd * (1.0 - As * w);
                    break;
                }
                case 12: {
                    d = this.op.apply(Cd, Cs * w);
                    break;
                }
                case 10: {
                    d = this.op.apply(Cd * (1.0 - As * w), Cs * w);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            return d;
        }

        private void process(double x, double y, double Cs, double As) {
            double[] _winBuf = this.frameBuf;
            int _width = this.width;
            int _height = this.height;
            boolean _wrap = this.wrap;
            double xq = scala.math.package$.MODULE$.abs(x) % 1.0;
            int xTi = (int)x;
            double yq = scala.math.package$.MODULE$.abs(y) % 1.0;
            int yTi = (int)y;
            if (this.zeroCrossings == 0) {
                int y1;
                int w1 = _width - 1;
                int h1 = _height - 1;
                int x1 = _wrap ? IntFunctions$.MODULE$.wrap(xTi, 0, w1) : xTi;
                int n = y1 = _wrap ? IntFunctions$.MODULE$.wrap(yTi, 0, h1) : yTi;
                if (xq < 1.0E-20 && yq < 1.0E-20) {
                    if (_wrap || x1 >= 0 && x1 <= w1 && y1 >= 0 && y1 <= h1) {
                        double Cr;
                        int winBufOff = y1 * _width + x1;
                        double Cd = _winBuf[winBufOff];
                        _winBuf[winBufOff] = Cr = this.calcValue(Cs, As, Cd, 1.0);
                    }
                } else {
                    int y3;
                    int x3;
                    int y2;
                    int x2;
                    int y0;
                    int x0;
                    int n2 = x1 > 0 ? x1 - 1 : (x0 = _wrap ? w1 : x1 - 1);
                    int n3 = y1 > 0 ? y1 - 1 : (y0 = _wrap ? h1 : y1 - 1);
                    int n4 = x1 < w1 ? x1 + 1 : (x2 = _wrap ? 0 : x1 + 1);
                    int n5 = y1 < h1 ? y1 + 1 : (y2 = _wrap ? 0 : y1 + 1);
                    int n6 = x2 < w1 ? x2 + 1 : (x3 = _wrap ? 0 : x2 + 1);
                    int n7 = y2 < h1 ? y2 + 1 : (y3 = _wrap ? 0 : y2 + 1);
                    if (_wrap || x0 >= 0 && x3 <= w1 && y0 >= 0 && y3 <= h1) {
                        int y0s = y0 * _width;
                        int y1s = y1 * _width;
                        int y2s = y2 * _width;
                        int y3s = y3 * _width;
                        int p00 = y0s + x0;
                        int p10 = y0s + x1;
                        int p20 = y0s + x2;
                        int p30 = y0s + x3;
                        int p01 = y1s + x0;
                        int p11 = y1s + x1;
                        int p21 = y1s + x2;
                        int p31 = y1s + x3;
                        int p02 = y2s + x0;
                        int p12 = y2s + x1;
                        int p22 = y2s + x2;
                        int p32 = y2s + x3;
                        int p03 = y3s + x0;
                        int p13 = y3s + x1;
                        int p23 = y3s + x2;
                        int p33 = y3s + x3;
                        double t = xq;
                        double tt = t * t;
                        double ttt = tt * t;
                        double s = yq;
                        double ss = s * s;
                        double sss = ss * s;
                        double wx0 = (-t + (double)2 * tt - ttt) * 0.5;
                        double wx1 = ((double)2 - (double)5 * tt + (double)3 * ttt) * 0.5;
                        double wx2 = (t + (double)4 * tt - (double)3 * ttt) * 0.5;
                        double wx3 = (-tt + ttt) * 0.5;
                        double wy0 = (-s + (double)2 * ss - sss) * 0.5;
                        double wy1 = ((double)2 - (double)5 * ss + (double)3 * sss) * 0.5;
                        double wy2 = (s + (double)4 * ss - (double)3 * sss) * 0.5;
                        double wy3 = (-ss + sss) * 0.5;
                        _winBuf[p00] = this.calcValue(Cs, As, _winBuf[p00], wx0 * wy0);
                        _winBuf[p10] = this.calcValue(Cs, As, _winBuf[p10], wx1 * wy0);
                        _winBuf[p20] = this.calcValue(Cs, As, _winBuf[p20], wx2 * wy0);
                        _winBuf[p30] = this.calcValue(Cs, As, _winBuf[p30], wx3 * wy0);
                        _winBuf[p01] = this.calcValue(Cs, As, _winBuf[p01], wx0 * wy1);
                        _winBuf[p11] = this.calcValue(Cs, As, _winBuf[p11], wx1 * wy1);
                        _winBuf[p21] = this.calcValue(Cs, As, _winBuf[p21], wx2 * wy1);
                        _winBuf[p31] = this.calcValue(Cs, As, _winBuf[p31], wx3 * wy1);
                        _winBuf[p02] = this.calcValue(Cs, As, _winBuf[p02], wx0 * wy2);
                        _winBuf[p12] = this.calcValue(Cs, As, _winBuf[p12], wx1 * wy2);
                        _winBuf[p22] = this.calcValue(Cs, As, _winBuf[p22], wx2 * wy2);
                        _winBuf[p32] = this.calcValue(Cs, As, _winBuf[p32], wx3 * wy2);
                        _winBuf[p03] = this.calcValue(Cs, As, _winBuf[p03], wx0 * wy3);
                        _winBuf[p13] = this.calcValue(Cs, As, _winBuf[p13], wx1 * wy3);
                        _winBuf[p23] = this.calcValue(Cs, As, _winBuf[p23], wx2 * wy3);
                        _winBuf[p33] = this.calcValue(Cs, As, _winBuf[p33], wx3 * wy3);
                    }
                }
            } else {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }

        public static final /* synthetic */ void $anonfun$requestNextAuxData$3(NodeImpl.InHandlerImpl h) {
            block0: {
                if (!h.hasNext()) break block0;
                h.next();
            }
        }

        public static final /* synthetic */ void $anonfun$requestNextPenData$3(PenInHandler h) {
            block0: {
                if (!h.hasNext()) break block0;
                h.next();
            }
        }

        private final void goToOut$1() {
            block0: {
                this.nextP = true;
                this.stage = 3;
                this.outWritten = 0;
                if (!this.isAvailable(((FanInShape14)super.shape()).out())) break block0;
                this.processOutData();
            }
        }

        public Logic(FanInShape14<BufD, BufD, BufD, BufI, BufI, BufD, BufD, BufI, BufI, BufI, BufI, BufD, BufD, BufI, BufD> shape, int layer, Control ctrl) {
            super("PenImage", layer, shape, ctrl);
            OutHandler.$init$((OutHandler)this);
            this.de$sciss$fscape$stream$PenImage$Logic$$auxDataRem = 8;
            this.auxDataReady = false;
            this.de$sciss$fscape$stream$PenImage$Logic$$dstDataRem = 1;
            this.dstDataReady = false;
            this.de$sciss$fscape$stream$PenImage$Logic$$penDataRem = 5;
            this.penDataReady = false;
            this.hSrc = new PenInHandler(this, ((FanInShape14)super.shape()).in0());
            this.hAlpha = new PenInHandler(this, ((FanInShape14)super.shape()).in1());
            this.hX = new PenInHandler(this, ((FanInShape14)super.shape()).in5());
            this.hY = new PenInHandler(this, ((FanInShape14)super.shape()).in6());
            this.hNext = new PenInHandler(this, ((FanInShape14)super.shape()).in7());
            this.hDst = new DstInHandler(this, ((FanInShape14)super.shape()).in2());
            this.hWidth = new AuxInHandler(this, ((FanInShape14)super.shape()).in3());
            this.hHeight = new AuxInHandler(this, ((FanInShape14)super.shape()).in4());
            this.hRule = new AuxInHandler(this, ((FanInShape14)super.shape()).in8());
            this.hOp = new AuxInHandler(this, ((FanInShape14)super.shape()).in9());
            this.hWrap = new AuxInHandler(this, ((FanInShape14)super.shape()).in10());
            this.hRollOff = new AuxInHandler(this, ((FanInShape14)super.shape()).in11());
            this.hKaiserBeta = new AuxInHandler(this, ((FanInShape14)super.shape()).in12());
            this.hZeroCrossings = new AuxInHandler(this, ((FanInShape14)super.shape()).in13());
            this.penInHandlers = (PenInHandler[])((Object[])new PenInHandler[]{this.hSrc, this.hAlpha, this.hX, this.hY, this.hNext});
            this.auxInHandlers = (NodeImpl.InHandlerImpl[])((Object[])new NodeImpl.InHandlerImpl[]{this.hWidth, this.hHeight, this.hRule, this.hOp, this.hWrap, this.hRollOff, this.hKaiserBeta, this.hZeroCrossings});
            this.frameSize = -1;
            this.stage = 0;
            this.dstWritten = 0;
            this.setHandler(((FanInShape14)super.shape()).out(), this);
            this.nextP = true;
            this.outOff = 0;
            this.outWritten = 0;
        }

        public final class AuxInHandler<A, E extends BufLike>
        extends NodeImpl.InHandlerImpl<A, E> {
            @Override
            public void notifyValue() {
                block0: {
                    --this.de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$auxDataRem;
                    if (this.de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$auxDataRem != 0) break block0;
                    this.de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$notifyAuxDataReady();
                }
            }

            public /* synthetic */ Logic de$sciss$fscape$stream$PenImage$Logic$AuxInHandler$$$outer() {
                return (Logic)this.$outer;
            }

            public AuxInHandler(Logic $outer, Inlet<E> in) {
                super($outer, in);
            }
        }

        public final class DstInHandler<A, E extends BufLike>
        extends NodeImpl.InHandlerImpl<A, E> {
            @Override
            public void notifyValue() {
                block0: {
                    --this.de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$dstDataRem;
                    if (this.de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$dstDataRem != 0) break block0;
                    this.de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$notifyDstDataReady();
                }
            }

            public /* synthetic */ Logic de$sciss$fscape$stream$PenImage$Logic$DstInHandler$$$outer() {
                return (Logic)this.$outer;
            }

            public DstInHandler(Logic $outer, Inlet<E> in) {
                super($outer, in);
            }
        }

        public final class PenInHandler<A, E extends BufLike>
        extends NodeImpl.InHandlerImpl<A, E> {
            @Override
            public void notifyValue() {
                block0: {
                    --this.de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$penDataRem;
                    if (this.de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$penDataRem != 0) break block0;
                    this.de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer().de$sciss$fscape$stream$PenImage$Logic$$notifyPenDataReady();
                }
            }

            public /* synthetic */ Logic de$sciss$fscape$stream$PenImage$Logic$PenInHandler$$$outer() {
                return (Logic)this.$outer;
            }

            public PenInHandler(Logic $outer, Inlet<E> in) {
                super($outer, in);
            }
        }
    }

    public static final class Stage
    extends StageImpl<FanInShape14<BufD, BufD, BufD, BufI, BufI, BufD, BufD, BufI, BufI, BufI, BufI, BufD, BufD, BufI, BufD>> {
        private final int layer;
        private final Control ctrl;
        private final FanInShape14<BufD, BufD, BufD, BufI, BufI, BufD, BufD, BufI, BufI, BufI, BufI, BufD, BufD, BufI, BufD> shape;

        public FanInShape14<BufD, BufD, BufD, BufI, BufI, BufD, BufD, BufI, BufI, BufI, BufI, BufD, BufD, BufI, BufD> shape() {
            return this.shape;
        }

        public Logic createLogic(Attributes attr) {
            return new Logic(this.shape(), this.layer, this.ctrl);
        }

        public Stage(int layer, Control ctrl) {
            this.layer = layer;
            this.ctrl = ctrl;
            super("PenImage");
            this.shape = new FanInShape14(de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(4).append(this.name()).append(".src").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(6).append(this.name()).append(".alpha").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(4).append(this.name()).append(".dst").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(6).append(this.name()).append(".width").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(7).append(this.name()).append(".height").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(2).append(this.name()).append(".x").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(2).append(this.name()).append(".y").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".next").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".rule").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(3).append(this.name()).append(".op").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".wrap").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(8).append(this.name()).append(".rollOff").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(11).append(this.name()).append(".kaiserBeta").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(14).append(this.name()).append(".zeroCrossings").toString()), de.sciss.fscape.stream.package$.MODULE$.OutD(new StringBuilder(4).append(this.name()).append(".out").toString()));
        }
    }
}

