/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import akka.stream.Attributes;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import de.sciss.fscape.Util$;
import de.sciss.fscape.package$;
import de.sciss.fscape.stream.BufD;
import de.sciss.fscape.stream.BufI;
import de.sciss.fscape.stream.Builder;
import de.sciss.fscape.stream.Control;
import de.sciss.fscape.stream.StrongestLocalMaxima$;
import de.sciss.fscape.stream.impl.AuxInHandlerImpl;
import de.sciss.fscape.stream.impl.ChunkImpl;
import de.sciss.fscape.stream.impl.FilterLogicImpl;
import de.sciss.fscape.stream.impl.In7Out2Shape;
import de.sciss.fscape.stream.impl.InOutImpl;
import de.sciss.fscape.stream.impl.NodeImpl;
import de.sciss.fscape.stream.impl.ProcessInHandlerImpl;
import de.sciss.fscape.stream.impl.StageImpl;
import de.sciss.fscape.stream.impl.WindowedLogicImpl;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0005x!\u0002#F\u0011\u0003qe!\u0002)F\u0011\u0003\t\u0006\"\u0002-\u0002\t\u0003I\u0006\"\u0002.\u0002\t\u0003Y\u0006bB?\u0002\u0005\u0004%iA \u0005\b\u0003\u0007\t\u0001\u0015!\u0004\u0000\u000b\u0019\t)!\u0001\u0003\u0002\b\u00191\u0011qD\u0001\u0007\u0003CA!\"!\f\b\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\t)d\u0002B\u0001B\u0003-\u0011q\u0007\u0005\u00071\u001e!\t!!\u0010\t\u0013\u0005\u001dsA1A\u0005\u0002\u0005%\u0003\u0002CA&\u000f\u0001\u0006I!a\u0002\t\u000f\u00055s\u0001\"\u0001\u0002P\u00191\u00111K\u0001\u0007\u0003+BA\"a\u0012\u000f\u0005\u0003\u0005\u000b\u0011BA\u0015\u0003_BA\"!\f\u000f\u0005\u0003\u0005\u000b\u0011BA\u0018\u0003cBA\"!\u000e\u000f\u0005\u0003\u0005\u000b1BA\u001c\u0003gBa\u0001\u0017\b\u0005\u0002\u0005]\u0004bCAA\u001d\u0001\u0007\t\u0011)Q\u0005\u0003\u0007C1\"a$\u000f\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004\"Y\u0011\u0011\u0013\bA\u0002\u0003\u0005\u000b\u0015BAJ\u0011-\tYJ\u0004a\u0001\u0002\u0003\u0006K!a!\t\u0011\u0005ue\u0002)Q\u0005\u0003+C!\u0002\u001e\bA\u0002\u0003\u0005\u000b\u0015BAK\u0011)1h\u00021A\u0001B\u0003&\u0011Q\u0013\u0005\u000bq:\u0001\r\u0011!Q!\n\u0005%\u0005B\u0003>\u000f\u0001\u0004\u0005\t\u0015)\u0003\u0002\n\"A\u0011q\u0014\b!B\u0013\t)\nC\u0006\u0002\":\u0001\r\u00111A\u0005\u0012\u0005\r\u0006bCAS\u001d\u0001\u0007\t\u0019!C\t\u0003OC1\"a-\u000f\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u0011Q\u0017\bA\u0002\u0003\u0005\u000b\u0015BA\r\u0011-\t9L\u0004a\u0001\u0002\u0003\u0006K!!\u0007\t\u0017\u0005ef\u00021A\u0001B\u0003&\u0011\u0011\u0004\u0005\f\u0003ws\u0001\u0019!A!B\u0013\t\u0019\u0002C\u0006\u0002>:\u0001\r\u0011!Q!\n\u0005M\u0001bCA`\u001d\u0001\u0007\t\u0011)Q\u0005\u00033A1\"!1\u000f\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u00111\u0019\bA\u0002\u0003\u0005\u000b\u0015BA\n\u0011\u001d\t)M\u0004C\t\u0003\u000fD\u0001\"a4\u000fA\u0003&\u0011\u0011\u001b\u0005\t\u0003/t\u0001\u0015)\u0003\u0002R\"A\u0011\u0011\u001c\b!B\u0013\t\t\u000eC\u0004\u0002\\:!\t!!8\t\u000f\u0005}g\u0002\"\u0001\u0002^\"9\u0011\u0011\u001d\b\u0005\u0002\u0005ugABAr\u001d\u0019\t)\u000f\u0003\u0006\u0002|>\u0012\t\u0011)A\u0005\u0003{Da\u0001W\u0018\u0005\u0002\tm\u0001b\u0002B\u0012_\u0011\u0005!Q\u0005\u0005\b\u0005OyC\u0011\tB\u0015\u0011\u001d\u0011)E\u0004C\u0001\u0005KAqAa\u0012\u000f\t#\u0011I\u0005C\u0004\u0003P9!\tB!\u0015\t\u000f\tMc\u0002\"\u0015\u0003&!9!Q\u000b\b\u0005\u0012\tE\u0003b\u0002B,\u001d\u0011E!Q\u0005\u0005\b\u00053rA\u0011\u0003B\u0013\u0011\u001d\u0011YF\u0004C\u0001\u0005KAqA!\u0018\u000f\t#\u0011y\u0006C\u0004\u0003l9!\tB!\u001c\t\u000f\ted\u0002\"\u0005\u0003|!9!q\u0011\b\u0005\u0012\t%\u0005b\u0002BG\u001d\u0011%!q\u0012\u0005\b\u0005CsA\u0011\u0002BR\u0011\u001d\u00119L\u0004C\u0005\u0005sCaBa5\u000f!\u0003\r\t\u0011!C\u0005\u0005+\fy'\u0001\u000bTiJ|gnZ3ti2{7-\u00197NCbLW.\u0019\u0006\u0003\r\u001e\u000baa\u001d;sK\u0006l'B\u0001%J\u0003\u001917oY1qK*\u0011!jS\u0001\u0006g\u000eL7o\u001d\u0006\u0002\u0019\u0006\u0011A-Z\u0002\u0001!\ty\u0015!D\u0001F\u0005Q\u0019FO]8oO\u0016\u001cH\u000fT8dC2l\u0015\r_5nCN\u0011\u0011A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0002+\u0006)1oY1mC&\u0011q\u000b\u0016\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0015!B1qa2LH\u0003\u0003/m]N,x/_>\u0015\u0005u;\u0007\u0003B*_A\u0002L!a\u0018+\u0003\rQ+\b\u000f\\33!\t\tGM\u0004\u0002PE&\u00111-R\u0001\ba\u0006\u001c7.Y4f\u0013\t)gM\u0001\u0003PkR$%BA2F\u0011\u0015A7\u0001q\u0001j\u0003\u0005\u0011\u0007CA(k\u0013\tYWIA\u0004Ck&dG-\u001a:\t\u000b5\u001c\u0001\u0019\u00011\u0002\u0005%t\u0007\"B8\u0004\u0001\u0004\u0001\u0018\u0001B:ju\u0016\u0004\"!Y9\n\u0005I4'\u0001B(vi&CQ\u0001^\u0002A\u0002A\fa!\\5o\u0019\u0006<\u0007\"\u0002<\u0004\u0001\u0004\u0001\u0018AB7bq2\u000bw\rC\u0003y\u0007\u0001\u0007\u0001-\u0001\u0004uQJ,7\u000f\u001b\u0005\u0006u\u000e\u0001\r\u0001Y\u0001\u000b_\u000e$\u0018M^3D_N$\b\"\u0002?\u0004\u0001\u0004\u0001\u0018a\u00018v[\u0006!a.Y7f+\u0005yxBAA\u0001C\u0005!\u0015!\u00028b[\u0016\u0004#!B*iCB,\u0007CFA\u0005\u0003\u001f\t\u0019\"!\u0007\u0002\u001a\u0005e\u00111CA\n\u00033\t\u0019\"a\u0005\u000e\u0005\u0005-!bAA\u0007\u000b\u0006!\u0011.\u001c9m\u0013\u0011\t\t\"a\u0003\u0003\u0019%swgT;ueMC\u0017\r]3\u0011\u0007=\u000b)\"C\u0002\u0002\u0018\u0015\u0013AAQ;g\tB\u0019q*a\u0007\n\u0007\u0005uQI\u0001\u0003Ck\u001aL%!B*uC\u001e,7cA\u0004\u0002$A1\u0011\u0011BA\u0013\u0003SIA!a\n\u0002\f\tI1\u000b^1hK&k\u0007\u000f\u001c\t\u0004\u0003W1Q\"A\u0001\u0002\u000b1\f\u00170\u001a:\u0011\u0007\u0005\f\t$C\u0002\u00024\u0019\u0014Q\u0001T1zKJ\fAa\u0019;sYB\u0019q*!\u000f\n\u0007\u0005mRIA\u0004D_:$(o\u001c7\u0015\t\u0005}\u0012Q\t\u000b\u0005\u0003\u0003\n\u0019\u0005E\u0002\u0002,\u001dAq!!\u000e\u000b\u0001\b\t9\u0004C\u0004\u0002.)\u0001\r!a\f\u0002\u000bMD\u0017\r]3\u0016\u0005\u0005\u001d\u0011AB:iCB,\u0007%A\u0006de\u0016\fG/\u001a'pO&\u001cG\u0003BA)\u0005/\u00042!a\u000b\u000f\u0005\u0015aunZ5d'%q\u0011qKA/\u0003G\nI\u0007\u0005\u0004\u0002\n\u0005e\u0013\u0011F\u0005\u0005\u00037\nYA\u0001\u0005O_\u0012,\u0017*\u001c9m!\u0019\tI!a\u0018\u0002*%!\u0011\u0011MA\u0006\u0005E9\u0016N\u001c3po\u0016$Gj\\4jG&k\u0007\u000f\u001c\t\u0007\u0003\u0013\t)'!\u000b\n\t\u0005\u001d\u00141\u0002\u0002\u000e\rVdG.\u00138PkRLU\u000e\u001d7\u0011\u0011\u0005%\u00111NA\n\u0003SIA!!\u001c\u0002\f\tya)\u001b7uKJdunZ5d\u00136\u0004H.\u0003\u0003\u0002H\u0005e\u0013\u0002BA\u0017\u00033JA!!\u001e\u0002Z\u000591m\u001c8ue>dGCBA=\u0003{\ny\b\u0006\u0003\u0002R\u0005m\u0004bBA\u001b%\u0001\u000f\u0011q\u0007\u0005\b\u0003\u000f\u0012\u0002\u0019AA\u0015\u0011\u001d\tiC\u0005a\u0001\u0003_\tQ!Y2Ck\u001a\u0004RaUAC\u0003\u0013K1!a\"U\u0005\u0015\t%O]1z!\r\u0019\u00161R\u0005\u0004\u0003\u001b#&A\u0002#pk\ndW-\u0001\u0004mC\u001e\u0014UOZ\u0001\bY\u0006<\u0017JQ;g!\u0015\u0019\u0016QQAK!\r\u0019\u0016qS\u0005\u0004\u00033#&aA%oi\u0006Y1\u000f\u001e:f]\u001e$\bNQ;g\u0003\u0019\t7mU5{K\u0006Aa.^7QCRD7/\u0001\u0004ck\u001aLe\u000eM\u000b\u0003\u0003'\t!BY;g\u0013:\u0004t\fJ3r)\u0011\tI+a,\u0011\u0007M\u000bY+C\u0002\u0002.R\u0013A!\u00168ji\"I\u0011\u0011\u0017\u0010\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0014a\u00022vM&s\u0007\u0007I\u0001\u0007EV4\u0017J\\\u0019\u0002\r\t,h-\u001383\u0003\u0019\u0011WOZ%og\u00051!-\u001e4J]R\naAY;g\u0013:,\u0014A\u00022vM&sg'A\u0004ck\u001a|U\u000f\u001e\u0019\u0002\u000f\t,hmT;uc\u0005\u0019\u0011N\u001c\u0019\u0016\u0005\u0005%\u0007cA1\u0002L&\u0019\u0011Q\u001a4\u0003\u0007%sG)\u0001\u0005`G\u0006t'+Z1e!\r\u0019\u00161[\u0005\u0004\u0003+$&a\u0002\"p_2,\u0017M\\\u0001\t?&tg+\u00197jI\u0006IqlY1o/JLG/Z\u0001\bG\u0006t'+Z1e+\t\t\t.A\u0004j]Z\u000bG.\u001b3\u0002\u0011\r\fgn\u0016:ji\u0016\u0014abT;u\u0011\u0006tG\r\\3s\u00136\u0004H.\u0006\u0003\u0002h\n%1\u0003B\u0018S\u0003S\u0004B!a;\u0002x6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0A\u0003ti\u0006<WMC\u0002G\u0003gT!!!>\u0002\t\u0005\\7.Y\u0005\u0005\u0003s\fiO\u0001\u0006PkRD\u0015M\u001c3mKJ\f1a\\;u!\u0019\tyP!\u0001\u0003\u00065\u0011\u0011\u0011_\u0005\u0005\u0005\u0007\t\tP\u0001\u0004PkRdW\r\u001e\t\u0005\u0005\u000f\u0011I\u0001\u0004\u0001\u0005\u000f\t-qF1\u0001\u0003\u000e\t\t\u0011)\u0005\u0003\u0003\u0010\tU\u0001cA*\u0003\u0012%\u0019!1\u0003+\u0003\u000f9{G\u000f[5oOB\u00191Ka\u0006\n\u0007\teAKA\u0002B]f$BA!\b\u0003\"A)!qD\u0018\u0003\u00065\ta\u0002C\u0004\u0002|F\u0002\r!!@\u0002\r=t\u0007+\u001e7m)\t\tI+\u0001\np]\u0012{wO\\:ue\u0016\fWNR5oSNDG\u0003BAU\u0005WAqA!\f4\u0001\u0004\u0011y#A\u0003dCV\u001cX\r\u0005\u0003\u00032\t}b\u0002\u0002B\u001a\u0005{qAA!\u000e\u0003<5\u0011!q\u0007\u0006\u0004\u0005si\u0015A\u0002\u001fs_>$h(C\u0001V\u0013\t\u0019G+\u0003\u0003\u0003B\t\r#!\u0003+ie><\u0018M\u00197f\u0015\t\u0019G+\u0001\bva\u0012\fG/Z\"b]^\u0013\u0018\u000e^3\u0002\u0013]\u0014\u0018\u000e^3PkR\u001cH\u0003BAU\u0005\u0017BqA!\u00146\u0001\u0004\t)*A\u0002pM\u001a\f!#\u00197m_\u000e|U\u000f\u001e9vi\n+hMZ3sgR\u0011\u0011QS\u0001\bgR|\u0007\u000f]3e\u0003\u001d\u0011X-\u00193J]N\f\u0001C\u001a:fK&s\u0007/\u001e;Ck\u001a4WM]:\u0002#\u0019\u0014X-Z(viB,HOQ;gM\u0016\u00148/A\u0007va\u0012\fG/Z\"b]J+\u0017\rZ\u0001\u0010gR\f'\u000f\u001e(fqR<\u0016N\u001c3poR!!\u0011\rB4!\r\u0019&1M\u0005\u0004\u0005K\"&\u0001\u0002'p]\u001eDqA!\u001b=\u0001\u0004\t)*A\u0003j]>3g-A\td_BL\u0018J\u001c9viR{w+\u001b8e_^$\u0002\"!+\u0003p\tE$Q\u000f\u0005\b\u0005Sj\u0004\u0019AAK\u0011\u001d\u0011\u0019(\u0010a\u0001\u0005C\nQb\u001e:ji\u0016$vnV5o\u001f\u001a4\u0007b\u0002B<{\u0001\u0007\u0011QS\u0001\u0006G\",hn[\u0001\u0013G>\u0004\u0018pV5oI><Hk\\(viB,H\u000f\u0006\u0005\u0002*\nu$\u0011\u0011BC\u0011\u001d\u0011yH\u0010a\u0001\u0005C\naB]3bI\u001a\u0013x.\\,j]>3g\rC\u0004\u0003\u0004z\u0002\r!!&\u0002\r=,Ho\u00144g\u0011\u001d\u00119H\u0010a\u0001\u0003+\u000bQ\u0002\u001d:pG\u0016\u001c8oV5oI><H\u0003\u0002B1\u0005\u0017CqAa\u001d@\u0001\u0004\u0011\t'\u0001\u0006tS:\u001c\u0017J\u001c;feB$\"\"!#\u0003\u0012\nU%\u0011\u0014BO\u0011\u001d\u0011\u0019\n\u0011a\u0001\u0003\u0007\u000b!\u0001_:\t\u000f\t]\u0005\t1\u0001\u0002\u0016\u0006\u0019A.\u001a8\t\u000f\tm\u0005\t1\u0001\u0002\n\u0006\t\u0001\u0010C\u0004\u0003 \u0002\u0003\r!!&\u0002\u00115\f\u0007\u0010R3qi\"\fq\"[7qe>4X-\u0012=ue\u0016lW/\u001c\u000b\r\u0005K\u00139K!+\u0003,\n=&1\u0017\t\u0007'z\u000bI)!#\t\u000f\tM\u0015\t1\u0001\u0002\u0004\"9!qS!A\u0002\u0005U\u0005b\u0002BW\u0003\u0002\u0007\u0011QS\u0001\u0003SbDqA!-B\u0001\u0004\t)*A\u0007j]R,'\u000f]8mCRLwN\u001c\u0005\b\u0005k\u000b\u0005\u0019AAi\u0003%I7/T1yS6,X.A\u0007nS:LW.\u001b>f\u0005J,g\u000e\u001e\u000b\t\u0005w\u00139Ma3\u0003PR!!Q\u0015B_\u0011\u001d\u0011yL\u0011a\u0001\u0005\u0003\f\u0011A\u001a\t\b'\n\r\u0017\u0011RAE\u0013\r\u0011)\r\u0016\u0002\n\rVt7\r^5p]FBqA!3C\u0001\u0004\tI)\u0001\u0002ba!9!Q\u001a\"A\u0002\u0005%\u0015A\u000121\u0011\u001d\u0011\tN\u0011a\u0001\u0003\u0013\u000b\u0011\u0002^8mKJ\fgnY3\u0002\u0017M,\b/\u001a:%g\"\f\u0007/Z\u000b\u0003\u0003SAqA!7\u000e\u0001\u0004\u0011Y.\u0001\u0003biR\u0014\b\u0003BA\u0000\u0005;LAAa8\u0002r\nQ\u0011\t\u001e;sS\n,H/Z:")
public final class StrongestLocalMaxima {
    public static Tuple2<Outlet<BufD>, Outlet<BufD>> apply(Outlet<BufD> outlet, Outlet<BufI> outlet2, Outlet<BufI> outlet3, Outlet<BufI> outlet4, Outlet<BufD> outlet5, Outlet<BufD> outlet6, Outlet<BufI> outlet7, Builder builder) {
        return StrongestLocalMaxima$.MODULE$.apply(outlet, outlet2, outlet3, outlet4, outlet5, outlet6, outlet7, builder);
    }

    public static final class Logic
    extends NodeImpl<In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD>>
    implements WindowedLogicImpl<In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD>>,
    FilterLogicImpl<BufD, In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD>> {
        private double[] acBuf;
        private double[] lagBuf;
        private int[] lagIBuf;
        private double[] strengthBuf;
        private int acSize;
        private int minLag;
        private int maxLag;
        private double thresh;
        private double octaveCost;
        private int numPaths;
        private BufD bufIn0;
        private BufI bufIn1;
        private BufI bufIn2;
        private BufI bufIn3;
        private BufD bufIn4;
        private BufD bufIn5;
        private BufI bufIn6;
        private BufD bufOut0;
        private BufD bufOut1;
        private boolean _canRead;
        private boolean _inValid;
        private boolean _canWrite;
        private long de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinOff;
        private long de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinRemain;
        private long de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinOff;
        private long de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinRemain;
        private boolean de$sciss$fscape$stream$impl$WindowedLogicImpl$$isNextWindow;
        private int inOff;
        private int inRemain;
        private int outOff;
        private int outRemain;
        private boolean de$sciss$fscape$stream$impl$ChunkImpl$$outSent;

        @Override
        public final boolean inputsEnded() {
            return FilterLogicImpl.inputsEnded$(this);
        }

        @Override
        public final boolean processChunk() {
            return WindowedLogicImpl.processChunk$(this);
        }

        @Override
        public final boolean shouldComplete() {
            return WindowedLogicImpl.shouldComplete$(this);
        }

        @Override
        public final void process() {
            ChunkImpl.process$(this);
        }

        @Override
        public final <A> boolean isInAvailable(Inlet<A> in) {
            return InOutImpl.isInAvailable$(this, in);
        }

        @Override
        public final <A> boolean isOutAvailable(Outlet<A> out) {
            return InOutImpl.isOutAvailable$(this, out);
        }

        @Override
        public final <A> void setInHandler(Inlet<A> in, InHandler h) {
            InOutImpl.setInHandler$(this, in, h);
        }

        @Override
        public final <A> void setOutHandler(Outlet<A> out, OutHandler h) {
            InOutImpl.setOutHandler$(this, out, h);
        }

        @Override
        public final long de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinOff() {
            return this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinOff;
        }

        @Override
        public final void de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinOff_$eq(long x$1) {
            this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinOff = x$1;
        }

        @Override
        public final long de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinRemain() {
            return this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinRemain;
        }

        @Override
        public final void de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinRemain_$eq(long x$1) {
            this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$writeToWinRemain = x$1;
        }

        @Override
        public final long de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinOff() {
            return this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinOff;
        }

        @Override
        public final void de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinOff_$eq(long x$1) {
            this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinOff = x$1;
        }

        @Override
        public final long de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinRemain() {
            return this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinRemain;
        }

        @Override
        public final void de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinRemain_$eq(long x$1) {
            this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$readFromWinRemain = x$1;
        }

        @Override
        public final boolean de$sciss$fscape$stream$impl$WindowedLogicImpl$$isNextWindow() {
            return this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$isNextWindow;
        }

        @Override
        public final void de$sciss$fscape$stream$impl$WindowedLogicImpl$$isNextWindow_$eq(boolean x$1) {
            this.de$sciss$fscape$stream$impl$WindowedLogicImpl$$isNextWindow = x$1;
        }

        @Override
        public final int inOff() {
            return this.inOff;
        }

        @Override
        public final void inOff_$eq(int x$1) {
            this.inOff = x$1;
        }

        @Override
        public final int inRemain() {
            return this.inRemain;
        }

        @Override
        public final void inRemain_$eq(int x$1) {
            this.inRemain = x$1;
        }

        @Override
        public final int outOff() {
            return this.outOff;
        }

        @Override
        public final void outOff_$eq(int x$1) {
            this.outOff = x$1;
        }

        @Override
        public final int outRemain() {
            return this.outRemain;
        }

        @Override
        public final void outRemain_$eq(int x$1) {
            this.outRemain = x$1;
        }

        @Override
        public final boolean de$sciss$fscape$stream$impl$ChunkImpl$$outSent() {
            return this.de$sciss$fscape$stream$impl$ChunkImpl$$outSent;
        }

        @Override
        public final void de$sciss$fscape$stream$impl$ChunkImpl$$outSent_$eq(boolean x$1) {
            this.de$sciss$fscape$stream$impl$ChunkImpl$$outSent = x$1;
        }

        public /* synthetic */ In7Out2Shape de$sciss$fscape$stream$StrongestLocalMaxima$Logic$$super$shape() {
            return (In7Out2Shape)((Object)super.shape());
        }

        @Override
        public BufD bufIn0() {
            return this.bufIn0;
        }

        @Override
        public void bufIn0_$eq(BufD x$1) {
            this.bufIn0 = x$1;
        }

        @Override
        public Inlet<BufD> in0() {
            return ((In7Out2Shape)((Object)super.shape())).in0();
        }

        @Override
        public boolean canRead() {
            return this._canRead;
        }

        @Override
        public boolean inValid() {
            return this._inValid;
        }

        @Override
        public boolean canWrite() {
            return this._canWrite;
        }

        @Override
        public void updateCanWrite() {
            In7Out2Shape sh = (In7Out2Shape)((Object)super.shape());
            this._canWrite = !(!this.isClosed(sh.out0()) && !this.isAvailable(sh.out0()) || !this.isClosed(sh.out1()) && !this.isAvailable(sh.out1()));
        }

        @Override
        public void writeOuts(int off) {
            if (off > 0 && this.isAvailable(((In7Out2Shape)((Object)super.shape())).out0())) {
                this.bufOut0.size_$eq(off);
                this.push(((In7Out2Shape)((Object)super.shape())).out0(), this.bufOut0);
            } else {
                this.bufOut0.release(super.control());
            }
            if (off > 0 && this.isAvailable(((In7Out2Shape)((Object)super.shape())).out1())) {
                this.bufOut1.size_$eq(off);
                this.push(((In7Out2Shape)((Object)super.shape())).out1(), this.bufOut1);
            } else {
                this.bufOut1.release(super.control());
            }
            this.bufOut0 = null;
            this.bufOut1 = null;
            this._canWrite = false;
        }

        @Override
        public int allocOutputBuffers() {
            this.bufOut0 = super.control().borrowBufD();
            this.bufOut1 = super.control().borrowBufD();
            return this.bufOut0.size();
        }

        @Override
        public void stopped() {
            this.acBuf = null;
            this.lagBuf = null;
            this.lagIBuf = null;
            this.strengthBuf = null;
            this.freeInputBuffers();
            this.freeOutputBuffers();
        }

        @Override
        public int readIns() {
            this.freeInputBuffers();
            In7Out2Shape sh = (In7Out2Shape)((Object)super.shape());
            this.bufIn0_$eq((BufD)this.grab(sh.in0()));
            this.bufIn0().assertAllocated();
            this.tryPull(sh.in0());
            if (this.isAvailable(sh.in1())) {
                this.bufIn1 = (BufI)this.grab(sh.in1());
                this.tryPull(sh.in1());
            }
            if (this.isAvailable(sh.in2())) {
                this.bufIn2 = (BufI)this.grab(sh.in2());
                this.tryPull(sh.in2());
            }
            if (this.isAvailable(sh.in3())) {
                this.bufIn3 = (BufI)this.grab(sh.in3());
                this.tryPull(sh.in3());
            }
            if (this.isAvailable(sh.in4())) {
                this.bufIn4 = (BufD)this.grab(sh.in4());
                this.tryPull(sh.in4());
            }
            if (this.isAvailable(sh.in5())) {
                this.bufIn5 = (BufD)this.grab(sh.in5());
                this.tryPull(sh.in5());
            }
            if (this.isAvailable(sh.in6())) {
                this.bufIn6 = (BufI)this.grab(sh.in6());
                this.tryPull(sh.in6());
            }
            this._inValid = true;
            this._canRead = false;
            return this.bufIn0().size();
        }

        @Override
        public void freeInputBuffers() {
            block6: {
                if (this.bufIn0() != null) {
                    this.bufIn0().release(super.control());
                    this.bufIn0_$eq((BufD)null);
                }
                if (this.bufIn1 != null) {
                    this.bufIn1.release(super.control());
                    this.bufIn1 = null;
                }
                if (this.bufIn2 != null) {
                    this.bufIn2.release(super.control());
                    this.bufIn2 = null;
                }
                if (this.bufIn3 != null) {
                    this.bufIn3.release(super.control());
                    this.bufIn3 = null;
                }
                if (this.bufIn4 != null) {
                    this.bufIn4.release(super.control());
                    this.bufIn4 = null;
                }
                if (this.bufIn5 != null) {
                    this.bufIn5.release(super.control());
                    this.bufIn5 = null;
                }
                if (this.bufIn6 == null) break block6;
                this.bufIn6.release(super.control());
                this.bufIn6 = null;
            }
        }

        @Override
        public void freeOutputBuffers() {
            block1: {
                if (this.bufOut0 != null) {
                    this.bufOut0.release(super.control());
                    this.bufOut0 = null;
                }
                if (this.bufOut1 == null) break block1;
                this.bufOut1.release(super.control());
                this.bufOut1 = null;
            }
        }

        @Override
        public void updateCanRead() {
            In7Out2Shape sh = (In7Out2Shape)((Object)super.shape());
            this._canRead = this.isAvailable(sh.in0()) && (this.isClosed(sh.in1()) && this._inValid || this.isAvailable(sh.in1())) && (this.isClosed(sh.in2()) && this._inValid || this.isAvailable(sh.in2())) && (this.isClosed(sh.in3()) && this._inValid || this.isAvailable(sh.in3())) && (this.isClosed(sh.in4()) && this._inValid || this.isAvailable(sh.in4())) && (this.isClosed(sh.in5()) && this._inValid || this.isAvailable(sh.in5())) && (this.isClosed(sh.in6()) && this._inValid || this.isAvailable(sh.in6()));
        }

        @Override
        public long startNextWindow(int inOff) {
            block7: {
                if (this.bufIn1 != null && inOff < this.bufIn1.size()) {
                    int oldSize = this.acSize;
                    int _winSize = scala.math.package$.MODULE$.max(2, this.bufIn1.buf()[inOff]);
                    if (_winSize != oldSize) {
                        this.acBuf = new double[_winSize];
                        this.acSize = _winSize;
                    }
                }
                if (this.bufIn2 != null && inOff < this.bufIn2.size()) {
                    this.minLag = scala.math.package$.MODULE$.max(1, this.bufIn2.buf()[inOff]);
                }
                if (this.bufIn3 != null && inOff < this.bufIn3.size()) {
                    this.maxLag = scala.math.package$.MODULE$.max(1, this.bufIn3.buf()[inOff]);
                }
                if (this.bufIn4 != null && inOff < this.bufIn4.size()) {
                    this.thresh = scala.math.package$.MODULE$.max(0.0, this.bufIn4.buf()[inOff]);
                }
                if (this.bufIn5 != null && inOff < this.bufIn5.size()) {
                    this.octaveCost = scala.math.package$.MODULE$.max(0.0, this.bufIn5.buf()[inOff]) / Util$.MODULE$.log2();
                }
                if (this.bufIn6 == null || inOff >= this.bufIn6.size()) break block7;
                int oldN = this.numPaths;
                this.numPaths = scala.math.package$.MODULE$.max(1, this.bufIn6.buf()[inOff]);
                if (this.numPaths != oldN) {
                    this.lagBuf = new double[this.numPaths];
                    this.lagIBuf = new int[this.numPaths];
                    this.strengthBuf = new double[this.numPaths];
                }
            }
            return this.acSize;
        }

        @Override
        public void copyInputToWindow(int inOff, long writeToWinOff, int chunk) {
            Util$.MODULE$.copy(this.bufIn0().buf(), inOff, this.acBuf, (int)writeToWinOff, chunk);
        }

        @Override
        public void copyWindowToOutput(long readFromWinOff, int outOff, int chunk) {
            int rOff = (int)readFromWinOff;
            Util$.MODULE$.copy(this.lagBuf, rOff, this.bufOut0.buf(), outOff, chunk);
            Util$.MODULE$.copy(this.strengthBuf, rOff, this.bufOut1.buf(), outOff, chunk);
        }

        @Override
        public long processWindow(long writeToWinOff) {
            int sz0 = (int)writeToWinOff;
            double[] _buf = this.acBuf;
            int _bufSz = this.acSize;
            if (sz0 < _bufSz) {
                Util$.MODULE$.clear(_buf, sz0, _bufSz - sz0);
            }
            int n = this.numPaths;
            Util$.MODULE$.clear(this.lagBuf, 0, n);
            Util$.MODULE$.clear(this.strengthBuf, 0, n);
            int _minLag = scala.math.package$.MODULE$.min(_bufSz - 1, this.minLag);
            int _maxLag = scala.math.package$.MODULE$.min(_bufSz - 1, this.maxLag);
            double _thresh = this.thresh;
            double vp = _buf[_minLag - 1];
            double vi = _buf[_minLag];
            int pathsTaken = 0;
            for (int li = _minLag; li < _maxLag; ++li) {
                double vn = _buf[li + 1];
                if (vi > _thresh && vp < vi && vn < vi) {
                    int pathIdx;
                    int n2;
                    double strength0;
                    double num = 0.5 * (vn - vp);
                    double denom = 2.0 * vi - (vn + vp);
                    double lag = (double)li + num / denom;
                    double strength = strength0 = this.sincInterp(_buf, _bufSz, lag, 30);
                    if (pathsTaken < n) {
                        int res;
                        n2 = res = pathsTaken++;
                    } else {
                        double strengthC;
                        double weakest = strengthC = strength + this.octaveCost * scala.math.package$.MODULE$.log((double)_maxLag / lag);
                        int res = -1;
                        for (int j = 0; j < n; ++j) {
                            double lagJ = this.lagBuf[j];
                            double strengthJ = this.strengthBuf[j] + this.octaveCost * scala.math.package$.MODULE$.log((double)_maxLag / lagJ);
                            if (!(strengthJ < weakest)) continue;
                            weakest = strengthJ;
                            res = j;
                        }
                        n2 = pathIdx = res;
                    }
                    if (pathIdx >= 0) {
                        this.lagBuf[pathIdx] = lag;
                        this.lagIBuf[pathIdx] = li;
                        this.strengthBuf[pathIdx] = strength;
                    }
                }
                vp = vi;
                vi = vn;
            }
            for (int pi = 0; pi < pathsTaken; ++pi) {
                Tuple2<Object, Object> tuple2 = this.improveExtremum(_buf, _bufSz, this.lagIBuf[pi], 4, true);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                double lagOut = tuple2._1$mcD$sp();
                double strengthOut = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(lagOut, strengthOut);
                Tuple2.mcDD.sp sp3 = sp2;
                double lagOut2 = sp3._1$mcD$sp();
                double strengthOut2 = sp3._2$mcD$sp();
                this.lagBuf[pi] = lagOut2;
                this.strengthBuf[pi] = strengthOut2;
            }
            return n;
        }

        private double sincInterp(double[] xs, int len, double x, int maxDepth) {
            double d;
            int midLeft = (int)x;
            int midRight = midLeft + 1;
            if (x >= (double)len) {
                d = xs[len - 1];
            } else if (x < 0.0) {
                d = xs[0];
            } else if (x == (double)midLeft) {
                d = xs[midLeft];
            } else {
                int maxDepthC = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.min(maxDepth, midLeft), len - midRight);
                if (maxDepthC <= 0) {
                    d = xs[(int)(x + 0.5)];
                } else if (maxDepthC == 1) {
                    d = xs[midLeft] + (x - (double)midLeft) * (xs[midRight] - xs[midLeft]);
                } else if (maxDepthC == 2) {
                    double yl = xs[midLeft];
                    double yr = xs[midRight];
                    double dyl = 0.5 * (yr - xs[midLeft - 1]);
                    double dyr = 0.5 * (xs[midRight + 1] - yl);
                    double fil = x - (double)midLeft;
                    double fir = (double)midRight - x;
                    d = yl * fir + yr * fil - fil * fir * (0.5 * (dyr - dyl) + (fil - 0.5) * (dyl + dyr - (double)2 * (yr - yl)));
                } else {
                    int ix;
                    double res = 0.0;
                    int left = midRight - maxDepthC;
                    int right = midLeft + maxDepthC;
                    double a = Math.PI * (x - (double)midLeft);
                    double halfSinA = 0.5 * scala.math.package$.MODULE$.sin(a);
                    double aa = a / (x - (double)left + 1.0);
                    double daa = Math.PI / (x - (double)left + 1.0);
                    for (ix = midLeft; ix >= left; --ix) {
                        double d2 = halfSinA / a * (1.0 + scala.math.package$.MODULE$.cos(aa));
                        res += xs[ix] * d2;
                        a += Math.PI;
                        aa += daa;
                        halfSinA = -halfSinA;
                    }
                    a = Math.PI * ((double)midRight - x);
                    halfSinA = 0.5 * scala.math.package$.MODULE$.sin(a);
                    aa = a / ((double)right - x + 1.0);
                    daa = Math.PI / ((double)right - x + 1.0);
                    for (ix = midRight; ix <= right; ++ix) {
                        double d3 = halfSinA / a * (1.0 + scala.math.package$.MODULE$.cos(aa));
                        res += xs[ix] * d3;
                        a += Math.PI;
                        aa += daa;
                        halfSinA = -halfSinA;
                    }
                    d = res;
                }
            }
            return d;
        }

        private Tuple2<Object, Object> improveExtremum(double[] xs, int len, int ix, int interpolation, boolean isMaximum) {
            Tuple2.mcDD.sp sp2;
            if (ix <= 0) {
                sp2 = new Tuple2.mcDD.sp(0.0, xs[0]);
            } else if (ix >= len - 1) {
                sp2 = new Tuple2.mcDD.sp((double)(len - 1), xs[len - 1]);
            } else if (interpolation <= 0) {
                sp2 = new Tuple2.mcDD.sp((double)ix, xs[ix]);
            } else if (interpolation == 1) {
                double num = 0.5 * (xs[ix + 1] - xs[ix - 1]);
                double denom = 2.0 * xs[ix] - (xs[ix + 1] + xs[ix - 1]);
                double xOut = (double)ix + num / denom;
                double yOut = xs[ix] + 0.5 * num * num / denom;
                sp2 = new Tuple2.mcDD.sp(xOut, yOut);
            } else {
                int maxDepth = interpolation == 3 ? 70 : 700;
                Tuple2<Object, Object> tuple2 = this.minimizeBrent(ix - 1, ix + 1, 1.0E-10, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> {
                    double y = this.sincInterp(xs, len, x, maxDepth);
                    return isMaximum ? -y : y;
                });
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                double xOut = tuple2._1$mcD$sp();
                double yOut0 = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(xOut, yOut0);
                Tuple2.mcDD.sp sp4 = sp3;
                double xOut2 = sp4._1$mcD$sp();
                double yOut02 = sp4._2$mcD$sp();
                double yOut = isMaximum ? -yOut02 : yOut02;
                sp2 = new Tuple2.mcDD.sp(xOut2, yOut);
            }
            return sp2;
        }

        private Tuple2<Object, Object> minimizeBrent(double a0, double b0, double tolerance, Function1<Object, Object> f) {
            double golden = 0.3819660112501051;
            double eps = 1.0E-30;
            int iterMax = 60;
            double a = a0;
            double b = b0;
            Predef$.MODULE$.require(tolerance > 0.0 && a < b);
            double v = a + golden * (b - a);
            double fv = f.apply$mcDD$sp(v);
            double x = v;
            double w = v;
            double fx = fv;
            double fw = fv;
            for (int iter = 1; iter <= iterMax; ++iter) {
                double t;
                double ft;
                double range = b - a;
                double midRange = (a + b) / 2.0;
                double tolAct = eps * scala.math.package$.MODULE$.abs(x) + tolerance / 3.0;
                if (scala.math.package$.MODULE$.abs(x - midRange) + range / 2.0 <= 2.0 * tolAct) {
                    return new Tuple2.mcDD.sp(x, fx);
                }
                double newStep = golden * (x < midRange ? b - x : a - x);
                if (scala.math.package$.MODULE$.abs(x - w) >= tolAct) {
                    double t2 = (x - w) * (fx - fv);
                    double q = (x - v) * (fx - fw);
                    double p = (x - v) * q - (x - w) * t2;
                    if ((q = 2.0 * (q - t2)) > 0.0) {
                        p = -p;
                    } else {
                        q = -q;
                    }
                    if (scala.math.package$.MODULE$.abs(p) < scala.math.package$.MODULE$.abs(newStep * q) && p > q * (a - x + 2.0 * tolAct) && p < q * (b - x - 2.0 * tolAct)) {
                        newStep = p / q;
                    }
                }
                if (scala.math.package$.MODULE$.abs(newStep) < tolAct) {
                    double d = newStep = newStep > 0.0 ? tolAct : -tolAct;
                }
                if ((ft = f.apply$mcDD$sp(t = x + newStep)) <= fx) {
                    if (t < x) {
                        b = x;
                    } else {
                        a = x;
                    }
                    v = w;
                    w = x;
                    x = t;
                    fv = fw;
                    fw = fx;
                    fx = ft;
                    continue;
                }
                if (t < x) {
                    a = t;
                } else {
                    b = t;
                }
                if (ft <= fw || w == x) {
                    v = w;
                    w = t;
                    fv = fw;
                    fw = ft;
                    continue;
                }
                if (!(ft <= fv) && v != x && v != w) continue;
                v = t;
                fv = ft;
            }
            return new Tuple2.mcDD.sp(x, fx);
        }

        public Logic(In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD> shape, int layer, Control ctrl) {
            super("StrongestLocalMaxima", layer, shape, ctrl);
            InOutImpl.$init$(this);
            ChunkImpl.$init$(this);
            WindowedLogicImpl.$init$(this);
            FilterLogicImpl.$init$(this);
            this.acSize = 0;
            this.numPaths = 0;
            this._canRead = false;
            this._inValid = false;
            this._canWrite = false;
            new ProcessInHandlerImpl(((In7Out2Shape)((Object)super.shape())).in0(), this);
            new AuxInHandlerImpl(((In7Out2Shape)((Object)super.shape())).in1(), this);
            new AuxInHandlerImpl(((In7Out2Shape)((Object)super.shape())).in2(), this);
            new AuxInHandlerImpl(((In7Out2Shape)((Object)super.shape())).in3(), this);
            new AuxInHandlerImpl(((In7Out2Shape)((Object)super.shape())).in4(), this);
            new AuxInHandlerImpl(((In7Out2Shape)((Object)super.shape())).in5(), this);
            new AuxInHandlerImpl(((In7Out2Shape)((Object)super.shape())).in6(), this);
            new OutHandlerImpl(this, ((In7Out2Shape)((Object)super.shape())).out0());
            new OutHandlerImpl(this, ((In7Out2Shape)((Object)super.shape())).out1());
        }

        public final class OutHandlerImpl<A>
        implements OutHandler {
            private final Outlet<A> out;
            private final /* synthetic */ Logic $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onPull() {
                block0: {
                    package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("onPull(").append($this.out).append(")").toString());
                    this.$outer.updateCanWrite();
                    if (!this.$outer.canWrite()) break block0;
                    this.$outer.process();
                }
            }

            public void onDownstreamFinish(Throwable cause) {
                block0: {
                    boolean allClosed = this.$outer.de$sciss$fscape$stream$StrongestLocalMaxima$Logic$$super$shape().outlets().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.$outer.isClosed(x$1)));
                    package$.MODULE$.logStream((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("onDownstreamFinish(").append($this.out).append(") allClosed = ").append(allClosed).toString());
                    if (!allClosed) break block0;
                    OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                }
            }

            public OutHandlerImpl(Logic $outer, Outlet<A> out) {
                this.out = out;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                OutHandler.$init$((OutHandler)this);
                $outer.setOutHandler(out, this);
            }
        }
    }

    public static final class Stage
    extends StageImpl<In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD>> {
        private final int layer;
        private final Control ctrl;
        private final In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD> shape;

        public In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD> shape() {
            return this.shape;
        }

        public Logic createLogic(Attributes attr) {
            return new Logic((In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD>)this.shape(), this.layer, this.ctrl);
        }

        public Stage(int layer, Control ctrl) {
            this.layer = layer;
            this.ctrl = ctrl;
            super("StrongestLocalMaxima");
            this.shape = new In7Out2Shape<BufD, BufI, BufI, BufI, BufD, BufD, BufI, BufD, BufD>(de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(3).append(this.name()).append(".in").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".size").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(7).append(this.name()).append(".minLag").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(7).append(this.name()).append(".maxLag").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(7).append(this.name()).append(".thresh").toString()), de.sciss.fscape.stream.package$.MODULE$.InD(new StringBuilder(11).append(this.name()).append(".octaveCost").toString()), de.sciss.fscape.stream.package$.MODULE$.InI(new StringBuilder(2).append(this.name()).append(".n").toString()), de.sciss.fscape.stream.package$.MODULE$.OutD(new StringBuilder(5).append(this.name()).append(".lags").toString()), de.sciss.fscape.stream.package$.MODULE$.OutD(new StringBuilder(10).append(this.name()).append(".strengths").toString()));
        }
    }
}

