/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.swing.graph;

import de.sciss.audiowidgets.AxisFormat;
import de.sciss.lucre.swing.graph.AudioFileIn;
import de.sciss.synth.io.AudioFileSpec;
import de.sciss.synth.io.SampleFormat;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class AudioFileIn$ {
    public static AudioFileIn$ MODULE$;
    private AxisFormat.Time timeFmt;
    private final String keyPathFieldVisible;
    private final String keyFormatVisible;
    private final String defaultTitle;
    private final boolean defaultPathFieldVisible;
    private final boolean defaultFormatVisible;
    private volatile boolean bitmap$0;

    static {
        new AudioFileIn$();
    }

    public AudioFileIn apply() {
        return new AudioFileIn.Impl();
    }

    private AxisFormat.Time timeFmt$lzycompute() {
        AudioFileIn$ audioFileIn$ = this;
        synchronized (audioFileIn$) {
            if (!this.bitmap$0) {
                this.timeFmt = new AxisFormat.Time(false, true);
                this.bitmap$0 = true;
            }
        }
        return this.timeFmt;
    }

    private AxisFormat.Time timeFmt() {
        return !this.bitmap$0 ? this.timeFmt$lzycompute() : this.timeFmt;
    }

    public String specToString(AudioFileSpec spec) {
        String string;
        String smpFmt = this.formatToString(spec.sampleFormat());
        int n = spec.numChannels();
        switch (n) {
            case 1: {
                string = "mono";
                break;
            }
            case 2: {
                string = "stereo";
                break;
            }
            default: {
                string = new StringBuilder(6).append(n).append("-chan.").toString();
                break;
            }
        }
        String channels = string;
        double arg$macro$1 = spec.sampleRate() / (double)1000;
        String sr = new StringOps("%1.1f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
        String dur = this.timeFmt().format((double)spec.numFrames() / spec.sampleRate(), this.timeFmt().format$default$2(), this.timeFmt().format$default$3());
        String txt = new StringBuilder(10).append(spec.fileType().name()).append(", ").append(channels).append(" ").append(smpFmt).append(" ").append(sr).append(" kHz, ").append(dur).toString();
        return txt;
    }

    public String formatToString(SampleFormat smp) {
        SampleFormat sampleFormat = smp;
        boolean bl = SampleFormat.Float$.MODULE$.equals(sampleFormat) ? true : SampleFormat.Double$.MODULE$.equals(sampleFormat);
        String string = bl ? "float" : (SampleFormat.UInt8$.MODULE$.equals(sampleFormat) ? "uint" : "int");
        String smpTpe = string;
        String txt = new StringBuilder(5).append(smp.bitsPerSample()).append("-bit ").append(smpTpe).toString();
        return txt;
    }

    public String keyPathFieldVisible() {
        return this.keyPathFieldVisible;
    }

    public String keyFormatVisible() {
        return this.keyFormatVisible;
    }

    public String defaultTitle() {
        return this.defaultTitle;
    }

    public boolean defaultPathFieldVisible() {
        return this.defaultPathFieldVisible;
    }

    public boolean defaultFormatVisible() {
        return this.defaultFormatVisible;
    }

    private AudioFileIn$() {
        MODULE$ = this;
        this.keyPathFieldVisible = "pathFieldVisible";
        this.keyFormatVisible = "formatVisible";
        this.defaultTitle = "Select Audio Input File";
        this.defaultPathFieldVisible = true;
        this.defaultFormatVisible = true;
    }
}

