/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.synth;

import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.SampleFormat;
import de.sciss.lucre.synth.Buffer;
import de.sciss.lucre.synth.Buffer$;
import de.sciss.lucre.synth.NodeRef;
import de.sciss.lucre.synth.RT;
import de.sciss.lucre.synth.Resource;
import de.sciss.lucre.synth.Server;
import de.sciss.lucre.synth.impl.BufferImpl;
import de.sciss.osc.Bundle$;
import de.sciss.osc.Packet;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Buffer$ {
    public static final Buffer$ MODULE$ = new Buffer$();
    private static int cueBufSz = 32768;
    private static int recBufSz = 32768;

    private int cueBufSz() {
        return cueBufSz;
    }

    private void cueBufSz_$eq(int x$1) {
        cueBufSz = x$1;
    }

    private int recBufSz() {
        return recBufSz;
    }

    private void recBufSz_$eq(int x$1) {
        recBufSz = x$1;
    }

    public int defaultCueBufferSize() {
        return this.cueBufSz();
    }

    public void defaultCueBufferSize_$eq(int value) {
        this.validateCueBufferSize(64, value);
        this.cueBufSz_$eq(value);
    }

    public int defaultRecBufferSize() {
        return this.recBufSz();
    }

    public void defaultRecBufferSize_$eq(int value) {
        this.validateCueBufferSize(64, value);
        this.recBufSz_$eq(value);
    }

    private boolean isPowerOfTwo(int value) {
        return (value & value - 1) == 0;
    }

    private void validateCueBufferSize(Server server, int value) {
        this.validateCueBufferSize(server.config().blockSize(), value);
    }

    private void validateCueBufferSize(int minSize, int value) {
        Predef$.MODULE$.require(this.isPowerOfTwo(value) && value >= minSize && value <= 131072, (Function0 & Serializable)() -> new StringBuilder(42).append("Must be a power of two and in (").append(minSize).append(", 131072): ").append(value).toString());
    }

    public Resource disposeWithNode(Buffer buf, NodeRef nr) {
        Buffer buf0 = buf;
        return new Buffer.ProxyResource(buf0, nr){
            private final Buffer buf;
            private final NodeRef nr$1;

            public boolean isOnline(RT tx) {
                return Buffer.ProxyResource.isOnline$(this, tx);
            }

            public int timeStamp(RT tx) {
                return Buffer.ProxyResource.timeStamp$(this, tx);
            }

            public void timeStamp_$eq(int value, RT tx) {
                Buffer.ProxyResource.timeStamp_$eq$(this, value, tx);
            }

            public String toString() {
                return Buffer.ProxyResource.toString$(this);
            }

            public Server server() {
                return Buffer.ProxyResource.server$(this);
            }

            public Buffer buf() {
                return this.buf;
            }

            public void dispose(RT tx2) {
                this.nr$1.node(tx2).onEndTxn((Function1<RT, BoxedUnit>)(Function1 & Serializable)tx -> {
                    anon.1.$anonfun$dispose$1(this, tx);
                    return BoxedUnit.UNIT;
                }, tx2);
            }

            public static final /* synthetic */ void $anonfun$dispose$1(anon.1 $this, RT tx) {
                $this.buf().dispose(tx);
            }
            {
                this.nr$1 = nr$1;
                Buffer.ProxyResource.$init$(this);
                this.buf = buf0$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$dispose$1$adapted(de.sciss.lucre.synth.Buffer$$anon$1 de.sciss.lucre.synth.RT )}, serializedLambda);
            }
        };
    }

    public Resource writeWithNode(Buffer buf, NodeRef nr, String path, Function0<BoxedUnit> action, ExecutionContext exec) {
        Buffer buf0 = buf;
        return new Buffer.ProxyResource(buf0, nr, path, action, exec){
            private final Buffer buf;
            private final NodeRef nr$2;
            private final String path$1;
            private final Function0 action$1;
            private final ExecutionContext exec$1;

            public boolean isOnline(RT tx) {
                return Buffer.ProxyResource.isOnline$(this, tx);
            }

            public int timeStamp(RT tx) {
                return Buffer.ProxyResource.timeStamp$(this, tx);
            }

            public void timeStamp_$eq(int value, RT tx) {
                Buffer.ProxyResource.timeStamp_$eq$(this, value, tx);
            }

            public String toString() {
                return Buffer.ProxyResource.toString$(this);
            }

            public Server server() {
                return Buffer.ProxyResource.server$(this);
            }

            public Buffer buf() {
                return this.buf;
            }

            public void dispose(RT tx) {
                this.nr$2.node(tx).onEnd((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Packet[] packetArray = new Packet[1];
                    de.sciss.synth.Buffer qual$1 = this.buf().peer();
                    String x$12 = $this.path$1;
                    AudioFileType x$2 = qual$1.writeMsg$default$2();
                    SampleFormat x$3 = qual$1.writeMsg$default$3();
                    int x$4 = qual$1.writeMsg$default$4();
                    int x$5 = qual$1.writeMsg$default$5();
                    boolean x$6 = qual$1.writeMsg$default$6();
                    Option x$7 = qual$1.writeMsg$default$7();
                    packetArray[0] = qual$1.writeMsg(x$12, x$2, x$3, x$4, x$5, x$6, x$7);
                    Future<BoxedUnit> fut = this.buf().server().$bang$bang(Bundle$.MODULE$.now((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])packetArray)));
                    fut.foreach((Function1 & Serializable)x$1 -> {
                        anon.2.$anonfun$dispose$3(this, x$1);
                        return BoxedUnit.UNIT;
                    }, $this.exec$1);
                }, tx);
            }

            public static final /* synthetic */ void $anonfun$dispose$3(anon.2 $this, BoxedUnit x$1) {
                $this.action$1.apply$mcV$sp();
            }
            {
                this.nr$2 = nr$2;
                this.path$1 = path$1;
                this.action$1 = action$1;
                this.exec$1 = exec$1;
                Buffer.ProxyResource.$init$(this);
                this.buf = buf0$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$dispose$2(de.sciss.lucre.synth.Buffer$$anon$2 ), $anonfun$dispose$3$adapted(de.sciss.lucre.synth.Buffer$$anon$2 scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
    }

    public Buffer diskIn(Server server, String path, long startFrame, int numFrames, int numChannels, RT tx) {
        this.validateCueBufferSize(server, numFrames);
        BufferImpl res = this.create(server, numFrames, numChannels, true, tx);
        res.alloc(tx);
        res.cue(path, startFrame, res.cue$default$3(), tx);
        return res;
    }

    public long diskIn$default$3(Server server) {
        return 0L;
    }

    public int diskIn$default$4(Server server) {
        return this.defaultCueBufferSize();
    }

    public int diskIn$default$5(Server server) {
        return 1;
    }

    public Buffer diskOut(Server server, String path, AudioFileType fileType, SampleFormat sampleFormat, int numFrames, int numChannels, RT tx) {
        this.validateCueBufferSize(server, numFrames);
        BufferImpl res = this.create(server, numFrames, numChannels, true, tx);
        res.alloc(tx);
        res.record(path, fileType, sampleFormat, tx);
        return res;
    }

    public AudioFileType diskOut$default$3(Server server) {
        return AudioFileType.AIFF$.MODULE$;
    }

    public SampleFormat diskOut$default$4(Server server) {
        return SampleFormat.Float$.MODULE$;
    }

    public int diskOut$default$5(Server server) {
        return this.defaultRecBufferSize();
    }

    public int diskOut$default$6(Server server) {
        return 1;
    }

    public Buffer.Modifiable fft(Server server, int size, RT tx) {
        Predef$.MODULE$.require(size >= 2 && this.isPowerOfTwo(size), (Function0 & Serializable)() -> new StringBuilder(34).append("Must be a power of two and >= 2 : ").append(size).toString());
        BufferImpl res = this.create(server, size, 1, this.create$default$4(), tx);
        res.alloc(tx);
        return res;
    }

    public Buffer.Modifiable apply(Server server, int numFrames, int numChannels, RT tx) {
        BufferImpl res = this.create(server, numFrames, numChannels, this.create$default$4(), tx);
        res.alloc(tx);
        return res;
    }

    public int apply$default$3(Server server) {
        return 1;
    }

    public Buffer.Modifiable wrap(Server server, de.sciss.synth.Buffer peer, boolean closeOnDisposal, RT tx) {
        de.sciss.synth.Server server2 = server.peer();
        de.sciss.synth.Server server3 = peer.server();
        Predef$.MODULE$.require(!(server2 != null ? !server2.equals(server3) : server3 != null));
        BufferImpl res = new BufferImpl(server, peer, peer.numFrames(), peer.numChannels(), closeOnDisposal);
        return res.mkOnline(tx);
    }

    public boolean wrap$default$3() {
        return false;
    }

    private BufferImpl create(Server server, int numFrames, int numChannels, boolean closeOnDisposal, RT tx) {
        int id = server.allocBuffer(server.allocBuffer$default$1(), tx);
        de.sciss.synth.Buffer peer = new de.sciss.synth.Buffer(server.peer(), id);
        return new BufferImpl(server, peer, numFrames, numChannels, closeOnDisposal);
    }

    private boolean create$default$4() {
        return false;
    }

    private Buffer$() {
    }
}

